/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.Locale;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.techcable.srglib.ArrayType;
import net.techcable.srglib.JavaTypeSort;
import net.techcable.srglib.PrimitiveType;
import net.techcable.srglib.ReferenceType;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface JavaType {
    public String getInternalName();

    public String getDescriptor();

    public String getName();

    default public String getSimpleName() {
        return this.getName();
    }

    default public boolean isPrimitiveType() {
        return this.getSort() == JavaTypeSort.PRIMITIVE_TYPE;
    }

    default public boolean isArrayType() {
        return this.getSort() == JavaTypeSort.ARRAY_TYPE;
    }

    default public boolean isReferenceType() {
        return this.getSort() == JavaTypeSort.REFERENCE_TYPE;
    }

    public JavaTypeSort getSort();

    public JavaType mapClass(UnaryOperator<JavaType> var1);

    default public String getPackageName() {
        throw new IllegalStateException(this.getName() + " is not a reference type!");
    }

    default public JavaType getElementType() {
        throw new IllegalStateException(this.getName() + " is not an array type!");
    }

    public static JavaType createArray(int dimensions, JavaType elementType) {
        Objects.requireNonNull(elementType, "Null element type");
        if (dimensions == 0) {
            return elementType;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException("Negative dimensions: " + dimensions);
        }
        ArrayType result = new ArrayType(elementType);
        while (--dimensions > 0) {
            result = new ArrayType(result);
        }
        return result;
    }

    public static JavaType createArray(JavaType elementType) {
        return JavaType.createArray(1, elementType);
    }

    public static @NonNull JavaType fromName(String name) {
        Objects.requireNonNull(name, "Null name");
        if (name.endsWith("[]")) {
            ArrayType result;
            int dimensions = 0;
            do {
                ++dimensions;
            } while ((name = name.substring(0, name.length() - 2)).endsWith("[]"));
            JavaType elementType = JavaType.fromName(name);
            if (!1.$assertionsDisabled && elementType instanceof ArrayType) {
                throw new AssertionError();
            }
            do {
                result = new ArrayType(elementType);
                elementType = result;
            } while (--dimensions > 0);
            return result;
        }
        try {
            return PrimitiveType.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignored) {
            try {
                return new ReferenceType(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid type name: " + name);
            }
        }
    }

    public static JavaType fromInternalName(String internalName) {
        Objects.requireNonNull(internalName, "Null internal name");
        return JavaType.fromName(internalName.replace('/', '.'));
    }

    public static JavaType fromDescriptor(String descriptor) {
        int descriptorLength = Objects.requireNonNull(descriptor, "Null descriptor").length();
        switch (descriptorLength) {
            case 0: {
                throw new IllegalArgumentException("Empty descriptor!");
            }
            case 1: {
                return PrimitiveType.fromDescriptorChar(descriptor.charAt(0));
            }
        }
        char firstChar = descriptor.charAt(0);
        switch (firstChar) {
            case '[': {
                int dimensions = 1;
                while (descriptor.charAt(dimensions) == '[') {
                    ++dimensions;
                }
                return JavaType.createArray(dimensions, JavaType.fromDescriptor(descriptor.substring(dimensions)));
            }
            case 'L': {
                if (descriptor.charAt(descriptorLength - 1) != ';') break;
                char[] internalName = new char[descriptorLength - 2];
                descriptor.getChars(1, descriptorLength - 1, internalName, 0);
                for (int i = 0; i < internalName.length; ++i) {
                    char c = internalName[i];
                    if (c != '.') continue;
                    internalName[i] = 47;
                }
                return JavaType.fromInternalName(String.valueOf(internalName));
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

