/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.function.UnaryOperator;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.JavaTypeSort;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PrimitiveType
extends Enum<PrimitiveType>
implements JavaType {
    public static final /* enum */ PrimitiveType BYTE = new PrimitiveType('B');
    public static final /* enum */ PrimitiveType SHORT = new PrimitiveType('S');
    public static final /* enum */ PrimitiveType INT = new PrimitiveType('I');
    public static final /* enum */ PrimitiveType LONG = new PrimitiveType('J');
    public static final /* enum */ PrimitiveType FLOAT = new PrimitiveType('F');
    public static final /* enum */ PrimitiveType DOUBLE = new PrimitiveType('D');
    public static final /* enum */ PrimitiveType CHAR = new PrimitiveType('C');
    public static final /* enum */ PrimitiveType BOOLEAN = new PrimitiveType('Z');
    public static final /* enum */ PrimitiveType VOID = new PrimitiveType('V');
    private final char descriptorChar;
    private static final PrimitiveType[] byDescriptorChar;
    private static final /* synthetic */ PrimitiveType[] $VALUES;

    public static PrimitiveType[] values() {
        return (PrimitiveType[])$VALUES.clone();
    }

    public static PrimitiveType valueOf(String name) {
        return Enum.valueOf(PrimitiveType.class, name);
    }

    @Override
    public String getInternalName() {
        return this.getName();
    }

    @Override
    public String getDescriptor() {
        return String.valueOf(this.descriptorChar);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public JavaTypeSort getSort() {
        return JavaTypeSort.PRIMITIVE_TYPE;
    }

    @Override
    public JavaType mapClass(UnaryOperator<JavaType> func) {
        return this;
    }

    private PrimitiveType(char descriptorChar) {
        this.descriptorChar = descriptorChar;
    }

    public static @NonNull PrimitiveType fromDescriptorChar(char descriptorChar) {
        PrimitiveType primitiveType;
        if (descriptorChar <= byDescriptorChar.length && (primitiveType = byDescriptorChar[descriptorChar]) != null) {
            return primitiveType;
        }
        throw new IllegalArgumentException("Invalid descriptor char: " + descriptorChar);
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ PrimitiveType[] $values() {
        return new PrimitiveType[]{BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, CHAR, BOOLEAN, VOID};
    }

    static {
        $VALUES = PrimitiveType.$values();
        byDescriptorChar = new PrimitiveType[128];
        for (PrimitiveType type : PrimitiveType.values()) {
            assert (byDescriptorChar[type.descriptorChar] == null) : "Duplicate descriptors with char " + type.descriptorChar;
            PrimitiveType.byDescriptorChar[type.descriptorChar] = type;
        }
    }
}

