/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.mappings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.SrgLib;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.mappings.SimpleMappings;
import net.techcable.srglib.utils.ImmutableMaps;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImmutableMappings
implements Mappings {
    private final Map<JavaType, JavaType> classes;
    private final Map<MethodData, MethodData> methods;
    private final Map<FieldData, FieldData> fields;
    static final ImmutableMappings EMPTY = new ImmutableMappings(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private @Nullable ImmutableMappings inverted;

    private ImmutableMappings(Map<JavaType, JavaType> classes, Map<MethodData, MethodData> methods, Map<FieldData, FieldData> fields) {
        this.classes = Objects.requireNonNull(classes, "Null types");
        this.methods = Objects.requireNonNull(methods, "Null methods");
        this.fields = Objects.requireNonNull(fields, "Null fields");
    }

    @Override
    public JavaType getNewClass(JavaType original) {
        if (!original.isReferenceType()) {
            throw new IllegalArgumentException("Type isn't a reference type: " + original);
        }
        return this.classes.getOrDefault(Objects.requireNonNull(original), original);
    }

    @Override
    public MethodData getNewMethod(MethodData original) {
        MethodData result = this.methods.get(Objects.requireNonNull(original));
        if (result != null) {
            return result;
        }
        return original.mapTypes(this::getNewType);
    }

    @Override
    public FieldData getNewField(FieldData original) {
        FieldData result = this.fields.get(Objects.requireNonNull(original));
        if (result != null) {
            return result;
        }
        return original.mapTypes(this::getNewType);
    }

    @Override
    public Set<JavaType> classes() {
        return this.classes.keySet();
    }

    @Override
    public Set<MethodData> methods() {
        return this.methods.keySet();
    }

    @Override
    public Set<FieldData> fields() {
        return this.fields.keySet();
    }

    @Override
    public ImmutableMappings snapshot() {
        return this;
    }

    @Override
    public ImmutableMappings inverted() {
        ImmutableMappings inverted = this.inverted;
        return inverted != null ? inverted : (this.inverted = this.invert0());
    }

    private ImmutableMappings invert0() {
        ImmutableMappings inverted = new ImmutableMappings(ImmutableMaps.inverse(this.classes), ImmutableMaps.inverse(this.methods), ImmutableMaps.inverse(this.fields));
        inverted.inverted = this;
        return inverted;
    }

    public static ImmutableMappings copyOf(Map<JavaType, JavaType> originalClasses, Map<MethodData, String> methodNames, Map<FieldData, String> fieldNames) {
        HashMap<JavaType, JavaType> classes = new HashMap<JavaType, JavaType>(originalClasses);
        HashMap methods = new HashMap();
        HashMap fields = new HashMap();
        methodNames.forEach((originalData, newName) -> {
            MethodData newData = originalData.mapTypes(oldType -> oldType.mapClass(oldClass -> classes.getOrDefault(oldClass, (JavaType)oldClass))).withName((String)newName);
            methods.put(originalData, newData);
        });
        fieldNames.forEach((originalData, newName) -> {
            FieldData newData = FieldData.create(originalData.getDeclaringType().mapClass(oldClass -> classes.getOrDefault(oldClass, (JavaType)oldClass)), newName);
            fields.put(originalData, newData);
        });
        return new ImmutableMappings(Collections.unmodifiableMap(classes), Collections.unmodifiableMap(methods), Collections.unmodifiableMap(fields));
    }

    public static ImmutableMappings create(Map<JavaType, JavaType> classes, Map<MethodData, MethodData> methods, Map<FieldData, FieldData> fields) {
        ImmutableMappings result = new ImmutableMappings(Collections.unmodifiableMap(classes), Collections.unmodifiableMap(methods), Collections.unmodifiableMap(fields));
        SrgLib.checkConsistency(result);
        return result;
    }

    public static ImmutableMappings copyOf(Mappings other) {
        if (other instanceof ImmutableMappings) {
            return (ImmutableMappings)other;
        }
        if (other instanceof SimpleMappings) {
            return other.snapshot();
        }
        return ImmutableMappings.create(ImmutableMaps.createMap(other.classes(), other::getNewType), ImmutableMaps.createMap(other.methods(), other::getNewMethod), ImmutableMaps.createMap(other.fields(), other::getNewField));
    }

    @Override
    public void forEachClass(BiConsumer<JavaType, JavaType> action) {
        this.classes.forEach(action);
    }

    @Override
    public void forEachMethod(BiConsumer<MethodData, MethodData> action) {
        this.methods.forEach(action);
    }

    @Override
    public void forEachField(BiConsumer<FieldData, FieldData> action) {
        this.fields.forEach(action);
    }

    public int hashCode() {
        return this.classes.hashCode() ^ this.methods.hashCode() ^ this.fields.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == ImmutableMappings.class) {
            return this.classes.equals(((ImmutableMappings)obj).classes) && this.methods.equals(((ImmutableMappings)obj).methods) && this.fields.equals(((ImmutableMappings)obj).fields);
        }
        if (obj instanceof Mappings) {
            return this.equals(((Mappings)obj).snapshot());
        }
        return false;
    }

    public String toString() {
        return "Mappings{classes=" + ImmutableMaps.joinToString(this.classes, (original, renamed) -> String.format("  %s = %s", original.getName(), renamed.getName()), "\n", "{", "}") + ", methods=" + ImmutableMaps.joinToString(this.methods, (original, renamed) -> String.format("  %s = %s", original, renamed), "\n", "{\n", "\n}") + ", fields=" + ImmutableMaps.joinToString(this.fields, (original, renamed) -> String.format("  %s = %s", original, renamed), "\n", "{\n", "\n}") + "}";
    }
}

