/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.mappings;

import java.util.HashMap;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.mappings.SimpleMappings;

public interface MutableMappings
extends Mappings {
    public void putClass(JavaType var1, JavaType var2);

    default public void putMethod(MethodData original, MethodData renamed) {
        if (!original.mapTypes(this::getNewType).hasSameTypes(renamed)) {
            throw new IllegalArgumentException("Remapped method data types (" + renamed + ") don't correspond to original types (" + original + ")");
        }
        this.putMethod(original, renamed.getName());
    }

    public void putMethod(MethodData var1, String var2);

    default public void putField(FieldData original, FieldData renamed) {
        if (!original.mapTypes(this::getNewType).hasSameTypes(renamed)) {
            throw new IllegalArgumentException("Remapped field data (" + renamed + ") doesn't correspond to original types (" + original + ")");
        }
        this.putField(original, renamed.getName());
    }

    public void putField(FieldData var1, String var2);

    @Override
    public Mappings inverted();

    public static MutableMappings create() {
        return new SimpleMappings(new HashMap<JavaType, JavaType>(), new HashMap<MethodData, String>(), new HashMap<FieldData, String>());
    }
}

