/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7444;
import net.minecraft.class_7924;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftMusicInstrument
extends MusicInstrument
implements Handleable<class_7444> {
    private final NamespacedKey key;
    private final class_7444 handle;

    public static MusicInstrument minecraftToBukkit(class_7444 minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41275);
    }

    public static MusicInstrument minecraftHolderToBukkit(class_6880<class_7444> minecraft) {
        return CraftMusicInstrument.minecraftToBukkit((class_7444)minecraft.comp_349());
    }

    public static class_7444 bukkitToMinecraft(MusicInstrument bukkit) {
        return (class_7444)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_7444> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41275);
        class_6880 class_68802 = registry.method_47983((Object)CraftMusicInstrument.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own instrument without properly registering it.");
    }

    public CraftMusicInstrument(NamespacedKey key, class_7444 handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public class_7444 getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftMusicInstrument)) {
            return false;
        }
        return this.getKey().equals((Object)((MusicInstrument)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftMusicInstrument{key=" + String.valueOf(this.key) + "}";
    }

    @NotNull
    public String translationKey() {
        class_7417 class_74172 = this.getHandle().comp_2929().method_10851();
        if (!(class_74172 instanceof class_2588)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        class_2588 translatableContents = (class_2588)class_74172;
        return translatableContents.method_11022();
    }

    public float getDuration() {
        return this.getHandle().comp_773();
    }

    public float getRange() {
        return this.getHandle().comp_774();
    }

    public Component description() {
        return PaperAdventure.asAdventure(this.getHandle().comp_2929());
    }

    public Sound getSound() {
        return CraftSound.MUSIC_DISC_11;
    }
}

