/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_5321;
import net.minecraft.class_5707;
import net.minecraft.class_5709;
import net.minecraft.class_5716;
import net.minecraft.class_5743;
import net.minecraft.class_5745;
import net.minecraft.class_7227;
import net.minecraft.class_7290;
import net.minecraft.class_7924;
import net.minecraft.class_9381;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(class_7924.field_41210));
    private final NamespacedKey key;
    private final class_2396<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(class_2396<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41210);
        Particle bukkit = (Particle)Registry.PARTICLE_TYPE.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113(minecraft).orElseThrow()).method_29177()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static class_2396<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (class_2396)CraftRegistry.getMinecraftRegistry(class_7924.field_41210).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> class_2394 createParticleParam(Particle particle, D data) {
        CraftParticle craftParticle;
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (Object)"particle cannot be null");
        data = CraftParticle.convertLegacy(data);
        if (particle.getDataType() != Void.class) {
            Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"missing required data %s", (Object)particle.getDataType());
        }
        if (data != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        Preconditions.checkArgument(((craftParticle = (CraftParticle)CRAFT_PARTICLE_REGISTRY.get(particle.getKey())) != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public CraftParticle(NamespacedKey key, class_2396<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public class_2396<?> getHandle() {
        return this.particle;
    }

    public abstract class_2394 createParticleParam(D var1);

    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, class_2396<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public class_2394 createParticleParam(Void data) {
                return (class_2400)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString((String)name), function);
        }

        public CraftParticleRegistry(class_2378<class_2396<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, CraftParticleRegistry::createBukkit, FieldRename.PARTICLE_TYPE_RENAME);
        }

        public static CraftParticle<?> createBukkit(NamespacedKey namespacedKey, class_2396<?> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle);
        }

        static {
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public class_2394 createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new class_2390(color.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public class_2394 createParticleParam(ItemStack data) {
                    return new class_2392(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public class_2394 createParticleParam(BlockData data) {
                    return new class_2388(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public class_2394 createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to = data.getToColor();
                    return new class_5743(from.asRGB(), to.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public class_2394 createParticleParam(Vibration data) {
                    class_5707 source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new class_5707(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        class_1297 destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new class_5709(destination, destination.method_5751());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + String.valueOf(data.getDestination()));
                    }
                    return new class_5745((class_5716)source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> floatFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public class_2394 createParticleParam(Float data) {
                    return new class_7227(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public class_2394 createParticleParam(Integer data) {
                    return new class_7290(data.intValue());
                }
            };
            BiFunction<NamespacedKey, class_2396<?>, CraftParticle<?>> colorFunction = (name, particle) -> new CraftParticle<Color>(name, particle, Color.class){

                @Override
                public class_2394 createParticleParam(Color color) {
                    return class_9381.method_58256((class_2396)particle, (int)color.asARGB());
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", floatFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
            CraftParticleRegistry.add("entity_effect", colorFunction);
            CraftParticleRegistry.add("dust_pillar", blockDataFunction);
            CraftParticleRegistry.add("block_crumble", blockDataFunction);
        }
    }
}

