/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_9274;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.attribute.AttributeMappings;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.EquipmentSlotGroup;

public class CraftAttributeInstance
implements AttributeInstance {
    private final class_1324 handle;
    private final Attribute attribute;

    public CraftAttributeInstance(class_1324 handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.handle.method_6201();
    }

    public void setBaseValue(double d) {
        this.handle.method_6192(d);
    }

    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (class_1322 nms : this.handle.method_6195()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    public AttributeModifier getModifier(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        class_1322 modifier = this.handle.method_6199(PaperAdventure.asVanilla(key));
        return modifier == null ? null : CraftAttributeInstance.convert(modifier);
    }

    public void removeModifier(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.handle.method_6200(PaperAdventure.asVanilla(key));
    }

    public AttributeModifier getModifier(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getModifier((Key)AttributeMappings.uuidToKey(uuid));
    }

    public void removeModifier(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        this.removeModifier((Key)AttributeMappings.uuidToKey(uuid));
    }

    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.method_26837(CraftAttributeInstance.convert(modifier));
    }

    public void addTransientModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.method_26835(CraftAttributeInstance.convert(modifier));
    }

    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.method_6202(CraftAttributeInstance.convert(modifier));
    }

    public double getValue() {
        return this.handle.method_6194();
    }

    public double getDefaultValue() {
        return ((class_1320)this.handle.method_6198().comp_349()).method_6169();
    }

    public static class_1322 convert(AttributeModifier bukkit) {
        return new class_1322(CraftNamespacedKey.toMinecraft(bukkit.getKey()), bukkit.getAmount(), class_1322.class_1323.values()[bukkit.getOperation().ordinal()]);
    }

    public static AttributeModifier convert(class_1322 nms) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.comp_2447()), nms.comp_2449(), AttributeModifier.Operation.values()[nms.comp_2450().ordinal()], EquipmentSlotGroup.ANY);
    }

    public static AttributeModifier convert(class_1322 nms, class_9274 slot) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.comp_2447()), nms.comp_2449(), AttributeModifier.Operation.values()[nms.comp_2450().ordinal()], CraftEquipmentSlot.getSlot(slot));
    }
}

