/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityType {
    private static final Map<EntityType, class_5321<class_1299<?>>> KEY_CACHE = Collections.synchronizedMap(new EnumMap(EntityType.class));

    public static EntityType minecraftToBukkit(class_1299<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41266);
        EntityType bukkit = (EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113(minecraft).orElseThrow()).method_29177()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static class_1299<?> bukkitToMinecraft(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (class_1299)CraftRegistry.getMinecraftRegistry(class_7924.field_41266).method_31189(KEY_CACHE.computeIfAbsent(bukkit, type -> class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)CraftNamespacedKey.toMinecraft(type.getKey())))).orElseThrow();
    }

    public static class_6880<class_1299<?>> bukkitToMinecraftHolder(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41266);
        class_6880 class_68802 = registry.method_47983(CraftEntityType.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static EntityType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEntityTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (EntityType)CraftRegistry.get(RegistryKey.ENTITY_TYPE, key, ApiVersion.CURRENT);
    }
}

