/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import me.isaiah.common.ICommonMod;
import me.isaiah.common.cmixin.IMixinTradeOffer;
import net.minecraft.class_1914;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class CraftMerchantRecipe
extends MerchantRecipe {
    private final class_1914 handle;

    public CraftMerchantRecipe(class_1914 merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.field_9148), 0);
        this.handle = merchantRecipe;
        IMixinTradeOffer ic = (IMixinTradeOffer)merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(ic.IC$get_first_buy_itemstack()));
        if (null != ic.IC$get_second_buy_itemstack()) {
            this.addIngredient(CraftItemStack.asBukkitCopy(ic.IC$get_second_buy_itemstack()));
        }
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier);
        this.handle = ICommonMod.getIServer().create_trade_offer(CraftItemStack.asNMSCopy(result), uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0);
        this.setExperienceReward(experienceReward);
    }

    public int getUses() {
        return this.handle.field_9147;
    }

    public void setUses(int uses) {
        this.handle.field_9147 = uses;
    }

    public int getMaxUses() {
        return this.handle.field_9144;
    }

    public void setMaxUses(int maxUses) {
        this.handle.field_9144 = maxUses;
    }

    public boolean hasExperienceReward() {
        return this.handle.field_9145;
    }

    public void setExperienceReward(boolean flag) {
        this.handle.field_9145 = flag;
    }

    public int getVillagerExperience() {
        return this.handle.field_18679;
    }

    public void setVillagerExperience(int villagerExperience) {
        this.handle.field_18679 = villagerExperience;
    }

    public float getPriceMultiplier() {
        return this.handle.field_18678;
    }

    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.field_18678 = priceMultiplier;
    }

    public class_1914 toMinecraft() {
        List ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        IMixinTradeOffer ic = (IMixinTradeOffer)this.handle;
        ic.IC$set_first_buy_itemstack(CraftItemStack.asNMSCopy((ItemStack)ingredients.get(0)));
        if (ingredients.size() > 1) {
            ic.IC$set_second_buy_itemstack(CraftItemStack.asNMSCopy((ItemStack)ingredients.get(1)));
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

