/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_6880;
import net.minecraft.class_9298;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaSuspiciousStew
extends CraftMetaItem
implements SuspiciousStewMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9298> EFFECTS = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49652, "effects");
    private List<SuspiciousEffectEntry> customEffects;

    CraftMetaSuspiciousStew(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSuspiciousStew)) {
            return;
        }
        CraftMetaSuspiciousStew stewMeta = (CraftMetaSuspiciousStew)meta;
        if (stewMeta.hasCustomEffects()) {
            this.customEffects = new ArrayList<SuspiciousEffectEntry>(stewMeta.customEffects);
        }
    }

    CraftMetaSuspiciousStew(class_9326 tag, Set<class_9331<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaSuspiciousStew.getOrEmpty(tag, EFFECTS).ifPresent(suspiciousStewEffects -> {
            List list = suspiciousStewEffects.comp_2416();
            int length = list.size();
            this.customEffects = new ArrayList<SuspiciousEffectEntry>(length);
            for (int i = 0; i < length; ++i) {
                class_9298.class_8751 effect = (class_9298.class_8751)list.get(i);
                PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit((class_6880<class_1291>)effect.comp_1838());
                if (type == null) continue;
                int duration = effect.comp_1839();
                this.customEffects.add(SuspiciousEffectEntry.create((PotionEffectType)type, (int)duration));
            }
        });
    }

    CraftMetaSuspiciousStew(Map<String, Object> map) {
        super(map);
        Iterable rawEffectList = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaSuspiciousStew.EFFECTS.BUKKIT, true);
        if (rawEffectList == null) {
            return;
        }
        for (Object obj : rawEffectList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
            this.addCustomEffect((PotionEffect)obj, true);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.customEffects != null) {
            ArrayList<class_9298.class_8751> effectList = new ArrayList<class_9298.class_8751>();
            for (SuspiciousEffectEntry effect : this.customEffects) {
                effectList.add(new class_9298.class_8751(CraftPotionEffectType.bukkitToMinecraftHolder(effect.effect()), effect.duration()));
            }
            tag.put(EFFECTS, new class_9298(effectList));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isStewEmpty();
    }

    boolean isStewEmpty() {
        return !this.hasCustomEffects();
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.SUSPICIOUS_STEW;
    }

    @Override
    public CraftMetaSuspiciousStew clone() {
        CraftMetaSuspiciousStew clone = (CraftMetaSuspiciousStew)super.clone();
        if (this.customEffects != null) {
            clone.customEffects = new ArrayList<SuspiciousEffectEntry>(this.customEffects);
        }
        return clone;
    }

    public boolean hasCustomEffects() {
        return this.customEffects != null;
    }

    public List<PotionEffect> getCustomEffects() {
        if (this.hasCustomEffects()) {
            return this.customEffects.stream().map(suspiciousEffectEntry -> suspiciousEffectEntry.effect().createEffect(suspiciousEffectEntry.duration(), 0)).toList();
        }
        return ImmutableList.of();
    }

    public boolean addCustomEffect(PotionEffect effect, boolean overwrite) {
        return this.addCustomEffect(SuspiciousEffectEntry.create((PotionEffectType)effect.getType(), (int)effect.getDuration()), overwrite);
    }

    public boolean removeCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        if (!this.hasCustomEffects()) {
            return false;
        }
        boolean changed = false;
        Iterator<SuspiciousEffectEntry> iterator = this.customEffects.iterator();
        while (iterator.hasNext()) {
            SuspiciousEffectEntry effect = iterator.next();
            if (!type.equals(effect.effect())) continue;
            iterator.remove();
            changed = true;
        }
        if (this.customEffects.isEmpty()) {
            this.customEffects = null;
        }
        return changed;
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        return this.indexOfEffect(type) != -1;
    }

    private int indexOfEffect(PotionEffectType type) {
        if (!this.hasCustomEffects()) {
            return -1;
        }
        for (int i2 = 0; i2 < this.customEffects.size(); ++i2) {
            if (!this.customEffects.get(i2).effect().equals(type)) continue;
            return i2;
        }
        return -1;
    }

    public boolean clearCustomEffects() {
        boolean changed = this.hasCustomEffects();
        this.customEffects = null;
        return changed;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasCustomEffects()) {
            hash = 73 * hash + this.customEffects.hashCode();
        }
        return original != hash ? CraftMetaSuspiciousStew.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSuspiciousStew) {
            CraftMetaSuspiciousStew that = (CraftMetaSuspiciousStew)meta;
            return this.hasCustomEffects() ? that.hasCustomEffects() && this.customEffects.equals(that.customEffects) : !that.hasCustomEffects();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSuspiciousStew || this.isStewEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasCustomEffects()) {
            builder.put((Object)CraftMetaSuspiciousStew.EFFECTS.BUKKIT, (Object)ImmutableList.copyOf(this.customEffects));
        }
        return builder;
    }

    public boolean addCustomEffect(SuspiciousEffectEntry suspiciousEffectEntry, boolean overwrite) {
        List<SuspiciousEffectEntry> matchingEffects;
        Preconditions.checkArgument((suspiciousEffectEntry != null ? 1 : 0) != 0, (Object)"Suspicious effect entry cannot be null");
        if (this.hasCustomEffects() && !(matchingEffects = this.customEffects.stream().filter(entry -> entry.effect() == suspiciousEffectEntry.effect()).toList()).isEmpty()) {
            if (overwrite) {
                boolean foundMatchingDuration = false;
                boolean mutated = false;
                for (SuspiciousEffectEntry matchingEffect : matchingEffects) {
                    if (matchingEffect.duration() != suspiciousEffectEntry.duration()) {
                        this.customEffects.remove(suspiciousEffectEntry);
                        mutated = true;
                        continue;
                    }
                    foundMatchingDuration = true;
                }
                if (foundMatchingDuration && !mutated) {
                    return false;
                }
                if (!foundMatchingDuration) {
                    this.customEffects.add(suspiciousEffectEntry);
                }
                return true;
            }
            return false;
        }
        if (this.customEffects == null) {
            this.customEffects = new ArrayList<SuspiciousEffectEntry>();
        }
        this.customEffects.add(suspiciousEffectEntry);
        return true;
    }
}

