/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9424;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.inventory.components.CraftHolderUtil;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.cardboardpowered.impl.tag.BlockTagImpl;

@SerializableAs(value="Tool")
public final class CraftToolComponent
implements ToolComponent {
    private class_9424 handle;

    public CraftToolComponent(class_9424 tool) {
        this.handle = tool;
    }

    public CraftToolComponent(CraftToolComponent tool) {
        this.handle = tool.handle;
    }

    public CraftToolComponent(Map<String, Object> map) {
        Float speed = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Integer damage = SerializableMeta.getObject(Integer.class, map, "damage-per-block", false);
        ImmutableList.Builder rules = ImmutableList.builder();
        Iterable rawRuleList = SerializableMeta.getObject(Iterable.class, map, "rules", true);
        if (rawRuleList != null) {
            for (Object obj : rawRuleList) {
                Preconditions.checkArgument((boolean)(obj instanceof ToolComponent.ToolRule), (String)"Object (%s) in rule list is not valid", obj.getClass());
                CraftToolRule rule = new CraftToolRule((ToolComponent.ToolRule)obj);
                if (rule.handle.comp_2501().method_40247() <= 0) continue;
                rules.add((Object)rule);
            }
        }
        this.handle = new class_9424(rules.build().stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), speed.floatValue(), damage.intValue(), true);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("default-mining-speed", Float.valueOf(this.getDefaultMiningSpeed()));
        result.put("damage-per-block", this.getDamagePerBlock());
        result.put("rules", this.getRules());
        return result;
    }

    public class_9424 getHandle() {
        return this.handle;
    }

    public float getDefaultMiningSpeed() {
        return this.handle.comp_2499();
    }

    public void setDefaultMiningSpeed(float speed) {
        this.handle = new class_9424(this.handle.comp_2498(), speed, this.handle.comp_2500(), this.handle.comp_3480());
    }

    public int getDamagePerBlock() {
        return this.handle.comp_2500();
    }

    public void setDamagePerBlock(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, was %d", (int)damage);
        this.handle = new class_9424(this.handle.comp_2498(), this.handle.comp_2499(), damage, this.handle.comp_3480());
    }

    public List<ToolComponent.ToolRule> getRules() {
        return this.handle.comp_2498().stream().map(CraftToolRule::new).collect(Collectors.toList());
    }

    public void setRules(List<ToolComponent.ToolRule> rules) {
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"rules must not be null");
        this.handle = new class_9424(rules.stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), this.handle.comp_2499(), this.handle.comp_2500(), this.handle.comp_3480());
    }

    public ToolComponent.ToolRule addRule(Material block, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        class_6880.class_6883 nmsBlock = CraftBlockType.bukkitToMinecraft(block).method_40142();
        return this.addRule((class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{nmsBlock}), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Collection<Material> blocks, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        ArrayList<class_6880.class_6883> nmsBlocks = new ArrayList<class_6880.class_6883>(blocks.size());
        for (Material material : blocks) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            nmsBlocks.add(CraftBlockType.bukkitToMinecraft(material).method_40142());
        }
        return this.addRule((class_6885<class_2248>)class_6885.method_40242(nmsBlocks), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Tag<Material> tag, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((boolean)(tag instanceof BlockTagImpl), (Object)"tag must be a block tag");
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        return this.addRule((class_6885<class_2248>)((BlockTagImpl)tag).getHandle(), speed, correctForDrops);
    }

    private ToolComponent.ToolRule addRule(class_6885<class_2248> blocks, Float speed, Boolean correctForDrops) {
        class_9424.class_9425 rule = new class_9424.class_9425(blocks, Optional.ofNullable(speed), Optional.ofNullable(correctForDrops));
        ArrayList<class_9424.class_9425> rules = new ArrayList<class_9424.class_9425>(this.handle.comp_2498().size() + 1);
        rules.addAll(this.handle.comp_2498());
        rules.add(rule);
        this.handle = new class_9424(rules, this.handle.comp_2499(), this.handle.comp_2500(), this.handle.comp_3480());
        return new CraftToolRule(rule);
    }

    public boolean removeRule(ToolComponent.ToolRule rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"rule must not be null");
        ArrayList rules = new ArrayList(this.handle.comp_2498());
        boolean removed = rules.remove(((CraftToolRule)rule).handle);
        this.handle = new class_9424(rules, this.handle.comp_2499(), this.handle.comp_2500(), this.handle.comp_3480());
        return removed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftToolComponent other = (CraftToolComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftToolComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="ToolRule")
    public static class CraftToolRule
    implements ToolComponent.ToolRule {
        private class_9424.class_9425 handle;

        public CraftToolRule(class_9424.class_9425 handle) {
            this.handle = handle;
        }

        public CraftToolRule(ToolComponent.ToolRule bukkit) {
            class_9424.class_9425 toCopy = ((CraftToolRule)bukkit).handle;
            this.handle = new class_9424.class_9425(toCopy.comp_2501(), toCopy.comp_2502(), toCopy.comp_2503());
        }

        public CraftToolRule(Map<String, Object> map) {
            Float speed = SerializableMeta.getObject(Float.class, map, "speed", true);
            Boolean correct = SerializableMeta.getObject(Boolean.class, map, "correct-for-drops", true);
            class_6885 blocks = CraftHolderUtil.parse(SerializableMeta.getObject(Object.class, map, "blocks", false), class_7924.field_41254, class_7923.field_41175);
            this.handle = new class_9424.class_9425(blocks, Optional.ofNullable(speed), Optional.ofNullable(correct));
        }

        public Map<String, Object> serialize() {
            Boolean correct;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            CraftHolderUtil.serialize(result, "blocks", this.handle.comp_2501());
            Float speed = this.getSpeed();
            if (speed != null) {
                result.put("speed", speed);
            }
            if ((correct = this.isCorrectForDrops()) != null) {
                result.put("correct-for-drops", correct);
            }
            return result;
        }

        public class_9424.class_9425 getHandle() {
            return this.handle;
        }

        public Collection<Material> getBlocks() {
            return this.handle.comp_2501().method_40239().map(class_6880::comp_349).map(CraftBlockType::minecraftToBukkit).collect(Collectors.toList());
        }

        public void setBlocks(Material block) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
            Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
            this.handle = new class_9424.class_9425((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{CraftBlockType.bukkitToMinecraft(block).method_40142()}), this.handle.comp_2502(), this.handle.comp_2503());
        }

        public void setBlocks(Collection<Material> blocks) {
            Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
            for (Material material : blocks) {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            }
            this.handle = new class_9424.class_9425((class_6885)class_6885.method_40242(blocks.stream().map(CraftBlockType::bukkitToMinecraft).map(class_2248::method_40142).collect(Collectors.toList())), this.handle.comp_2502(), this.handle.comp_2503());
        }

        public void setBlocks(Tag<Material> tag) {
            Preconditions.checkArgument((boolean)(tag instanceof BlockTagImpl), (Object)"tag must be a block tag");
            this.handle = new class_9424.class_9425(((BlockTagImpl)tag).getHandle(), this.handle.comp_2502(), this.handle.comp_2503());
        }

        public Float getSpeed() {
            return this.handle.comp_2502().orElse(null);
        }

        public void setSpeed(Float speed) {
            Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
            this.handle = new class_9424.class_9425(this.handle.comp_2501(), Optional.ofNullable(speed), this.handle.comp_2503());
        }

        public Boolean isCorrectForDrops() {
            return this.handle.comp_2503().orElse(null);
        }

        public void setCorrectForDrops(Boolean correct) {
            this.handle = new class_9424.class_9425(this.handle.comp_2501(), this.handle.comp_2502(), Optional.ofNullable(correct));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftToolRule other = (CraftToolRule)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftToolRule{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

