/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view;

import com.google.common.base.Preconditions;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1887;
import net.minecraft.class_2359;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.view.EnchantmentView;
import org.cardboardpowered.impl.CardboardEnchantment;
import org.jetbrains.annotations.NotNull;

public class CraftEnchantmentView
extends CraftInventoryView<class_1718, EnchantingInventory>
implements EnchantmentView {
    public CraftEnchantmentView(HumanEntity player, EnchantingInventory viewing, class_1718 container) {
        super(player, viewing, (class_1703)container);
    }

    public int getEnchantmentSeed() {
        return ((class_1718)this.container).method_17413();
    }

    public void setEnchantmentSeed(int seed) {
    }

    public class_1718 container() {
        return (class_1718)this.container;
    }

    @NotNull
    public EnchantmentOffer[] getOffers() {
        class_2359 registry = CraftRegistry.getMinecraftRegistry().method_30530(class_7924.field_41265).method_40295();
        EnchantmentOffer[] offers = new EnchantmentOffer[3];
        for (int i = 0; i < 3; ++i) {
            Enchantment enchantment = this.container().field_7812[i] >= 0 ? CardboardEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)((class_6880)registry.method_10200(this.container().field_7812[i]))) : null;
            offers[i] = enchantment != null ? new EnchantmentOffer(enchantment, this.container().field_7810[i], this.container().field_7808[i]) : null;
        }
        return offers;
    }

    public void setOffers(@NotNull EnchantmentOffer[] offers) {
        Preconditions.checkArgument((offers.length == 3 ? 1 : 0) != 0, (Object)"There must be 3 offers given");
        class_2359 registry = CraftRegistry.getMinecraftRegistry().method_30530(class_7924.field_41265).method_40295();
        for (int i = 0; i < offers.length; ++i) {
            EnchantmentOffer offer = offers[i];
            if (offer == null) {
                this.container().field_7812[i] = -1;
                this.container().field_7810[i] = -1;
                this.container().field_7808[i] = 0;
                continue;
            }
            this.container().field_7812[i] = registry.method_56158(CardboardEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
            this.container().field_7810[i] = offer.getEnchantmentLevel();
            this.container().field_7808[i] = offer.getCost();
        }
    }
}

