/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1915;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftMerchant;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.jspecify.annotations.Nullable;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private @Nullable class_1915 merchant;

    public CraftMerchantInventoryViewBuilder(class_3917<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(Component title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof class_3222), (Object)"The given player must be an EntityPlayer");
        class_3222 serverPlayer = (class_3222)craftHuman.getHandle();
        if (this.merchant == null) {
            return null;
        }
        class_1728 container = new class_1728(serverPlayer.nextContainerCounter(), serverPlayer.method_31548(), this.merchant);
        IMixinScreenHandler sh = (IMixinScreenHandler)container;
        sh.setCheckReachable(this.checkReachable);
        sh.setTitle(PaperAdventure.asVanilla(this.title));
        return (V)((IMixinScreenHandler)container).getBukkitView();
    }

    @Override
    protected class_1703 buildContainer(class_3222 player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

