/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.packs;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_7923;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.packs.CraftDataPack;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemType;
import org.cardboardpowered.impl.world.CraftWorld;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class CraftDataPackManager {
    private final class_3283 handle;

    public CraftDataPackManager(class_3283 resourcePackRepository) {
        this.handle = resourcePackRepository;
    }

    public class_3283 getHandle() {
        return this.handle;
    }

    public Collection<CraftDataPack> getDataPacks() {
        this.getHandle().method_14445();
        Collection availablePacks = this.getHandle().method_14441();
        return availablePacks.stream().map(CraftDataPack::new).collect(Collectors.toUnmodifiableList());
    }

    public CraftDataPack getDataPack(NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"namespacedKey cannot be null");
        return new CraftDataPack(this.getHandle().method_14449(namespacedKey.getKey()));
    }

    public Collection<CraftDataPack> getEnabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return ((class_31)craftWorld.getHandle().field_24456).method_29589().comp_1010().method_29547().stream().map(packName -> {
            class_3288 resourcePackLoader = this.getHandle().method_14449(packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public Collection<CraftDataPack> getDisabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return ((class_31)craftWorld.getHandle().field_24456).method_29589().comp_1010().method_29550().stream().map(packName -> {
            class_3288 resourcePackLoader = this.getHandle().method_14449(packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public boolean isEnabledByFeature(Material material, World world) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Preconditions.checkArgument((material.isItem() || material.isBlock() ? 1 : 0) != 0, (Object)"material need to be a item or block");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        if (material.isItem()) {
            return CraftMagicNumbers.getItem(material).method_45382(craftWorld.getHandle().method_45162());
        }
        if (material.isBlock()) {
            return CraftMagicNumbers.getBlock(material).method_45382(craftWorld.getHandle().method_45162());
        }
        return false;
    }

    public boolean isEnabledByFeature(EntityType entityType, World world) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"entityType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (Object)"EntityType.UNKNOWN its not allowed here");
        CraftWorld craftWorld = (CraftWorld)world;
        class_1299 nmsEntity = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)entityType.getKey().getKey()));
        return nmsEntity.method_45382(craftWorld.getHandle().method_45162());
    }

    public boolean isEnabledByFeature(@NotNull ItemType itemType, @NotNull World world) {
        return CraftItemType.bukkitToMinecraftNew((ItemType)itemType.typed()).method_45382(((CraftWorld)world).getHandle().method_45162());
    }

    public boolean isEnabledByFeature(@NotNull BlockType blockType, @NotNull World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        return CraftBlockType.bukkitToMinecraftNew((BlockType)blockType.typed()).method_45382(craftWorld.getHandle().method_45162());
    }
}

