/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_9015;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.scoreboard.CardboardCriteria;
import org.bukkit.craftbukkit.scoreboard.CardboardObjective;
import org.bukkit.craftbukkit.scoreboard.CardboardScore;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardTranslations;
import org.bukkit.craftbukkit.scoreboard.CardboardTeam;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CardboardScoreboard
implements Scoreboard {
    final class_269 board;

    CardboardScoreboard(class_269 board) {
        this.board = board;
    }

    public CardboardObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name);
    }

    public CardboardObjective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CardboardObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        Validate.notNull(name, "Objective name cannot be null");
        Validate.notNull(criteria, "Criteria cannot be null");
        Validate.notNull(displayName, "Display name cannot be null");
        Validate.notNull(renderType, "RenderType cannot be null");
        Validate.isTrue(name.length() <= 16, "The name '" + name + "' is longer than the limit of 16 characters");
        Validate.isTrue(displayName.length() <= 128, "The display name '" + displayName + "' is longer than the limit of 128 characters");
        Validate.isTrue(this.board.method_1170(name) == null, "An objective of name '" + name + "' already exists");
        CardboardCriteria craftCriteria = CardboardCriteria.getFromBukkit(criteria);
        class_266 objective = this.board.method_1168(name, craftCriteria.criteria, CraftChatMessage.fromStringOrNull(displayName), CardboardScoreboardTranslations.fromBukkitRender(renderType), true, null);
        return new CardboardObjective(this, objective);
    }

    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull(name, "Name cannot be null");
        class_266 nms = this.board.method_1170(name);
        return nms == null ? null : new CardboardObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull(criteria, "Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (class_266 netObjective : this.board.method_1151()) {
            CardboardObjective objective = new CardboardObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.method_1151(), (Function)new Function<class_266, Objective>(){

            public Objective apply(class_266 input) {
                return new CardboardObjective(CardboardScoreboard.this, input);
            }
        }));
    }

    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull(slot, "Display slot cannot be null");
        class_266 objective = this.board.method_1189(CardboardScoreboardTranslations.fromBukkitSlot(slot));
        return objective == null ? null : new CardboardObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null");
        return this.getScores(() -> entry);
    }

    private ImmutableSet<Score> getScores(class_9015 entry) throws IllegalArgumentException {
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (class_266 objective : this.board.method_1151()) {
            scores.add((Object)new CardboardScore(new CardboardObjective(this, objective), entry));
        }
        return scores.build();
    }

    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        this.resetScores(player.getName());
    }

    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null");
        for (class_266 objective : this.board.method_1151()) {
            this.board.method_1155(() -> entry, objective);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null");
        class_268 team = this.board.method_1153(player.getName());
        return team == null ? null : new CardboardTeam(this, team);
    }

    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null");
        class_268 team = this.board.method_1153(entry);
        return team == null ? null : new CardboardTeam(this, team);
    }

    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull(teamName, "Team name cannot be null");
        class_268 team = this.board.method_1153(teamName);
        return team == null ? null : new CardboardTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.method_1159(), (Function)new Function<class_268, Team>(){

            public Team apply(class_268 input) {
                return new CardboardTeam(CardboardScoreboard.this, input);
            }
        }));
    }

    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull(name, "Team name cannot be null");
        Validate.isTrue(name.length() <= 16, "Team name '" + name + "' is longer than the limit of 16 characters");
        Validate.isTrue(this.board.method_1153(name) == null, "Team name '" + name + "' is already in use");
        return new CardboardTeam(this, this.board.method_1171(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (class_9015 holder : this.board.method_1178()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)holder.method_5820()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (class_9015 entry : this.board.method_1178()) {
            entries.add((Object)entry.method_5820());
        }
        return entries.build();
    }

    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull(slot, "Slot cannot be null");
        this.board.method_1158(CardboardScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public class_269 getHandle() {
        return this.board;
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String arg0, @NotNull String arg1, @Nullable Component arg2) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String arg0, @NotNull String arg1, @Nullable Component arg2, @NotNull RenderType arg3) throws IllegalArgumentException {
        return null;
    }

    @Nullable
    public Team getEntityTeam(@NotNull Entity arg0) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    public Set<Score> getScoresFor(@NotNull Entity arg0) throws IllegalArgumentException {
        return null;
    }

    public void resetScoresFor(@NotNull Entity arg0) throws IllegalArgumentException {
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(Criteria criteria) {
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (class_266 netObjective : this.board.method_1151()) {
            CardboardObjective objective = new CardboardObjective(this, netObjective);
            if (!objective.getTrackedCriteria().equals((Object)criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public Objective registerNewObjective(String name, Criteria criteria, String displayName) {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String arg0, @NotNull Criteria arg1, @Nullable Component arg2) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String arg0, @NotNull Criteria arg1, @Nullable Component arg2, @NotNull RenderType arg3) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String arg0, @NotNull Criteria arg1, @NotNull String arg2, @NotNull RenderType arg3) throws IllegalArgumentException {
        return null;
    }
}

