/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.izzel.arclight.api.EnumHelper;
import io.izzel.arclight.api.Unsafe;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.entity.EntitySerializationFlag;
import io.papermc.paper.inventory.ItemRarity;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEventManager;
import io.papermc.paper.registry.RegistryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.isaiah.common.cmixin.IMixinItemStack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3551;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FeatureFlag;
import org.bukkit.Fluid;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.CraftFeatureFlag;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.block.data.IMagicNumbers;
import org.bukkit.craftbukkit.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.Commodore;
import org.bukkit.craftbukkit.util.CraftLegacyMaterials;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.cardboardpowered.BlockImplUtil;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.cardboardpowered.impl.CardboardModdedBlock;
import org.cardboardpowered.impl.CardboardModdedItem;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.interfaces.IMixinMaterial;
import org.cardboardpowered.interfaces.IMixinMinecraftServer;
import org.cardboardpowered.util.GameVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftMagicNumbers
implements UnsafeValues,
IMagicNumbers {
    public static final UnsafeValues INSTANCE = new CraftMagicNumbers();
    private static final Map<class_2248, Material> BLOCK_MATERIAL = new HashMap<class_2248, Material>();
    private static final Map<class_1792, Material> ITEM_MATERIAL = new HashMap<class_1792, Material>();
    private static final Map<Material, class_1792> MATERIAL_ITEM = new HashMap<Material, class_1792>();
    private static final Map<Material, class_2248> MATERIAL_BLOCK = new HashMap<Material, class_2248>();
    private static final Map<class_3611, Fluid> FLUID_MATERIAL = new HashMap<class_3611, Fluid>();
    private static final Map<Material, class_3611> MATERIAL_FLUID = new HashMap<Material, class_3611>();
    private static final Map<EntityType, class_1299<?>> ENTITY_TYPE_ENTITY_TYPES = new HashMap();
    private static final Map<class_1299<?>, EntityType> ENTITY_TYPES_ENTITY_TYPE = new HashMap();
    private static final class_2522<class_2520> SNBT_REGISTRY_UNAWARE_PARSER;
    public static final Map<String, Material> BY_NAME;
    private static final List<Class<?>> MAT_CTOR;
    public static final HashMap<String, Material> MODDED_MATERIALS;
    public static final HashMap<class_1792, Material> MODDED_ITEM_MATERIAL;
    public static final HashMap<Material, class_1792> MODDED_MATERIAL_ITEM;
    private final Commodore commodore = new Commodore();

    @Override
    public Material IgetMaterial(class_2248 b) {
        return CraftMagicNumbers.getMaterial(b);
    }

    @Override
    public class_2248 IgetBlock(Material m) {
        return CraftMagicNumbers.getBlock(m);
    }

    private CraftMagicNumbers() {
    }

    public static class_2680 getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static class_2680 getBlock(Material material, byte data) {
        return CraftLegacyMaterials.fromLegacyData(CraftLegacyMaterials.toLegacy(material), data);
    }

    public static MaterialData getMaterial(class_2680 data) {
        return CraftLegacyMaterials.toLegacy(CraftMagicNumbers.getMaterial(data.method_26204())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static class_1792 getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacyMaterials.fromLegacyData(CraftLegacyMaterials.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(class_1792 item) {
        return CraftLegacyMaterials.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    @Deprecated
    public static void setupUnknownModdedMaterials() {
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            class_2960 key = CraftMagicNumbers.key(material);
            class_7923.field_41178.method_17966(key).ifPresent(item -> MATERIAL_ITEM.put(material, (class_1792)item));
            class_7923.field_41175.method_17966(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (class_2248)block));
            class_7923.field_41173.method_17966(key).ifPresent(fluid -> MATERIAL_FLUID.put(material, (class_3611)fluid));
        }
    }

    public static boolean has_mixin_interface(Material m) {
        return m instanceof IMixinMaterial;
    }

    public static void test() {
        Material m;
        Object nam;
        String name;
        class_2960 id;
        CardboardMod.LOGGER.info("DEB: " + Material.values().length);
        int MATERIAL_LENGTH = 2104;
        int i = MATERIAL_LENGTH - 1;
        ArrayList names = new ArrayList();
        ArrayList<Material> list = new ArrayList<Material>();
        String lastMod = "";
        for (class_2248 block2 : class_7923.field_41175) {
            Material material;
            id = class_7923.field_41175.method_10221((Object)block2);
            name = CraftMagicNumbers.standardize(id);
            nam = id.method_12836().toUpperCase(Locale.ROOT) + "_" + id.method_12832().toUpperCase(Locale.ROOT);
            if (id.method_12836().startsWith("minecraft")) {
                boolean has = false;
                try {
                    Material.valueOf((String)id.method_12832().toUpperCase());
                    has = true;
                }
                catch (IllegalArgumentException e) {
                    has = false;
                    nam = id.method_12832().toUpperCase(Locale.ROOT);
                }
                if (has) continue;
            }
            if (null == (material = BY_NAME.get(name)) && !names.contains(name)) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, (List<Object>)ImmutableList.of((Object)i));
                if (!CraftMagicNumbers.has_mixin_interface(material)) {
                    CardboardMod.LOGGER.warning("Material not instanceof IMixinMaterial");
                    return;
                }
                ((IMixinMaterial)material).setModdedData(new CardboardModdedBlock(id.toString()));
                MATERIAL_BLOCK.put(material, block2);
                BY_NAME.put(name, material);
                list.add(material);
                MODDED_MATERIALS.put(name, material);
                if (!lastMod.equalsIgnoreCase(id.field_13353)) {
                    lastMod = id.field_13353;
                    CardboardMod.LOGGER.info("Registering modded blocks from mod '" + lastMod + "'..");
                }
            }
            m = Material.getMaterial((String)nam);
            BLOCK_MATERIAL.put(block2, m);
            MATERIAL_BLOCK.put(m, block2);
        }
        for (class_1792 item2 : class_7923.field_41178) {
            Material material;
            id = class_7923.field_41178.method_10221((Object)item2);
            name = CraftMagicNumbers.standardize(id);
            nam = id.method_12836().toUpperCase(Locale.ROOT) + "_" + id.method_12832().toUpperCase(Locale.ROOT);
            if (id.method_12836().startsWith("minecraft")) {
                boolean has = false;
                try {
                    Material.valueOf((String)id.method_12832().toUpperCase());
                    has = true;
                }
                catch (IllegalArgumentException e) {
                    nam = id.method_12832().toUpperCase(Locale.ROOT);
                    has = false;
                }
                if (has) continue;
            }
            if (null == (material = BY_NAME.get(name)) && !names.contains(name)) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, (List<Object>)ImmutableList.of((Object)i));
                if (!CraftMagicNumbers.has_mixin_interface(material)) {
                    CardboardMod.LOGGER.warning("Material not instanceof IMixinMaterial");
                    return;
                }
                ((IMixinMaterial)material).setModdedData(new CardboardModdedItem(id.toString()));
                MATERIAL_ITEM.put(material, item2);
                BY_NAME.put(name, material);
                list.add(material);
                MODDED_MATERIALS.put(name, material);
                if (!lastMod.equalsIgnoreCase(id.field_13353)) {
                    lastMod = id.field_13353;
                    CardboardMod.LOGGER.info("Registering modded items from mod '" + lastMod + "'..");
                }
            }
            m = Material.getMaterial((String)nam);
            ITEM_MATERIAL.put(item2, m);
            MATERIAL_ITEM.put(m, item2);
        }
        EnumHelper.addEnums(Material.class, list);
        for (Material material : list) {
            class_2960 key = CraftMagicNumbers.key(material);
            class_7923.field_41178.method_17966(key).ifPresent(item -> MATERIAL_ITEM.put(material, (class_1792)item));
            class_7923.field_41175.method_17966(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (class_2248)block));
            class_7923.field_41173.method_17966(key).ifPresent(fluid -> MATERIAL_FLUID.put(material, (class_3611)fluid));
        }
    }

    public static HashMap<String, Material> getModdedMaterials() {
        String name;
        class_2960 id;
        HashMap<String, Material> map = new HashMap<String, Material>();
        for (class_2248 block : class_7923.field_41175) {
            id = class_7923.field_41175.method_10221((Object)block);
            name = CraftMagicNumbers.standardize(id);
            if (id.method_12836().startsWith("minecraft")) continue;
            map.put(name, Material.getMaterial((String)(id.method_12836().toUpperCase(Locale.ROOT) + "_" + id.method_12832().toUpperCase(Locale.ROOT))));
        }
        for (class_1792 item : class_7923.field_41178) {
            id = class_7923.field_41178.method_10221((Object)item);
            name = CraftMagicNumbers.standardize(id);
            if (id.method_12836().startsWith("minecraft")) continue;
            map.put(name, Material.getMaterial((String)(id.method_12836().toUpperCase(Locale.ROOT) + "_" + id.method_12832().toUpperCase(Locale.ROOT))));
        }
        return map;
    }

    public static String standardize(class_2960 location) {
        Preconditions.checkNotNull((Object)location, (Object)"location");
        return (location.method_12836().equals("minecraft") ? location.method_12832() : location.toString()).replace(':', '_').replaceAll("\\s+", "_").replaceAll("\\W", "").toUpperCase(Locale.ENGLISH);
    }

    public static String standardizeLower(class_2960 location) {
        return (location.method_12836().equals("minecraft") ? location.method_12832() : location.toString()).replace(':', '_').replaceAll("\\s+", "_").replaceAll("\\W", "").toLowerCase(Locale.ENGLISH);
    }

    public static Material getMaterial(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        Material m = BLOCK_MATERIAL.getOrDefault(block, Material.getMaterial((String)(id.method_12836().toUpperCase(Locale.ROOT) + "_" + id.method_12832().toUpperCase(Locale.ROOT))));
        BLOCK_MATERIAL.put(block, m);
        MATERIAL_BLOCK.put(m, block);
        return m;
    }

    public static Material getMaterial(class_1792 item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static class_1792 getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacyMaterials.fromLegacy(material);
        }
        return MATERIAL_ITEM.getOrDefault(material, CraftMagicNumbers.getModdedItem(material));
    }

    public static class_2248 getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacyMaterials.fromLegacy(material);
        }
        return MATERIAL_BLOCK.getOrDefault(material, CraftMagicNumbers.getModdedBlock(material));
    }

    private static class_1792 getModdedItem(Material mat) {
        if (!(mat instanceof IMixinMaterial)) {
            return null;
        }
        IMixinMaterial mm = (IMixinMaterial)mat;
        if (!mm.isModded()) {
            return null;
        }
        class_2960 id = class_2960.method_60654((String)mm.getModdedData().getId());
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
        MATERIAL_ITEM.put(mat, item);
        return item;
    }

    private static class_2248 getModdedBlock(Material mat) {
        if (null == mat) {
            return class_2246.field_10340;
        }
        if (!(mat instanceof IMixinMaterial)) {
            return class_2246.field_10340;
        }
        IMixinMaterial mm = (IMixinMaterial)mat;
        if (!mm.isModded()) {
            return null;
        }
        class_2960 id = class_2960.method_60654((String)mm.getModdedData().getId());
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
        MATERIAL_BLOCK.put(mat, block);
        return block;
    }

    public static class_2960 key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public static byte toLegacyData(class_2680 data) {
        return CraftLegacyMaterials.toLegacyData(data);
    }

    public Material toLegacy(Material material) {
        return CraftLegacyMaterials.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacyMaterials.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacyMaterials.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacyMaterials.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        CraftMagicNumbers.setupUnknownModdedMaterials();
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic name = new Dynamic((DynamicOps)class_2509.field_11560, (Object)class_2519.method_23256((String)("minecraft:" + material.toLowerCase(Locale.ROOT))));
        if (name.equals((Object)(converted = class_3551.method_15450().update(class_1208.field_5713, name, version, this.getDataVersion())))) {
            converted = class_3551.method_15450().update(class_1208.field_5731, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    @Deprecated
    public String getMappingsVersion() {
        return "60a2bb6bf2684dc61c56b90d7c41bddc";
    }

    public int getDataVersion() {
        return GameVersion.create().world_version;
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        class_1799 nmsStack = CraftItemStack.asNMSCopy(stack);
        ((IMixinItemStack)nmsStack).IC$modify_arguments(arguments);
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        return false;
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(pdf.getAPIVersion());
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
        }
        if (toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            // empty if block
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), Collections.emptySet());
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        return true;
    }

    public static Fluid getFluid(class_3611 fluid) {
        return FLUID_MATERIAL.get(fluid);
    }

    public static class_3611 getFluid(Fluid fluid) {
        return MATERIAL_FLUID.get(fluid);
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        class_2487 compound = this.deserializeNbtFromBytes(data);
        return this.deserializeItem(compound);
    }

    public String getTimingsServerName() {
        return "Fabric";
    }

    public String getTranslationKey(Material arg0) {
        return arg0.name();
    }

    public String getTranslationKey(Block arg0) {
        return null;
    }

    public String getTranslationKey(EntityType type) {
        Preconditions.checkArgument((type.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)type);
        return class_1299.method_5898((String)type.getName()).map(class_1299::method_5882).orElseThrow();
    }

    public int nextEntityId() {
        return 0;
    }

    public void reportTimings() {
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((!item.isEmpty() ? 1 : 0) != 0, (Object)"Empty itemstack cannot be serialized");
        return this.serializeNbtToBytes((class_2487)class_1799.field_24671.encodeStart((DynamicOps)CraftServer.server.method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)CraftItemStack.unwrap(item)).getOrThrow());
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getItemAttributes(@NotNull Material arg0, @NotNull EquipmentSlot arg1) {
        return null;
    }

    public ItemRarity getItemRarity(Material arg0) {
        return ItemRarity.COMMON;
    }

    public ItemRarity getItemStackRarity(ItemStack arg0) {
        return ItemRarity.COMMON;
    }

    public int getProtocolVersion() {
        return class_155.method_31372();
    }

    public String getTranslationKey(ItemStack arg0) {
        class_1799 nmsItemStack = CraftItemStack.asNMSCopy(arg0);
        return nmsItemStack.method_7909().method_7876();
    }

    public boolean isValidRepairItemStack(@NotNull ItemStack arg0, @NotNull ItemStack arg1) {
        return false;
    }

    public ComponentFlattener componentFlattener() {
        return CardboardAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return CardboardAdventure.COLOR_DOWNSAMPLING_GSON;
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return CardboardAdventure.GSON;
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return CardboardAdventure.PLAIN;
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return CardboardAdventure.LEGACY_SECTION_UXRC;
    }

    public Entity deserializeEntity(byte[] bs, World world, boolean bl) {
        return null;
    }

    @NotNull
    public Attributable getDefaultEntityAttributes(@NotNull NamespacedKey arg0) {
        return null;
    }

    public boolean hasDefaultEntityAttributes(@NotNull NamespacedKey arg0) {
        return false;
    }

    public boolean isCollidable(@NotNull Material arg0) {
        return true;
    }

    public byte[] serializeEntity(Entity entity) {
        return null;
    }

    public CreativeCategory getCreativeCategory(Material arg0) {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material arg0, EquipmentSlot arg1) {
        return null;
    }

    @NotNull
    public String getMainLevelName() {
        return ((class_3176)IMixinMinecraftServer.getServer()).method_16705().field_16820;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return null;
    }

    @NotNull
    public NamespacedKey getBiomeKey(RegionAccessor arg0, int arg1, int arg2, int arg3) {
        return null;
    }

    public Component resolveWithContext(Component arg0, CommandSender arg1, Entity arg2, boolean arg3) throws IOException {
        return null;
    }

    public void setBiomeKey(RegionAccessor arg0, int arg1, int arg2, int arg3, NamespacedKey arg4) {
    }

    public String getBlockTranslationKey(Material material) {
        class_2248 block = CraftMagicNumbers.getBlock(material);
        return block != null ? block.method_63499() : null;
    }

    public FeatureFlag getFeatureFlag(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        return CraftFeatureFlag.getFromNMS(key);
    }

    public String getItemTranslationKey(Material material) {
        class_1792 item = CraftMagicNumbers.getItem(material);
        return item != null ? item.method_7876() : null;
    }

    public static class_1299<?> getEntityTypes(EntityType type) {
        return ENTITY_TYPE_ENTITY_TYPES.get(type);
    }

    public static EntityType getEntityType(class_1299<?> entityTypes) {
        return ENTITY_TYPES_ENTITY_TYPE.get(entityTypes);
    }

    public String getStatisticCriteriaKey(@NotNull Statistic statistic) {
        if (statistic.getType() != Statistic.Type.UNTYPED) {
            return "minecraft.custom:minecraft." + statistic.getKey().getKey();
        }
        return CraftStatistic.getNMSStatistic(statistic).method_1225();
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey key) {
        class_1842 potReg = (class_1842)CraftRegistry.getMinecraftRegistry(class_7924.field_41215).method_17966(CraftNamespacedKey.toMinecraft(key)).orElseThrow();
        return new CraftPotionType(key, potReg);
    }

    public String getTranslationKey(Attribute attribute) {
        return CraftAttribute.bukkitToMinecraft(attribute).method_26830();
    }

    @Nullable
    public DamageEffect getDamageEffect(String key) {
        return CraftDamageEffect.getById(key);
    }

    @NotNull
    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public Color getSpawnEggLayerColor(EntityType entityType, int layer) {
        class_1299<?> nmsType = CraftEntityType.bukkitToMinecraft(entityType);
        class_1826 eggItem = class_1826.method_8019(nmsType);
        if (eggItem != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return eggItem == null ? null : Color.fromRGB((int)1);
    }

    public LifecycleEventManager<Plugin> createPluginLifecycleEventManager(JavaPlugin plugin, BooleanSupplier registrationCheck) {
        return new PaperLifecycleEventManager<JavaPlugin>(plugin, registrationCheck);
    }

    public List<Component> computeTooltipLines(ItemStack itemStack, TooltipContext tooltipContext, Player player) {
        class_1836.class_1837 default_type;
        class_1836.class_1837 class_18372 = default_type = tooltipContext.isAdvanced() ? class_1836.field_41071 : class_1836.field_41070;
        if (tooltipContext.isCreative()) {
            default_type = default_type.method_47371();
        }
        List lines = CraftItemStack.asNMSCopy(itemStack).method_7950(class_1792.class_9635.method_59530((class_7225.class_7874)(player == null ? CraftServer.server.method_30611() : ((CraftPlayer)player).getHandle().method_51469().method_30349())), (class_1657)(player == null ? null : ((CraftPlayer)player).getHandle()), (class_1836)default_type);
        return lines.stream().map(PaperAdventure::asAdventure).toList();
    }

    public String get(Class<?> aClass, String s) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s);
        }
        return s;
    }

    public <B extends Keyed> B get(RegistryKey<B> registry, NamespacedKey key) {
        return CraftRegistry.get(registry, key, ApiVersion.CURRENT);
    }

    public ItemStack createEmptyStack() {
        return CraftItemStack.asCraftMirror(null);
    }

    @NotNull
    public JsonObject serializeItemAsJson(@NotNull ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"Cannot serialize empty ItemStack");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot serialize empty ItemStack");
        class_5455.class_6890 reg = CraftServer.server.method_30611();
        class_6903 ops = reg.method_57093((DynamicOps)JsonOps.INSTANCE);
        JsonObject item = ((JsonElement)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)CraftItemStack.unwrap(itemStack)).getOrThrow()).getAsJsonObject();
        item.addProperty("DataVersion", (Number)this.getDataVersion());
        return item;
    }

    public ItemStack deserializeItemFromJson(JsonObject data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        int dataVersion = data.get("DataVersion").getAsInt();
        int currentVersion = INSTANCE.getDataVersion();
        data = (JsonObject)CraftServer.server.field_4587.update(class_1208.field_5712, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)data), dataVersion, currentVersion).getValue();
        class_6903 ops = CraftServer.server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE);
        return CraftItemStack.asCraftMirror((class_1799)class_1799.field_24671.parse((DynamicOps)ops, (Object)data).getOrThrow(IllegalArgumentException::new));
    }

    private byte[] serializeNbtToBytes(class_2487 compound) {
        compound.method_10569("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            class_2507.method_10634((class_2487)compound, (OutputStream)outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private class_2487 deserializeNbtFromBytes(byte[] data) {
        class_2487 compound;
        try {
            compound = class_2507.method_10629((InputStream)new ByteArrayInputStream(data), (class_2505)class_2505.method_53898());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.method_68083("DataVersion", 0);
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public byte[] serializeEntity(Entity entity, EntitySerializationFlag ... serializationFlags) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"Only CraftEntities can be serialized");
        Set<EntitySerializationFlag> flags = Set.of(serializationFlags);
        boolean serializePassangers = flags.contains(EntitySerializationFlag.PASSENGERS);
        boolean forceSerialization = flags.contains(EntitySerializationFlag.FORCE);
        boolean allowPlayerSerialization = flags.contains(EntitySerializationFlag.PLAYER);
        boolean allowMiscSerialization = flags.contains(EntitySerializationFlag.MISC);
        boolean includeNonSaveable = allowPlayerSerialization || allowMiscSerialization;
        class_1297 nmsEntity = ((CraftEntity)entity).getHandle();
        (serializePassangers ? nmsEntity.method_24204() : Stream.of(nmsEntity)).forEach(e -> {
            Preconditions.checkArgument((e.getBukkitEntity().isValid() && e.getBukkitEntity().isPersistent() || forceSerialization ? 1 : 0) != 0, (String)"Cannot serialize invalid or non-persistent entity %s(%s) without the FORCE flag", (Object)e.method_5864().method_35050(), (Object)e.method_5845());
            if (e instanceof class_1657) {
                Preconditions.checkArgument((boolean)allowPlayerSerialization, (String)"Cannot serialize player(%s) without the PLAYER flag", (Object)e.method_5845());
            } else {
                Preconditions.checkArgument((nmsEntity.method_5864().method_5893() || allowMiscSerialization ? 1 : 0) != 0, (String)"Cannot serialize misc non-saveable entity %s(%s) without the MISC flag", (Object)e.method_5864().method_35050(), (Object)e.method_5845());
            }
        });
        class_2487 compound = new class_2487();
        if (serializePassangers) {
            throw new IllegalArgumentException("Couldn't serialize entity");
        }
        return this.serializeNbtToBytes(compound);
    }

    @NotNull
    public Entity deserializeEntity(byte @NotNull [] data, @NotNull World world, boolean preserveUUID, boolean preservePassengers) {
        return null;
    }

    @NotNull
    public Map<String, Object> serializeStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return Map.of("id", "minecraft:air", "DataVersion", this.getDataVersion(), "schema_version", 1);
        }
        class_2487 tag = (class_2487)class_1799.field_24671.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), (Object)CraftItemStack.asNMSCopy(itemStack)).getOrThrow();
        class_2512.method_48310((class_2487)tag);
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ((class_2487)tag.method_68571().get()).method_68561((key, value) -> {
            switch (key) {
                case "id": {
                    ret.put("id", value.method_68658().get());
                    break;
                }
                case "count": {
                    ret.put("count", value.method_68602().get());
                    break;
                }
                case "components": {
                    LinkedHashMap components = new LinkedHashMap();
                    value.method_68571().ifPresent(compoundTag -> compoundTag.method_68561((componentKey, componentTag) -> {
                        String serializedComponent = componentTag.toString();
                        components.put(componentKey, serializedComponent);
                    }));
                    ret.put("components", components);
                    break;
                }
                case "DataVersion": {
                    ret.put("DataVersion", value.method_68602().get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        ret.put("schema_version", 1);
        return ret;
    }

    @NotNull
    public ItemStack deserializeStack(@NotNull Map<String, Object> args) {
        int n;
        Object object = args.getOrDefault("schema_version", 1);
        if (object instanceof Number) {
            Number val = (Number)object;
            n = val.intValue();
        } else {
            n = -1;
        }
        int version = n;
        class_2487 tag = new class_2487();
        args.forEach((key, value) -> {
            switch (key) {
                case "id": {
                    tag.method_10582("id", (String)value);
                    break;
                }
                case "count": {
                    tag.method_10569("count", ((Number)value).intValue());
                    break;
                }
                case "components": {
                    if (version == 1) {
                        HashMap<String, String> componentMap;
                        if (value instanceof Map) {
                            componentMap = (HashMap<String, String>)value;
                        } else if (value instanceof MemorySection) {
                            MemorySection memory = (MemorySection)value;
                            componentMap = new HashMap<String, String>();
                            for (String memoryKey : memory.getKeys(false)) {
                                componentMap.put(memoryKey, memory.getString(memoryKey));
                            }
                        } else {
                            throw new IllegalArgumentException("components must be a Map");
                        }
                        class_2487 componentsTag = new class_2487();
                        componentMap.forEach((componentKey, componentString) -> {
                            class_2520 componentTag;
                            try {
                                componentTag = (class_2520)SNBT_REGISTRY_UNAWARE_PARSER.method_67313(componentString);
                            }
                            catch (CommandSyntaxException e2) {
                                throw new RuntimeException("Error parsing item stack data components", e2);
                            }
                            componentsTag.method_10566(componentKey, componentTag);
                        });
                        tag.method_10566("components", (class_2520)componentsTag);
                        break;
                    }
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                case "DataVersion": {
                    tag.method_10569("DataVersion", ((Number)value).intValue());
                    break;
                }
                case "==": 
                case "schema_version": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        return this.deserializeItem(tag);
    }

    private ItemStack deserializeItem(class_2487 compound) {
        int dataVersion = compound.method_68083("DataVersion", 0);
        compound = this.platformhooks$convertNBT(class_1208.field_5712, class_3551.method_15450(), compound, dataVersion, this.getDataVersion());
        if (compound.method_68564("id", "minecraft:air").equals("minecraft:air")) {
            return CraftItemStack.asCraftMirror(class_1799.field_8037);
        }
        return CraftItemStack.asCraftMirror((class_1799)class_1799.field_24671.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)class_2509.field_11560), (Object)compound).getOrThrow());
    }

    public class_2487 platformhooks$convertNBT(DSL.TypeReference type, DataFixer dataFixer, class_2487 nbt, int fromVersion, int toVersion) {
        return (class_2487)dataFixer.update(type, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt), fromVersion, toVersion).getValue();
    }

    static {
        BlockImplUtil.setMN((IMagicNumbers)INSTANCE);
        for (EntityType type : EntityType.values()) {
            if (type == EntityType.UNKNOWN) continue;
            ENTITY_TYPE_ENTITY_TYPES.put(type, (class_1299)class_7923.field_41177.method_63535(CraftNamespacedKey.toMinecraft(type.getKey())));
            ENTITY_TYPES_ENTITY_TYPE.put((class_1299)class_7923.field_41177.method_63535(CraftNamespacedKey.toMinecraft(type.getKey())), type);
        }
        for (class_2248 block2 : class_7923.field_41175) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)class_7923.field_41175.method_10221((Object)block2).method_12832().toUpperCase(Locale.ROOT)));
        }
        for (class_1792 item2 : class_7923.field_41178) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)class_7923.field_41178.method_10221((Object)item2).method_12832().toUpperCase(Locale.ROOT)));
        }
        for (class_3611 fluidType : class_7923.field_41173) {
            if (!class_7923.field_41173.method_10221((Object)fluidType).method_12836().equals("minecraft")) continue;
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            class_2960 key = CraftMagicNumbers.key(material);
            class_7923.field_41178.method_17966(key).ifPresent(item -> MATERIAL_ITEM.put(material, (class_1792)item));
            class_7923.field_41175.method_17966(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (class_2248)block));
            class_7923.field_41173.method_17966(key).ifPresent(fluid -> MATERIAL_FLUID.put(material, (class_3611)fluid));
        }
        SNBT_REGISTRY_UNAWARE_PARSER = class_2522.method_68662((DynamicOps)class_2509.field_11560);
        BY_NAME = (Map)Unsafe.getStatic(Material.class, "BY_NAME");
        MAT_CTOR = ImmutableList.of(Integer.TYPE);
        MODDED_MATERIALS = new HashMap();
        MODDED_ITEM_MATERIAL = new HashMap();
        MODDED_MATERIAL_ITEM = new HashMap();
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

