/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.nms.ClassLoaderContext;
import com.mohistmc.banner.bukkit.nms.model.ClassMapping;
import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.cardboardpowered.util.MyPluginFixManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final ClassLoader libraryLoader;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private final Set<String> seenIllegalAccess = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Package> packageCache = Collections.newSetFromMap(new ConcurrentHashMap());
    private static File debug_folder;

    @Nullable
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    PluginClassLoader(@NotNull JavaPluginLoader loader, @Nullable ClassLoader parent, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file, @Nullable ClassLoader libraryLoader) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Preconditions.checkArgument((loader != null ? 1 : 0) != 0, (Object)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.libraryLoader = libraryLoader;
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", (Throwable)ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", (Throwable)ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", (Throwable)ex);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true, true);
    }

    Class<?> loadClass0(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (checkGlobal || result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException result) {
            // empty catch block
        }
        if (checkLibraries && this.libraryLoader != null) {
            try {
                return this.libraryLoader.loadClass(name);
            }
            catch (ClassNotFoundException result) {
                // empty catch block
            }
        }
        if (checkGlobal && (result = this.loader.getClassByName(name, resolve, this.description)) != null) {
            PluginDescriptionFile provider;
            if (result.getClassLoader() instanceof PluginClassLoader && (provider = ((PluginClassLoader)result.getClassLoader()).description) != this.description && !this.seenIllegalAccess.contains(provider.getName()) && !((SimplePluginManager)this.loader.server.getPluginManager()).isTransitiveDepend(this.description, provider)) {
                this.seenIllegalAccess.add(provider.getName());
                if (this.plugin != null) {
                    this.plugin.getLogger().log(Level.WARNING, "Loaded class {0} from {1} which is not a depend or softdepend of this plugin.", new Object[]{name, provider.getFullName()});
                } else {
                    this.loader.server.getLogger().log(Level.WARNING, "[{0}] Loaded class {1} from {2} which is not a depend or softdepend of this plugin.", new Object[]{this.description.getName(), name, provider.getFullName()});
                }
            }
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        ClassLoaderContext.put(this);
        try {
            if (RemapUtils.needRemap(name.replace('/', '.'))) {
                ClassMapping remappedClassMapping = RemapUtils.jarMapping.byNMSName.get(name);
                if (remappedClassMapping == null) {
                    throw new ClassNotFoundException(name.replace('/', '.'));
                }
                String remappedClass = remappedClassMapping.getMcpName();
                Class<?> clazz = Class.forName(remappedClass);
                return clazz;
            }
            if (name.startsWith("org.bukkit.")) {
                throw new ClassNotFoundException(name);
            }
            result = this.classes.get(name);
            String string = name.intern();
            synchronized (string) {
                if (result == null) {
                    result = this.remappedFindClass(name);
                    if (result != null) {
                        this.loader.setClass(name, result);
                    }
                    if (result == null) {
                        try {
                            result = CraftServer.server.getClass().getClassLoader().loadClass(name);
                        }
                        catch (Throwable throwable) {
                            throw new ClassNotFoundException(name, throwable);
                        }
                    }
                    this.loader.setClass(name, result);
                    this.classes.put(name, result);
                }
            }
        }
        finally {
            ClassLoaderContext.pop();
        }
        return result;
    }

    private Class<?> remappedFindClass(String name) {
        Class<?> result = null;
        try {
            InputStream stream;
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url != null && (stream = url.openStream()) != null) {
                byte[] bytecode = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                bytecode = this.loader.server.getUnsafe().processClass(this.description, path, bytecode);
                bytecode = RemapUtils.remapFindClass(bytecode);
                bytecode = this.modifyByteCode(name, bytecode);
                bytecode = MyPluginFixManager.injectPluginFix(name, bytecode);
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarURL = jarURLConnection.getJarFileURL();
                Manifest manifest = jarURLConnection.getManifest();
                this.fixPackage(manifest, url, name);
                CodeSource codeSource = new CodeSource(jarURL, new CodeSigner[0]);
                result = this.defineClass(name, bytecode, 0, bytecode.length, codeSource);
                if (result != null) {
                    this.resolveClass(result);
                }
                if (debug_folder.isDirectory() && (path.contains("worldedit") || path.contains("essentials") || path.contains("ess3") || path.contains("earth2me"))) {
                    File out = new File("C:\\Users\\isaia\\Documents\\fo\\" + name.replace('.', File.separatorChar) + ".class");
                    try {
                        Files.createDirectories(out.toPath().getParent(), new FileAttribute[0]);
                        Files.write(out.toPath(), bytecode, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return result;
    }

    private byte[] modifyByteCode(String className, byte[] bytes) {
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixPackage(Manifest manifest, URL url, String name) {
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            Attributes attributes;
            String pkgName = name.substring(0, dot);
            Package pkg = this.getPackage(pkgName);
            if (pkg == null) {
                try {
                    pkg = manifest != null ? this.definePackage(pkgName, manifest, url) : this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (pkg != null && manifest != null && !this.packageCache.contains(pkg) && (attributes = manifest.getMainAttributes()) != null) {
                try {
                    try {
                        Object versionInfo = MohistDynamEnum.getField(pkg, Package.class.getDeclaredField("versionInfo"));
                        if (versionInfo != null) {
                            Class<?> Package$VersionInfo = Class.forName("java.lang.Package$VersionInfo");
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), Package$VersionInfo.getDeclaredField("implTitle"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), Package$VersionInfo.getDeclaredField("implVersion"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), Package$VersionInfo.getDeclaredField("implVendor"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), Package$VersionInfo.getDeclaredField("specTitle"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), Package$VersionInfo.getDeclaredField("specVersion"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), Package$VersionInfo.getDeclaredField("specVendor"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.packageCache.add(pkg);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    @NotNull
    Collection<Class<?>> getClasses() {
        return this.classes.values();
    }

    synchronized void initialize(@NotNull JavaPlugin javaPlugin) {
        Preconditions.checkArgument((javaPlugin != null ? 1 : 0) != 0, (Object)"Initializing plugin cannot be null");
        Preconditions.checkArgument((((Object)((Object)javaPlugin)).getClass().getClassLoader() == this ? 1 : 0) != 0, (Object)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        debug_folder = new File("C:\\Users\\isaia\\");
    }
}

