/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered;

import java.util.logging.LogRecord;
import org.cardboardpowered.CardboardConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class BukkitLogger
extends java.util.logging.Logger {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Bukkit");
    public Logger log4j;
    private static BukkitLogger inst;
    private boolean doPrefix;

    public static BukkitLogger getLogger() {
        return inst == null ? (inst = new BukkitLogger()) : inst;
    }

    public static java.util.logging.Logger getLogger(String name) {
        return new BukkitLogger(name, null);
    }

    public static java.util.logging.Logger getLogger(String name, String res) {
        return new BukkitLogger(name, res);
    }

    public static BukkitLogger getPluginLogger(String pluginName) {
        return new BukkitLogger(pluginName, null);
    }

    public BukkitLogger() {
        this("Bukkit", null);
        this.doPrefix = false;
    }

    public BukkitLogger(String name, String str) {
        super(name, str);
        this.log4j = LoggerFactory.getLogger((String)name);
        this.doPrefix = CardboardConfig.shouldAddPrefixToLoggers();
        if (inst == null) {
            inst = this;
        }
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        if (this.getParent() != null) {
            this.warning("Ignoring attempt to change parent of plugin logger");
        } else {
            this.info("Setting plugin logger parent to {0}" + parent.getName());
            super.setParent(parent);
        }
    }

    @Override
    public void log(LogRecord lr) {
        Level level = this.convertLevel1(lr.getLevel());
        if (lr.getThrown() == null) {
            if (this.doPrefix) {
                this.log4j.atLevel(level).log("[" + this.getName() + "] " + lr.getMessage());
            } else {
                this.log4j.atLevel(level).log(lr.getMessage());
            }
        } else {
            this.log4j.atLevel(level).log(lr.getMessage(), (Object)lr.getThrown());
        }
    }

    private org.apache.logging.log4j.Level convertLevel(java.util.logging.Level l, LogRecord lr) {
        String m = lr.getMessage();
        if (l == java.util.logging.Level.ALL) {
            return org.apache.logging.log4j.Level.ALL;
        }
        if (l == java.util.logging.Level.CONFIG) {
            return org.apache.logging.log4j.Level.TRACE;
        }
        if (l == java.util.logging.Level.WARNING) {
            return org.apache.logging.log4j.Level.WARN;
        }
        if (l == java.util.logging.Level.INFO) {
            return org.apache.logging.log4j.Level.INFO;
        }
        if (l == java.util.logging.Level.OFF) {
            return org.apache.logging.log4j.Level.OFF;
        }
        if (l == java.util.logging.Level.SEVERE) {
            return org.apache.logging.log4j.Level.FATAL;
        }
        if (l == java.util.logging.Level.FINE || l == java.util.logging.Level.FINER || l == java.util.logging.Level.FINEST) {
            return org.apache.logging.log4j.Level.WARN;
        }
        return org.apache.logging.log4j.Level.ALL;
    }

    private Level convertLevel1(java.util.logging.Level l) {
        if (l == java.util.logging.Level.ALL) {
            return Level.INFO;
        }
        if (l == java.util.logging.Level.CONFIG) {
            return Level.TRACE;
        }
        if (l == java.util.logging.Level.WARNING) {
            return Level.WARN;
        }
        if (l == java.util.logging.Level.INFO) {
            return Level.INFO;
        }
        if (l == java.util.logging.Level.OFF) {
            return Level.TRACE;
        }
        if (l == java.util.logging.Level.SEVERE) {
            return Level.ERROR;
        }
        if (l == java.util.logging.Level.FINE || l == java.util.logging.Level.FINER || l == java.util.logging.Level.FINEST) {
            return Level.WARN;
        }
        return Level.INFO;
    }

    private org.apache.logging.log4j.Level convertLevel(java.util.logging.Level l) {
        if (l == java.util.logging.Level.ALL) {
            return org.apache.logging.log4j.Level.ALL;
        }
        if (l == java.util.logging.Level.CONFIG) {
            return org.apache.logging.log4j.Level.TRACE;
        }
        if (l == java.util.logging.Level.WARNING) {
            return org.apache.logging.log4j.Level.WARN;
        }
        if (l == java.util.logging.Level.INFO) {
            return org.apache.logging.log4j.Level.INFO;
        }
        if (l == java.util.logging.Level.OFF) {
            return org.apache.logging.log4j.Level.OFF;
        }
        if (l == java.util.logging.Level.SEVERE) {
            return org.apache.logging.log4j.Level.FATAL;
        }
        if (l == java.util.logging.Level.FINE || l == java.util.logging.Level.FINER || l == java.util.logging.Level.FINEST) {
            return org.apache.logging.log4j.Level.WARN;
        }
        return org.apache.logging.log4j.Level.ALL;
    }
}

