/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered;

import org.cardboardpowered.CardboardConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardboardLogger {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"Cardboard");
    private String prefix;

    public static CardboardLogger get(String prefix) {
        return new CardboardLogger(prefix);
    }

    public static Logger getSLF4J() {
        return LOGGER;
    }

    public CardboardLogger() {
        this.prefix = "";
    }

    public CardboardLogger(String prefix) {
        this.prefix = prefix + " ";
    }

    public void info(String message) {
        LOGGER.info(this.prefix + message);
    }

    public void error(String message) {
        LOGGER.error(this.prefix + message);
    }

    public void debug(String message) {
        if (CardboardConfig.DEBUG_OTHER || CardboardConfig.DEBUG_VERBOSE_CALLS) {
            LOGGER.info(this.prefix + " (DEBUG): " + message);
        }
    }
}

