/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered;

import io.izzel.arclight.api.EnumHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1842;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_7923;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.potion.PotionType;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.CardboardMod;

public class RegistryUtil {
    public static void inject_into_bukkit_registry(class_3176 server) {
        RegistryUtil.register_potions();
    }

    public static String normalizeName(String name) {
        return name.replace(':', '_').replaceAll("\\s+", "_").replaceAll("\\W", "").toUpperCase(Locale.ENGLISH);
    }

    private static void register_potions() {
        ArrayList<PotionType> newTypes = new ArrayList<PotionType>();
        for (class_1842 potion : class_7923.field_41179) {
            class_2960 location = class_7923.field_41179.method_10221((Object)potion);
            String name = RegistryUtil.normalizeName(location.toString());
            try {
                PotionType.valueOf((String)name);
                CardboardMod.LOGGER.info("FOUND POT for " + name);
            }
            catch (Exception e) {
                NamespacedKey namespacedKey = CraftNamespacedKey.fromMinecraft(location);
                PotionType potionType = EnumHelper.addEnum(PotionType.class, name, List.of(String.class), List.of(namespacedKey.getKey()));
                newTypes.add(potionType);
                if (!CardboardConfig.DEBUG_VERBOSE_CALLS) continue;
                CardboardMod.LOGGER.info("Registered " + String.valueOf(location) + " as potion type " + String.valueOf(potionType));
            }
        }
    }

    public static boolean isVanilla(class_2960 id) {
        return id.method_12836().equalsIgnoreCase("minecraft");
    }

    public static boolean isModded(class_2960 id) {
        return !RegistryUtil.isVanilla(id);
    }
}

