/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_3002;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Player;
import org.cardboardpowered.impl.entity.CraftPlayer;

public class CardboardBossBar
implements BossBar,
KeyedBossBar {
    private final class_3213 handle;
    private Map<BarFlag, FlagContainer> flags;

    public CardboardBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new class_3213(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CardboardBossBar(class_3213 bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    public CardboardBossBar(class_3002 bossBattleCustom) {
        this.handle = bossBattleCustom;
        this.initialize();
    }

    public NamespacedKey getKey() {
        if (this.handle instanceof class_3002) {
            return CraftNamespacedKey.fromMinecraft(((class_3002)this.handle).method_12959());
        }
        throw new UnsupportedOperationException("BossBar is not keyed!");
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(() -> ((class_3213)this.handle).method_5417(), arg_0 -> ((class_3213)this.handle).method_5406(arg_0)));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(() -> ((class_3213)this.handle).method_5418(), arg_0 -> ((class_3213)this.handle).method_5410(arg_0)));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(() -> ((class_3213)this.handle).method_5419(), arg_0 -> ((class_3213)this.handle).method_5411(arg_0)));
    }

    private BarColor convertColor(class_1259.class_1260 color) {
        BarColor bukkitColor = BarColor.valueOf((String)color.name());
        return bukkitColor == null ? BarColor.WHITE : bukkitColor;
    }

    private class_1259.class_1260 convertColor(BarColor color) {
        class_1259.class_1260 nmsColor = class_1259.class_1260.valueOf((String)color.name());
        return nmsColor == null ? class_1259.class_1260.field_5786 : nmsColor;
    }

    private class_1259.class_1261 convertStyle(BarStyle style) {
        switch (style) {
            default: {
                return class_1259.class_1261.field_5795;
            }
            case SEGMENTED_6: {
                return class_1259.class_1261.field_5796;
            }
            case SEGMENTED_10: {
                return class_1259.class_1261.field_5791;
            }
            case SEGMENTED_12: {
                return class_1259.class_1261.field_5793;
            }
            case SEGMENTED_20: 
        }
        return class_1259.class_1261.field_5790;
    }

    private BarStyle convertStyle(class_1259.class_1261 style) {
        switch (style) {
            default: {
                return BarStyle.SOLID;
            }
            case field_5796: {
                return BarStyle.SEGMENTED_6;
            }
            case field_5791: {
                return BarStyle.SEGMENTED_10;
            }
            case field_5793: {
                return BarStyle.SEGMENTED_12;
            }
            case field_5790: 
        }
        return BarStyle.SEGMENTED_20;
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.field_5777);
    }

    public void setTitle(String title) {
        this.handle.field_5777 = CraftChatMessage.fromString(title, true)[0];
    }

    public BarColor getColor() {
        return this.convertColor(this.handle.field_5778);
    }

    public void setColor(BarColor color) {
        this.handle.field_5778 = this.convertColor(color);
    }

    public BarStyle getStyle() {
        return this.convertStyle(this.handle.field_5779);
    }

    public void setStyle(BarStyle style) {
        this.handle.field_5779 = this.convertStyle(style);
    }

    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        return flagContainer != null ? flagContainer.get.get() : false;
    }

    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.method_5408((float)progress);
    }

    public double getProgress() {
        return this.handle.method_5412();
    }

    public void addPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        Preconditions.checkArgument((((CraftPlayer)player).getHandle().field_13987 != null ? 1 : 0) != 0, (Object)"player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.method_14088(((CraftPlayer)player).getHandle());
    }

    public void removePlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        this.handle.method_14089(((CraftPlayer)player).getHandle());
    }

    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (class_3222 p : this.handle.method_14092()) {
            players.add((Object)((Player)p.getBukkitEntity()));
        }
        return players.build();
    }

    public void setVisible(boolean visible) {
        this.handle.method_14091(visible);
    }

    public boolean isVisible() {
        return this.handle.field_13912;
    }

    public void show() {
        this.handle.method_14091(true);
    }

    public void hide() {
        this.handle.method_14091(false);
    }

    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public class_3213 getHandle() {
        return this.handle;
    }

    private static final class FlagContainer {
        private final Supplier<Boolean> get;
        private final Consumer<Boolean> set;

        public FlagContainer(Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

