/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MetadataStoreImpl {
    public static MetadataStoreBase<Entity> newEntityMetadataStore() {
        return new MetadataStoreBase<Entity>(){

            @NotNull
            protected String disambiguate(@NotNull Entity entity, @NotNull String metadataKey) {
                return entity.getUniqueId().toString() + ":" + metadataKey;
            }
        };
    }

    public static MetadataStoreBase<OfflinePlayer> newPlayerMetadataStore() {
        return new MetadataStoreBase<OfflinePlayer>(){

            @NotNull
            protected String disambiguate(@NotNull OfflinePlayer player, @NotNull String metadataKey) {
                return String.valueOf(player.getUniqueId()) + ":" + metadataKey;
            }
        };
    }

    public static MetadataStoreBase<World> newWorldMetadataStore() {
        return new MetadataStoreBase<World>(){

            @NotNull
            protected String disambiguate(@NotNull World world, @NotNull String metadataKey) {
                return world.getUID().toString() + ":" + metadataKey;
            }
        };
    }

    public static MetadataStoreBase<Block> newBlockMetadataStore(final World world) {
        return new MetadataStoreBase<Block>(){

            @NotNull
            protected String disambiguate(@NotNull Block block, @NotNull String metadataKey) {
                return block.getX() + ":" + block.getY() + ":" + block.getZ() + ":" + metadataKey;
            }

            @NotNull
            public List<MetadataValue> getMetadata(@NotNull Block block, @NotNull String metadataKey) {
                if (block.getWorld() == world) {
                    return super.getMetadata((Object)block, metadataKey);
                }
                throw new IllegalArgumentException("Block does not belong to world " + world.getName());
            }

            public boolean hasMetadata(@NotNull Block block, @NotNull String metadataKey) {
                if (block.getWorld() == world) {
                    return super.hasMetadata((Object)block, metadataKey);
                }
                throw new IllegalArgumentException("Block does not belong to world " + world.getName());
            }

            public void removeMetadata(@NotNull Block block, @NotNull String metadataKey, @NotNull Plugin owningPlugin) {
                if (block.getWorld() != world) {
                    throw new IllegalArgumentException("Block does not belong to world " + world.getName());
                }
                super.removeMetadata((Object)block, metadataKey, owningPlugin);
            }

            public void setMetadata(@NotNull Block block, @NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
                if (block.getWorld() != world) {
                    throw new IllegalArgumentException("Block does not belong to world " + world.getName());
                }
                super.setMetadata((Object)block, metadataKey, newMetadataValue);
            }
        };
    }
}

