/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_9463;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.WindCharge;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.cardboardpowered.interfaces.IMixinWorld;

public class CardboardBlockProjectileSource
implements BlockProjectileSource {
    private final class_2601 dispenserBlock;

    public CardboardBlockProjectileSource(class_2601 dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return ((IMixinWorld)this.dispenserBlock.method_10997()).getCraftWorld().getBlockAt(this.dispenserBlock.method_11016().method_10263(), this.dispenserBlock.method_11016().method_10264(), this.dispenserBlock.method_11016().method_10260());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        class_1792 item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = class_1802.field_8543;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = class_1802.field_8803;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = class_1802.field_8287;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? class_1802.field_8150 : class_1802.field_8436;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            item = SpectralArrow.class.isAssignableFrom(projectile) ? class_1802.field_8236 : class_1802.field_8107;
        } else if (WindCharge.class.isAssignableFrom(projectile)) {
            item = class_1802.field_49098;
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = class_1802.field_8639;
        } else if (SmallFireball.class.isAssignableFrom(projectile)) {
            item = class_1802.field_8814;
        }
        if (!(item instanceof class_9463)) {
            throw new IllegalArgumentException("Projectile '%s' is not supported".formatted(projectile.getSimpleName()));
        }
        class_9463 projectileItem = (class_9463)item;
        class_9463.class_9464 config = projectileItem.method_58653();
        class_2680 state = this.dispenserBlock.method_11010();
        class_1937 world = this.dispenserBlock.method_10997();
        class_2342 pointer = new class_2342((class_3218)world, this.dispenserBlock.method_11016(), state, this.dispenserBlock);
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2315.field_10918);
        class_2374 pos = config.comp_2544().getDispensePosition(pointer, facing);
        class_1676 launch = projectileItem.method_58648(world, pos, new class_1799((class_1935)item), facing);
        projectileItem.method_58654(launch, (double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165(), config.comp_2546(), config.comp_2545());
        launch.setProjectileSourceBukkit((ProjectileSource)this);
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Projectile)launch.getBukkitEntity());
        }
        world.method_8649((class_1297)launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

