/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.interfaces.IMixinInventory;
import org.cardboardpowered.interfaces.IMixinPlayerInventory;
import org.jetbrains.annotations.NotNull;

public class CardboardPlayerInventory
extends CraftInventory
implements PlayerInventory,
EntityEquipment {
    public CardboardPlayerInventory(class_1661 inventory) {
        super((class_1263)inventory);
    }

    public class_1661 getInventory() {
        return (class_1661)this.inventory;
    }

    private IMixinPlayerInventory IgetInventory() {
        return (IMixinPlayerInventory)((class_1661)this.inventory);
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.asCraftMirror((List<class_1799>)this.getInventory().field_7547);
    }

    public ItemStack getItemInMainHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().method_7391());
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItem(this.getHeldItemSlot(), item);
    }

    public ItemStack getItemInOffHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().field_56552.method_66659(class_1304.field_6171));
    }

    public void setItemInOffHand(ItemStack item) {
        ItemStack[] extra = this.getExtraContents();
        extra[0] = item;
        this.setExtraContents(extra);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        super.setItem(index, item);
        if (this.getHolder() == null) {
            return;
        }
        class_3222 player = ((CraftPlayer)this.getHolder()).getHandle();
        if (player.field_13987 == null) {
            return;
        }
        if (index < class_1661.method_7368()) {
            index += 36;
        } else if (index > 39) {
            index += 5;
        } else if (index > 35) {
            index = 8 - (index - 36);
        }
        player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), index, CraftItemStack.asNMSCopy(item)));
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not implemented. This is a bug");
            }
        }
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                return this.getItemInMainHand();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
            case FEET: {
                return this.getBoots();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case CHEST: {
                return this.getChestplate();
            }
            case HEAD: {
                return this.getHelmet();
            }
        }
        throw new IllegalArgumentException("Not implemented");
    }

    public int getHeldItemSlot() {
        return this.getInventory().method_67532();
    }

    public void setHeldItemSlot(int slot) {
        Validate.isTrue(slot >= 0 && slot < class_1661.method_7368(), "Slot is not between 0 and 8 inclusive");
        this.getInventory().method_61496(slot);
        ((CraftPlayer)this.getHolder()).getHandle().field_13987.method_14364((class_2596)new class_2735(slot));
    }

    public ItemStack getHelmet() {
        return this.getItem(this.getSize() - 2);
    }

    public ItemStack getChestplate() {
        return this.getItem(this.getSize() - 3);
    }

    public ItemStack getLeggings() {
        return this.getItem(this.getSize() - 4);
    }

    public ItemStack getBoots() {
        return this.getItem(this.getSize() - 5);
    }

    public void setHelmet(ItemStack helmet) {
        this.setItem(this.getSize() - 2, helmet);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setItem(this.getSize() - 3, chestplate);
    }

    public void setLeggings(ItemStack leggings) {
        this.setItem(this.getSize() - 4, leggings);
    }

    public void setBoots(ItemStack boots) {
        this.setItem(this.getSize() - 5, boots);
    }

    public ItemStack[] getArmorContents() {
        return this.asCraftMirror(this.IgetInventory().getArmorContents());
    }

    private void setSlots(ItemStack[] items, int baseSlot, int length) {
        if (items == null) {
            items = new ItemStack[length];
        }
        Preconditions.checkArgument((items.length <= length ? 1 : 0) != 0, (Object)("items.length must be < " + length));
        for (int i = 0; i < length; ++i) {
            this.setItem(baseSlot + i, i >= items.length ? null : items[i]);
        }
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setSlots(items, 0, this.getInventory().field_7547.size());
    }

    public void setArmorContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().method_67533().size(), this.IgetInventory().getArmorContents().size());
    }

    public ItemStack[] getExtraContents() {
        return this.asCraftMirror(this.IgetInventory().getExtraContent());
    }

    public void setExtraContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().method_67533().size() + this.IgetInventory().getArmorContents().size(), 3);
    }

    public HumanEntity getHolder() {
        return (HumanEntity)((IMixinInventory)this.inventory).getOwner();
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return 1.0f;
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getItemInOffHandDropChance() {
        return 1.0f;
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getHelmetDropChance() {
        return 1.0f;
    }

    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getChestplateDropChance() {
        return 1.0f;
    }

    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getLeggingsDropChance() {
        return 1.0f;
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getBootsDropChance() {
        return 1.0f;
    }

    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public InventoryHolder getHolder(boolean arg0) {
        return this.getHolder();
    }

    @Override
    public HashMap<Integer, ItemStack> removeItemAnySlot(ItemStack ... arg0) throws IllegalArgumentException {
        return null;
    }

    public void setBoots(ItemStack arg0, boolean arg1) {
    }

    public void setChestplate(ItemStack arg0, boolean arg1) {
    }

    public void setHelmet(ItemStack arg0, boolean arg1) {
    }

    public void setItem(EquipmentSlot arg0, ItemStack arg1, boolean arg2) {
    }

    public void setItemInMainHand(ItemStack arg0, boolean arg1) {
        this.setItemInMainHand(arg0);
    }

    public void setItemInOffHand(ItemStack arg0, boolean arg1) {
        this.setItemInOffHand(arg0);
    }

    public void setLeggings(ItemStack arg0, boolean arg1) {
    }

    @Override
    public int close() {
        return 0;
    }

    public float getDropChance(@NotNull EquipmentSlot arg0) {
        return 0.0f;
    }

    public void setDropChance(@NotNull EquipmentSlot arg0, float arg1) {
    }
}

