/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util.nms;

import com.google.common.base.Joiner;
import io.netty.channel.ChannelHandler;
import org.cardboardpowered.util.nms.ReflectionRemapper;

public class ProtocolLibMapper {
    public static boolean guessCompression(ChannelHandler handler) {
        String[] names;
        String className = handler != null ? handler.getClass().getCanonicalName() : "";
        for (String name : names = new String[]{"Inflater", "Deflater", "class_2532", "class_2534", "Compressor", "Decompressor"}) {
            if (!className.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getCraftBukkitClass(String className) {
        try {
            return Class.forName(ReflectionRemapper.mapClassName("org.bukkit.craftbukkit." + className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find CraftBukkit class!!!!: " + className);
        }
    }

    public static Class<?> getMinecraftClass(String className) {
        try {
            if (className.equals("ServerConnection")) {
                return Class.forName(ReflectionRemapper.mapClassName("net.minecraft.server.ServerNetworkIo"));
            }
            return Class.forName(ReflectionRemapper.mapClassName("net.minecraft." + className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find Minecraft class!!!!: " + className);
        }
    }

    public static Class<?> getMinecraftClass(String className, String ... aliases) {
        try {
            return ProtocolLibMapper.getMinecraftClass(className);
        }
        catch (RuntimeException e) {
            Class<?> success = null;
            for (String alias : aliases) {
                try {
                    success = ProtocolLibMapper.getMinecraftClass(alias);
                    break;
                }
                catch (RuntimeException runtimeException) {
                }
            }
            if (success != null) {
                return success;
            }
            throw new RuntimeException(String.format("Unable to find " + className + " (%s)", Joiner.on((String)", ").join((Object[])aliases)));
        }
    }
}

