/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.profile.MutablePropertyMap;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.minecraft.class_12079;
import net.minecraft.class_3544;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.profile.PlayerTextures;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record PaperResolvableProfile(class_9296 impl) implements ResolvableProfile,
Handleable<class_9296>
{
    static PaperResolvableProfile toApi(PlayerProfile profile) {
        return new PaperResolvableProfile(((SharedPlayerProfile)profile).buildResolvableProfile());
    }

    @Override
    public class_9296 getHandle() {
        return this.impl;
    }

    public @Nullable UUID uuid() {
        return (UUID)this.impl.method_73305().map(GameProfile::id, p -> p.comp_4626().orElse(null));
    }

    public @Nullable String name() {
        return (String)this.impl.method_73305().map(GameProfile::name, p -> p.comp_4625().orElse(null));
    }

    public @Unmodifiable Collection<ProfileProperty> properties() {
        return MCUtil.transformUnmodifiable(((PropertyMap)this.impl.method_73305().map(GameProfile::properties, class_9296.class_11757::comp_4627)).values(), input -> new ProfileProperty(input.name(), input.value(), input.signature()));
    }

    public CompletableFuture<PlayerProfile> resolve() {
        return this.impl.method_73306(CraftServer.server.method_73550().comp_4624()).thenApply(CraftPlayerProfile::asBukkitCopy);
    }

    public void applySkinToPlayerHeadContents(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PlayerHeadObjectContents.Builder builder) {
        if (this.dynamic()) {
            if (this.uuid() != null) {
                builder.id(this.uuid());
            } else {
                builder.name(this.name());
            }
        } else {
            builder.id(this.uuid()).name(this.name()).profileProperties(((PropertyMap)this.impl.method_73305().map(GameProfile::properties, class_9296.class_11757::comp_4627)).values().stream().map(prop -> PlayerHeadObjectContents.property((String)prop.name(), (String)prop.value(), (String)prop.signature())).toList()).texture((Key)this.impl.method_74890().comp_4765().map(class_12079.class_10726::comp_3626).map(PaperAdventure::asAdventure).orElse(null));
        }
    }

    public boolean dynamic() {
        return this.impl instanceof class_9296.class_11756;
    }

    public ResolvableProfile.SkinPatch skinPatch() {
        return PaperSkinPatch.asPaper(this.getHandle().method_74890());
    }

    record PaperSkinPatch(@Nullable Key body, @Nullable Key cape, @Nullable Key elytra, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlayerTextures.SkinModel model) implements ResolvableProfile.SkinPatch
    {
        static PaperSkinPatch asPaper(class_8685.class_11892 patch) {
            return patch == class_8685.class_11892.field_63029 ? (PaperSkinPatch)ResolvableProfile.SkinPatch.empty() : new PaperSkinPatch(patch.comp_4765().map(class_12079.class_10726::comp_3626).map(PaperAdventure::asAdventure).orElse(null), patch.comp_4766().map(class_12079.class_10726::comp_3626).map(PaperAdventure::asAdventure).orElse(null), patch.comp_4767().map(class_12079.class_10726::comp_3626).map(PaperAdventure::asAdventure).orElse(null), patch.comp_4768().map(m -> m == class_7920.field_41122 ? PlayerTextures.SkinModel.SLIM : PlayerTextures.SkinModel.CLASSIC).orElse(null));
        }

        class_8685.class_11892 asVanilla() {
            return class_8685.class_11892.method_74885(Optional.ofNullable(this.body).map(key -> new class_12079.class_10726(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.cape).map(key -> new class_12079.class_10726(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.elytra).map(key -> new class_12079.class_10726(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.model).map(m -> m == PlayerTextures.SkinModel.SLIM ? class_7920.field_41122 : class_7920.field_41123));
        }
    }

    static final class SkinPatchBuilderImpl
    implements ResolvableProfile.SkinPatchBuilder {
        private @Nullable Key body;
        private @Nullable Key cape;
        private @Nullable Key elytra;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PlayerTextures.SkinModel model;

        SkinPatchBuilderImpl() {
        }

        public ResolvableProfile.SkinPatchBuilder body(@Nullable Key body) {
            this.body = body;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder cape(@Nullable Key cape) {
            this.cape = cape;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder elytra(@Nullable Key elytra) {
            this.elytra = elytra;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder model(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PlayerTextures.SkinModel model) {
            this.model = model;
            return this;
        }

        public ResolvableProfile.SkinPatch build() {
            return this.body == null && this.cape == null && this.elytra == null && this.model == null ? ResolvableProfile.SkinPatch.empty() : new PaperSkinPatch(this.body, this.cape, this.elytra, this.model);
        }
    }

    static final class BuilderImpl
    implements ResolvableProfile.Builder {
        private final PropertyMap propertyMap = new MutablePropertyMap();
        private @Nullable String name;
        private @Nullable UUID uuid;
        private PaperSkinPatch skinPatch = (PaperSkinPatch)ResolvableProfile.SkinPatch.empty();

        BuilderImpl() {
        }

        public ResolvableProfile.Builder name(@Nullable String name) {
            if (name != null) {
                Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (String)"name cannot be more than 16 characters, was %s", (int)name.length());
                Preconditions.checkArgument((boolean)class_3544.method_57179((String)name), (String)"name cannot include invalid characters, was %s", (Object)name);
            }
            this.name = name;
            return this;
        }

        public ResolvableProfile.Builder uuid(@Nullable UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public ResolvableProfile.Builder addProperty(ProfileProperty property) {
            Property newProperty = new Property(property.getName(), property.getValue(), property.getSignature());
            if (!this.propertyMap.containsEntry((Object)property.getName(), (Object)newProperty)) {
                int newSize = this.propertyMap.size() + 1;
                Preconditions.checkArgument((newSize <= 16 ? 1 : 0) != 0, (String)"Cannot have more than 16 properties, was %s", (int)newSize);
            }
            this.propertyMap.put((Object)property.getName(), (Object)newProperty);
            return this;
        }

        public ResolvableProfile.Builder addProperties(Collection<ProfileProperty> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        public ResolvableProfile.Builder skinPatch(ResolvableProfile.SkinPatch patch) {
            Preconditions.checkArgument((patch != null ? 1 : 0) != 0, (Object)"patch cannot be null");
            this.skinPatch = (PaperSkinPatch)patch;
            return this;
        }

        public ResolvableProfile.Builder skinPatch(Consumer<ResolvableProfile.SkinPatchBuilder> configure) {
            Preconditions.checkArgument((configure != null ? 1 : 0) != 0, (Object)"configure cannot be null");
            ResolvableProfile.SkinPatchBuilder builder = ResolvableProfile.SkinPatch.skinPatch();
            builder.body(this.skinPatch.body());
            builder.cape(this.skinPatch.cape());
            builder.elytra(this.skinPatch.elytra());
            builder.model(this.skinPatch.model());
            configure.accept(builder);
            this.skinPatch = (PaperSkinPatch)builder.build();
            return this;
        }

        public ResolvableProfile build() {
            class_8685.class_11892 todoAddThis = class_8685.class_11892.field_63029;
            return this.propertyMap.isEmpty() && this.uuid == null != (this.name == null) ? new PaperResolvableProfile((class_9296)new class_9296.class_11756(this.name != null ? Either.left((Object)this.name) : Either.right((Object)this.uuid), todoAddThis)) : new PaperResolvableProfile((class_9296)new class_9296.class_11758(Either.right((Object)new class_9296.class_11757(Optional.ofNullable(this.name), Optional.ofNullable(this.uuid), new PropertyMap((Multimap)this.propertyMap))), todoAddThis));
        }
    }
}

