/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.text.Filtered;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperWrittenBookContent(class_9302 impl) implements WrittenBookContent,
Handleable<class_9302>
{
    @Override
    public class_9302 getHandle() {
        return this.impl;
    }

    public Filtered<String> title() {
        return Filtered.of((Object)((String)this.impl.comp_2419().comp_2369()), (Object)this.impl.comp_2419().comp_2370().orElse(null));
    }

    public String author() {
        return this.impl.comp_2420();
    }

    public int generation() {
        return this.impl.comp_2421();
    }

    public @Unmodifiable List<Filtered<Component>> pages() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2422(), page -> Filtered.of((Object)PaperAdventure.asAdventure((class_2561)page.comp_2369()), (Object)page.comp_2370().map(PaperAdventure::asAdventure).orElse(null)));
    }

    public boolean resolved() {
        return this.impl.comp_2423();
    }

    static final class BuilderImpl
    implements WrittenBookContent.Builder {
        private final List<class_9262<class_2561>> pages = new ObjectArrayList();
        private class_9262<String> title;
        private String author;
        private int generation = 0;
        private boolean resolved = false;

        BuilderImpl(Filtered<String> title, String author) {
            BuilderImpl.validateTitle((String)title.raw());
            if (title.filtered() != null) {
                BuilderImpl.validateTitle((String)title.filtered());
            }
            this.title = new class_9262((Object)((String)title.raw()), Optional.ofNullable((String)title.filtered()));
            this.author = author;
        }

        private static void validateTitle(String title) {
            Preconditions.checkArgument((title.length() <= 32 ? 1 : 0) != 0, (String)"Title cannot be longer than %s, was %s", (int)32, (int)title.length());
        }

        private static void validatePageLength(Component page) {
            String flagPage = class_3518.method_43680((JsonElement)GsonComponentSerializer.gson().serializeToTree(page));
            Preconditions.checkArgument((flagPage.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot have page length more than %s, had %s", (int)Short.MAX_VALUE, (int)flagPage.length());
        }

        public WrittenBookContent.Builder title(String title) {
            BuilderImpl.validateTitle(title);
            this.title = class_9262.method_57137((Object)title);
            return this;
        }

        public WrittenBookContent.Builder filteredTitle(Filtered<String> title) {
            BuilderImpl.validateTitle((String)title.raw());
            if (title.filtered() != null) {
                BuilderImpl.validateTitle((String)title.filtered());
            }
            this.title = new class_9262((Object)((String)title.raw()), Optional.ofNullable((String)title.filtered()));
            return this;
        }

        public WrittenBookContent.Builder author(String author) {
            this.author = author;
            return this;
        }

        public WrittenBookContent.Builder generation(int generation) {
            Preconditions.checkArgument((generation >= 0 && generation <= 3 ? 1 : 0) != 0, (String)"generation must be between %s and %s, was %s", (Object)0, (Object)3, (Object)generation);
            this.generation = generation;
            return this;
        }

        public WrittenBookContent.Builder resolved(boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public WrittenBookContent.Builder addPage(ComponentLike page) {
            Component component = page.asComponent();
            BuilderImpl.validatePageLength(component);
            this.pages.add((class_9262<class_2561>)class_9262.method_57137((Object)PaperAdventure.asVanilla(component)));
            return this;
        }

        public WrittenBookContent.Builder addPages(List<? extends ComponentLike> pages) {
            for (ComponentLike componentLike : pages) {
                Component component = componentLike.asComponent();
                BuilderImpl.validatePageLength(component);
                this.pages.add((class_9262<class_2561>)class_9262.method_57137((Object)PaperAdventure.asVanilla(component)));
            }
            return this;
        }

        public WrittenBookContent.Builder addFilteredPage(Filtered<? extends ComponentLike> page) {
            Component raw = ((ComponentLike)page.raw()).asComponent();
            BuilderImpl.validatePageLength(raw);
            Component filtered = null;
            if (page.filtered() != null) {
                filtered = ((ComponentLike)page.filtered()).asComponent();
                BuilderImpl.validatePageLength(filtered);
            }
            this.pages.add((class_9262<class_2561>)new class_9262((Object)PaperAdventure.asVanilla(raw), Optional.ofNullable(filtered).map(PaperAdventure::asVanilla)));
            return this;
        }

        public WrittenBookContent.Builder addFilteredPages(List<Filtered<? extends ComponentLike>> pages) {
            pages.forEach(this::addFilteredPage);
            return this;
        }

        public WrittenBookContent build() {
            return new PaperWrittenBookContent(new class_9302(this.title, this.author, this.generation, (List)new ObjectArrayList(this.pages), this.resolved));
        }
    }
}

