/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.bukkit.Keyed;
import org.jspecify.annotations.Nullable;

public class PaperRegistryBuilderFactory<M, A extends Keyed, B extends PaperRegistryBuilder<M, A>>
implements RegistryBuilderFactory<A, B> {
    private final class_5321<? extends class_2378<M>> registryKey;
    private final Conversions conversions;
    private final PaperRegistryBuilder.Filler<M, A, B> builderFiller;
    private final Function<class_5321<M>, Optional<M>> existingValueGetter;
    private @Nullable B builder;

    public PaperRegistryBuilderFactory(class_5321<? extends class_2378<M>> registryKey, Conversions conversions, PaperRegistryBuilder.Filler<M, A, B> builderFiller, Function<class_5321<M>, Optional<M>> existingValueGetter) {
        this.registryKey = registryKey;
        this.conversions = conversions;
        this.builderFiller = builderFiller;
        this.existingValueGetter = existingValueGetter;
    }

    private void validate() {
        if (this.builder != null) {
            throw new IllegalStateException("Already created a builder");
        }
    }

    public B requireBuilder() {
        if (this.builder == null) {
            throw new IllegalStateException("Builder not created yet");
        }
        return this.builder;
    }

    public B empty() {
        this.validate();
        this.builder = this.builderFiller.create(this.conversions);
        return this.builder;
    }

    public B copyFrom(TypedKey<A> key) {
        this.validate();
        Optional<M> existing = this.existingValueGetter.apply(PaperAdventure.asVanilla(this.registryKey, key));
        if (existing.isEmpty()) {
            throw new IllegalArgumentException("Key " + String.valueOf(key) + " doesn't exist");
        }
        this.builder = this.builderFiller.fill(this.conversions, existing.get());
        return this.builder;
    }
}

