/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.ban.BanListType;
import io.papermc.paper.configuration.PaperServerConfiguration;
import io.papermc.paper.configuration.ServerConfiguration;
import io.papermc.paper.datapack.DatapackManager;
import io.papermc.paper.math.Position;
import io.papermc.paper.profile.PaperFilledProfileCache;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1863;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2596;
import net.minecraft.class_269;
import net.minecraft.class_2788;
import net.minecraft.class_29;
import net.minecraft.class_2960;
import net.minecraft.class_2976;
import net.minecraft.class_3002;
import net.minecraft.class_3004;
import net.minecraft.class_3174;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3320;
import net.minecraft.class_3611;
import net.minecraft.class_3806;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.ServerLinks;
import org.bukkit.ServerTickManager;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftServerTickManager;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityFactory;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.packs.CraftDataPackManager;
import org.bukkit.craftbukkit.packs.CraftResourcePack;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardManager;
import org.bukkit.craftbukkit.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemCraftResult;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.packs.ResourcePack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.cardboardpowered.BukkitLogger;
import org.cardboardpowered.RegistryUtil;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.cardboardpowered.impl.CardboardBossBar;
import org.cardboardpowered.impl.CraftProfileBanList;
import org.cardboardpowered.impl.CraftServerLinks;
import org.cardboardpowered.impl.IpBanList;
import org.cardboardpowered.impl.MetadataStoreImpl;
import org.cardboardpowered.impl.command.BukkitCommandWrapper;
import org.cardboardpowered.impl.command.CardboardConsoleCommandSender;
import org.cardboardpowered.impl.command.CommandMapImpl;
import org.cardboardpowered.impl.command.MinecraftCommandWrapper;
import org.cardboardpowered.impl.command.VersionCommand;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.inventory.CardboardInventoryView;
import org.cardboardpowered.impl.inventory.InventoryCreator;
import org.cardboardpowered.impl.inventory.recipe.CardboardBlastingRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardCampfireRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardFurnaceRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardShapedRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardShapelessRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardSmithingRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardSmokingRecipe;
import org.cardboardpowered.impl.inventory.recipe.CardboardStonecuttingRecipe;
import org.cardboardpowered.impl.inventory.recipe.RecipeInterface;
import org.cardboardpowered.impl.inventory.recipe.RecipeIterator;
import org.cardboardpowered.impl.map.MapViewImpl;
import org.cardboardpowered.impl.tag.BlockTagImpl;
import org.cardboardpowered.impl.tag.CraftGameEventTag;
import org.cardboardpowered.impl.tag.EntityTagImpl;
import org.cardboardpowered.impl.tag.FluidTagImpl;
import org.cardboardpowered.impl.tag.ItemTagImpl;
import org.cardboardpowered.impl.util.CommandPermissions;
import org.cardboardpowered.impl.util.IconCacheImpl;
import org.cardboardpowered.impl.util.SimpleHelpMap;
import org.cardboardpowered.impl.world.ChunkDataImpl;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinAdvancement;
import org.cardboardpowered.interfaces.IMixinEntity;
import org.cardboardpowered.interfaces.IMixinMapState;
import org.cardboardpowered.interfaces.IMixinMinecraftServer;
import org.cardboardpowered.interfaces.IMixinRecipe;
import org.cardboardpowered.interfaces.IMixinRecipeManager;
import org.cardboardpowered.interfaces.IMixinServerEntityPlayer;
import org.cardboardpowered.interfaces.IMixinWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class CraftServer
implements Server {
    public final String serverName = "Cardboard";
    public final String bukkitVersion = "1.21.10-R0.1-SNAPSHOT";
    public final String serverVersion;
    public final String shortVersion;
    private final Logger logger = BukkitLogger.getLogger();
    private final CommandMapImpl commandMap;
    private final SimplePluginManager pluginManager;
    public Set<String> activeCompatibilities = Collections.emptySet();
    private final CraftMagicNumbers unsafe = (CraftMagicNumbers)CraftMagicNumbers.INSTANCE;
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final ConsoleCommandSender consoleCommandSender = new CardboardConsoleCommandSender();
    private final Map<UUID, OfflinePlayer> offlinePlayers = new MapMaker().weakValues().makeMap();
    public List<CraftPlayer> playerView;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public final Map<String, World> worlds = new LinkedHashMap<String, World>();
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final YamlConfiguration configuration;
    private IconCacheImpl icon;
    public static class_3176 server;
    public static class_3176 console;
    protected final class_3174 playerList;
    public static CraftServer INSTANCE;
    public CardboardScoreboardManager scoreboardManager;
    private final MetadataStoreBase<Entity> entityMetadata = MetadataStoreImpl.newEntityMetadataStore();
    private final MetadataStoreBase<OfflinePlayer> playerMetadata = MetadataStoreImpl.newPlayerMetadataStore();
    private final MetadataStoreBase<World> worldMetadata = MetadataStoreImpl.newWorldMetadataStore();
    private final Map<Class<?>, Registry<?>> registries = new HashMap();
    public CraftDataPackManager dataPackManager;
    private CraftServerTickManager serverTickManager;
    private CraftServerLinks serverLinks;
    private final ServerConfiguration serverConfig = new PaperServerConfiguration();
    private final PaperFilledProfileCache paperProfileCache;
    public class_2170 vanillaCommandManager;
    private final Server.Spigot spigot = new Server.Spigot(){

        public YamlConfiguration getConfig() {
            return SpigotConfig.config;
        }

        public void restart() {
        }

        public void broadcast(BaseComponent component) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(component);
            }
        }

        public void broadcast(BaseComponent ... components) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(components);
            }
        }
    };
    public boolean playerCommandState;

    public PaperFilledProfileCache getPaperFilledProfileCache() {
        return this.paperProfileCache;
    }

    public CraftServer(class_3176 nms) {
        INSTANCE = this;
        String hash = VersionCommand.getGitHash().substring(0, 7);
        this.serverVersion = "git-Cardboard-" + hash;
        this.shortVersion = "git-" + hash;
        server = nms;
        console = nms;
        this.commandMap = new CommandMapImpl(this);
        this.pluginManager = new SimplePluginManager((Server)this, (SimpleCommandMap)this.commandMap);
        this.paperProfileCache = new PaperFilledProfileCache();
        this.scoreboardManager = new CardboardScoreboardManager((MinecraftServer)nms, (class_269)server.method_3845());
        this.configuration = YamlConfiguration.loadConfiguration(new File("bukkit.yml"));
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        this.saveConfig();
        this.playerView = Collections.unmodifiableList(Lists.transform((List)CraftServer.server.field_4550.field_14351, (Function)new Function<class_3222, CraftPlayer>(this){

            public CraftPlayer apply(class_3222 player) {
                return player.getBukkit();
            }
        }));
        this.dataPackManager = new CraftDataPackManager(this.getServer().method_3836());
        this.serverTickManager = new CraftServerTickManager(console.method_54833());
        this.serverLinks = new CraftServerLinks(console);
        this.loadIcon();
        this.loadCompatibilities();
        ((CraftMagicNumbers)CraftMagicNumbers.INSTANCE).getCommodore().updateReroute(this.activeCompatibilities::contains);
        this.playerList = server.method_13949();
        RegistryUtil.inject_into_bukkit_registry(nms);
    }

    private void loadCompatibilities() {
    }

    public ServerLinks getServerLinks() {
        return this.serverLinks;
    }

    public void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + String.valueOf(this.getConfigFile()), ex);
        }
    }

    public File getConfigFile() {
        return new File("bukkit.yml");
    }

    private void loadIcon() {
        this.icon = new IconCacheImpl(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    public IconCacheImpl loadServerIcon(File file) throws Exception {
        Validate.notNull(file, "File cannot be null");
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(file) + " is not a file");
        }
        return CraftServer.loadServerIcon0(file);
    }

    static IconCacheImpl loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    public IconCacheImpl loadServerIcon(BufferedImage image) throws Exception {
        Validate.notNull(image, "Image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static IconCacheImpl loadServerIcon0(BufferedImage image) throws Exception {
        Validate.isTrue(image.getWidth() == 64, "Error: not 64*64");
        Validate.isTrue(image.getHeight() == 64, "Error: not 64*64");
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytebuf);
        return new IconCacheImpl(bytebuf.toByteArray());
    }

    public void addWorldToMap(CraftWorld world) {
        this.worlds.put(world.getName(), world);
    }

    public void loadPlugins() {
        RemapUtils.init();
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = new File("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex) {
                    Bukkit.getLogger().log(Level.SEVERE, ex.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands();
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CommandPermissions.registerCorePermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    private void setVanillaCommands() {
        class_2170 dispatcher = this.vanillaCommandManager = server.method_3734();
        for (CommandNode cmd : dispatcher.method_9235().getRoot().getChildren()) {
            if (cmd.getCommand() != null && cmd.getCommand() instanceof BukkitCommandWrapper) continue;
            this.commandMap.register("minecraft", (Command)new MinecraftCommandWrapper(dispatcher, cmd));
        }
    }

    private void syncCommands() {
        class_2170 dispatcher = server.setCommandManager(new class_2170(class_2170.class_5364.field_25419, class_7157.method_46722((class_7225.class_7874)console.method_30611(), (class_7699)class_7699.method_45397())));
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof MinecraftCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((MinecraftCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.method_9235().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(entry.getValue()).register((CommandDispatcher<class_2168>)dispatcher.method_9235(), label);
        }
        for (class_3222 player : this.getHandle().method_3760().method_14571()) {
            dispatcher.method_9241(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm, false);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
            this.pluginManager.dirtyPermissibles();
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    public class_3176 getServer() {
        return server;
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public String toString() {
        return "CraftServer{serverName=Cardboard,serverVersion=" + this.serverVersion + ",minecraftVersion=" + class_155.method_16673().comp_4025() + "}";
    }

    public boolean addRecipe(Recipe recipe) {
        RecipeInterface toAdd;
        if (recipe instanceof RecipeInterface) {
            toAdd = (RecipeInterface)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CardboardShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CardboardShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CardboardFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CardboardBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CardboardCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CardboardSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CardboardStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingRecipe) {
            toAdd = CardboardSmithingRecipe.fromBukkitRecipe((SmithingRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    public Iterator<Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(server.method_3851().method_12893().iterator(), (Function)new Function<class_8779, Advancement>(this){

            public Advancement apply(class_8779 advancement) {
                return ((IMixinAdvancement)advancement).getBukkitAdvancement();
            }
        }));
    }

    public void banIP(String ip) {
        this.getServer().method_13949().method_14585().method_73999(new class_3320(ip));
    }

    public int broadcast(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent event = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return 0;
        }
        message = event.getMessage();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    public void clearRecipes() {
        ((IMixinRecipeManager)this.getServer().method_3772()).clearRecipes();
    }

    public BlockData createBlockData(Material material) {
        Validate.isTrue(material != null, "Must provide material");
        return this.createBlockData(material, (String)null);
    }

    public BlockData createBlockData(String data) throws IllegalArgumentException {
        return this.createBlockData(null, data);
    }

    public BlockData createBlockData(Material material, Consumer<? super BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept((BlockData)data);
        }
        return data;
    }

    public BlockData createBlockData(Material material, String data) throws IllegalArgumentException {
        Validate.isTrue(material != null || data != null, "Must provide one of material or data");
        return CraftBlockData.newData(material, data);
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CardboardBossBar(title, color, style, flags);
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        class_3002 bossBattleCustom = this.getServer().method_3837().method_12970(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CardboardBossBar craftKeyedBossbar = new CardboardBossBar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().method_3837().method_12969().iterator(), (Function)new Function<class_3002, KeyedBossBar>(this){

            public KeyedBossBar apply(class_3002 bossBattleCustom) {
                return (KeyedBossBar)((IMixinEntity)bossBattleCustom).getBukkitEntity();
            }
        }));
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        class_3002 bossBattleCustom = this.getServer().method_3837().method_12971(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : (KeyedBossBar)((IMixinEntity)bossBattleCustom).getBukkitEntity();
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        class_3004 bossBattleCustomData = this.getServer().method_3837();
        class_3002 bossBattleCustom = bossBattleCustomData.method_12971(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.method_12973(bossBattleCustom);
            return true;
        }
        return false;
    }

    public ChunkGenerator.ChunkData createChunkData(World arg0) {
        return new ChunkDataImpl(arg0);
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Validate.notNull(world, "World cannot be null");
        Validate.notNull(structureType, "StructureType cannot be null");
        Validate.notNull(structureType.getMapIcon(), "Cannot create explorer maps for StructureType " + structureType.getName());
        class_3218 worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        class_2338 structurePosition = new class_2338(structureLocation.getBlockX(), structureLocation.getBlockY(), structureLocation.getBlockZ());
        class_1799 stack = class_1806.method_8005((class_3218)worldServer, (int)structurePosition.method_10263(), (int)structurePosition.method_10260(), (byte)MapView.Scale.NORMAL.getValue(), (boolean)true, (boolean)true);
        class_1806.method_8002((class_3218)worldServer, (class_1799)stack);
        class_1806.method_8001((class_1799)stack, (class_1937)worldServer);
        return CraftItemStack.asBukkitCopy(stack);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return InventoryCreator.INSTANCE.createInventory(holder, type);
    }

    public Inventory createInventory(InventoryHolder arg0, int arg1) throws IllegalArgumentException {
        return InventoryCreator.INSTANCE.createInventory(arg0, arg1);
    }

    public Inventory createInventory(InventoryHolder arg0, InventoryType arg1, String arg2) {
        return InventoryCreator.INSTANCE.createInventory(arg0, arg1, arg2);
    }

    public Inventory createInventory(InventoryHolder arg0, int arg1, String arg2) throws IllegalArgumentException {
        return InventoryCreator.INSTANCE.createInventory(arg0, arg1, arg2);
    }

    public MapView createMap(World world) {
        Validate.notNull(world, "World cannot be null");
        class_1799 stack = new class_1799((class_1935)class_1802.field_8895, 1);
        class_22 worldmap = class_1806.method_8001((class_1799)stack, (class_1937)((CraftWorld)world).getHandle());
        return ((IMixinMapState)worldmap).getMapViewBF();
    }

    public Merchant createMerchant(String arg0) {
        return null;
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name((String)name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    public World createWorld(WorldCreator creator) {
        System.out.println("Bukkit#createWorld 0");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        if (world != null) {
            return world;
        }
        return null;
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) throws CommandException {
        block7: {
            if (sender instanceof Entity) {
                class_3218 world = (class_3218)((CraftEntity)sender).nms.method_73183();
                class_2168 source = ((CraftEntity)sender).nms.method_5671(world);
                try {
                    String theCommand = commandLine.startsWith("minecraft:") ? commandLine.substring("minecraft:".length()) : commandLine;
                    int result = this.vanillaCommandManager.field_9832.execute(theCommand, (Object)source);
                    return result != -1;
                }
                catch (CommandSyntaxException e) {
                    if (e.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand()) break block7;
                    source.method_9213(class_2564.method_10883((Message)e.getRawMessage()));
                    if (e.getInput() != null && e.getCursor() >= 0) {
                        int i = Math.min(e.getInput().length(), e.getCursor());
                        class_5250 mutableText = class_2561.method_43473().method_27692(class_124.field_1080);
                        if (i > 10) {
                            mutableText.method_10852(class_5244.field_39678);
                        }
                        mutableText.method_27693(e.getInput().substring(Math.max(0, i - 10), i));
                        if (i < e.getInput().length()) {
                            class_5250 text = class_2561.method_43470((String)e.getInput().substring(i)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073});
                            mutableText.method_10852((class_2561)text);
                        }
                        mutableText.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                        source.method_9213((class_2561)mutableText);
                    }
                    return false;
                }
            }
        }
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        sender.sendMessage("Unknown command. Type \"/help\" for help.");
        return false;
    }

    public Advancement getAdvancement(NamespacedKey arg0) {
        class_8779 advancement = server.method_3851().method_12896(CraftNamespacedKey.toMinecraft(arg0));
        return advancement == null ? null : ((IMixinAdvancement)advancement).getBukkitAdvancement();
    }

    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    public boolean getAllowFlight() {
        return this.getServer().method_3718();
    }

    public boolean getAllowNether() {
        return true;
    }

    private class_3806 getProperties() {
        return console.method_16705();
    }

    public int getAmbientSpawnLimit() {
        return 0;
    }

    public int getAnimalSpawnLimit() {
        return 0;
    }

    public BanList getBanList(BanList.Type type) {
        switch (type) {
            case IP: {
                return new IpBanList(CraftServer.server.field_4550.method_14585());
            }
        }
        return new CraftProfileBanList(CraftServer.server.field_4550.method_14563());
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet set = Sets.newHashSet();
        for (String s : this.getServer().method_13949().method_14563().method_14636()) {
            set.add(this.getOfflinePlayer(s));
        }
        return null;
    }

    public String getBukkitVersion() {
        return "1.21.10-R0.1-SNAPSHOT";
    }

    public Map<String, String[]> getCommandAliases() {
        return new HashMap<String, String[]>();
    }

    public long getConnectionThrottle() {
        return this.configuration.getInt("settings.connection-throttle");
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.consoleCommandSender;
    }

    public GameMode getDefaultGameMode() {
        return GameMode.getByValue((int)this.getServer().method_3790().method_8379());
    }

    public Entity getEntity(UUID uuid) {
        for (class_3218 world : this.getServer().method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    public boolean getGenerateStructures() {
        return this.getServer().method_27728().method_28057().method_28029();
    }

    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public Set<String> getIPBans() {
        HashSet set = Sets.newHashSet();
        for (String name : this.getServer().method_13949().method_14585().method_14636()) {
            set.add(name);
        }
        return set;
    }

    public int getIdleTimeout() {
        return this.getServer().field_4596;
    }

    public String getIp() {
        return this.getServer().field_4585;
    }

    public ItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LootTable getLootTable(NamespacedKey arg0) {
        return null;
    }

    public MapViewImpl getMap(int arg0) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        me.isaiah.common.cmixin.IMixinWorld ic = (me.isaiah.common.cmixin.IMixinWorld)overworld;
        class_22 worldmap = ic.IC$get_map_state(arg0);
        if (worldmap == null) {
            return null;
        }
        return ((IMixinMapState)worldmap).getMapViewBF();
    }

    public int getMaxPlayers() {
        return this.getServer().method_3802();
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public int getMonsterSpawnLimit() {
        return 0;
    }

    public String getMotd() {
        return this.getServer().method_3818();
    }

    public String getName() {
        return "Cardboard";
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Player result = this.getPlayerExact(name);
        if (result == null) {
            class_11560 profile = null;
            if (this.getOnlineMode() || SpigotConfig.bungee) {
                profile = console.method_73550().comp_4407().method_14515(name).orElse(null);
            }
            result = profile == null ? this.getOfflinePlayer(class_11560.method_72371((String)name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    public OfflinePlayer getOfflinePlayer(class_11560 nameAndId) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, nameAndId);
        this.offlinePlayers.put(nameAndId.comp_4422(), player);
        return player;
    }

    public OfflinePlayer getOfflinePlayer(UUID id) {
        Object result = this.getPlayer(id);
        if (result == null) {
            result = this.offlinePlayers.get(id);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new class_11560(id, ""));
                this.offlinePlayers.put(id, (OfflinePlayer)result);
            }
        } else {
            this.offlinePlayers.remove(id);
        }
        return result;
    }

    public OfflinePlayer[] getOfflinePlayers() {
        class_29 storage = server.getSaveHandler_BF();
        String[] files = storage.field_144.list(new FilenameFilter(this){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dat");
            }
        });
        HashSet<Object> players = new HashSet<Object>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    public boolean getOnlineMode() {
        return this.getServer().method_3828();
    }

    public Collection<? extends Player> getOnlinePlayers() {
        this.playerView = Collections.unmodifiableList(Lists.transform((List)CraftServer.server.field_4550.field_14351, (Function)new Function<class_3222, CraftPlayer>(this){

            public CraftPlayer apply(class_3222 player) {
                return player.getBukkit();
            }
        }));
        return this.playerView;
    }

    public Set<OfflinePlayer> getOperators() {
        HashSet list = Sets.newHashSet();
        for (String op : this.getServer().method_13949().method_14603().method_14636()) {
            list.add(this.getOfflinePlayer(op));
        }
        return list;
    }

    public Player getPlayer(String name) {
        return this.getPlayer(this.getServer().method_13949().method_14566(name));
    }

    public Player getPlayer(UUID uuid) {
        return this.getPlayer(this.getServer().method_13949().method_14602(uuid));
    }

    public Player getPlayer(class_3222 e) {
        if (null == e) {
            return null;
        }
        return (Player)((IMixinServerEntityPlayer)e).getBukkitEntity();
    }

    public Player getPlayerExact(String arg0) {
        return this.getPlayer(arg0);
    }

    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        return command instanceof PluginCommand ? (PluginCommand)command : null;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public int getPort() {
        return this.getServer().method_3756();
    }

    public List<Recipe> getRecipesFor(ItemStack result) {
        Validate.notNull(result, "Result cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    public CardboardScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public IconCacheImpl getServerIcon() {
        return this.icon;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public String getShutdownMessage() {
        return "Server Shutdown";
    }

    public int getSpawnRadius() {
        return this.getServer().method_3841();
    }

    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        class_2960 key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                class_6862 blockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)key);
                if (class_7923.field_41175.method_46733(blockTagKey).isPresent()) {
                    return new BlockTagImpl((class_2378<class_2248>)class_7923.field_41175, (class_6862<class_2248>)blockTagKey);
                }
                System.out.println("NULL BLOCKS! " + tag.toString());
                break;
            }
            case "items": {
                class_6862 itemTagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)key);
                if (!class_7923.field_41178.method_46733(itemTagKey).isPresent()) break;
                return new ItemTagImpl((class_2378<class_1792>)class_7923.field_41178, (class_6862<class_1792>)itemTagKey);
            }
            case "fluids": {
                class_6862 fluidTagKey = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)key);
                if (!class_7923.field_41173.method_46733(fluidTagKey).isPresent()) break;
                return new FluidTagImpl((class_2378<class_3611>)class_7923.field_41173, (class_6862<class_3611>)fluidTagKey);
            }
            case "entity_types": {
                class_6862 entityTagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)key);
                if (!class_7923.field_41177.method_46733(entityTagKey).isPresent()) break;
                return new EntityTagImpl((class_2378<class_1299<?>>)class_7923.field_41177, (class_6862<class_1299<?>>)entityTagKey);
            }
            case "game_events": {
                class_6862 gameEventTagKey = class_6862.method_40092((class_5321)class_7924.field_41273, (class_2960)key);
                if (!class_7923.field_41171.method_46733(gameEventTagKey).isPresent()) break;
                return new CraftGameEventTag((class_2378<class_5712>)class_7923.field_41171, (class_6862<class_5712>)gameEventTagKey);
            }
            default: {
                throw new IllegalArgumentException(registry);
            }
        }
        return null;
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        switch (registry) {
            case "blocks": {
                class_7922 blockTags = class_7923.field_41175;
                return (Iterable)blockTags.method_40272().map(pair -> new BlockTagImpl((class_2378<class_2248>)blockTags, (class_6862<class_2248>)pair.method_40251())).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                class_7922 itemTags = class_7923.field_41178;
                return (Iterable)itemTags.method_40272().map(pair -> new ItemTagImpl((class_2378<class_1792>)itemTags, (class_6862<class_1792>)pair.method_40251())).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                class_7922 fluidTags = class_7923.field_41173;
                return (Iterable)fluidTags.method_40272().map(pair -> new FluidTagImpl((class_2378<class_3611>)fluidTags, (class_6862<class_3611>)pair.method_40251())).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                class_7922 entityTags = class_7923.field_41177;
                return (Iterable)entityTags.method_40272().map(pair -> new EntityTagImpl((class_2378<class_1299<?>>)entityTags, (class_6862<class_1299<?>>)pair.method_40251())).collect(ImmutableList.toImmutableList());
            }
            case "game_events": {
                class_7922 gameEvents = class_7923.field_41171;
                return (Iterable)gameEvents.method_40272().map(pair -> new CraftGameEventTag((class_2378<class_5712>)gameEvents, (class_6862<class_5712>)pair.method_40251())).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    public int getTicksPerAnimalSpawns() {
        return this.configuration.getInt("ticks-per.animal-spawns");
    }

    public int getTicksPerMonsterSpawns() {
        return this.configuration.getInt("ticks-per.monster-spawns");
    }

    public UnsafeValues getUnsafe() {
        return this.unsafe;
    }

    public String getUpdateFolder() {
        return this.getUpdateFolderFile().getAbsolutePath();
    }

    public File getUpdateFolderFile() {
        return new File("update");
    }

    public String getVersion() {
        return this.getShortVersion();
    }

    public String getShortVersion() {
        return this.shortVersion + " (MC: " + server.method_3827() + ")";
    }

    public int getViewDistance() {
        return server != null ? (Integer)CraftServer.server.method_16705().field_16844.get() : 12;
    }

    public Warning.WarningState getWarningState() {
        return Warning.WarningState.DEFAULT;
    }

    public int getWaterAnimalSpawnLimit() {
        return 0;
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        HashSet set = Sets.newHashSet();
        for (String name : this.getServer().method_13949().method_14590().method_14636()) {
            set.add(this.getOfflinePlayer(name));
        }
        return set;
    }

    public World getWorld(String name) {
        return this.worlds.get(name.toLowerCase(Locale.ROOT));
    }

    public World getWorld(UUID uuid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uuid)) continue;
            return world;
        }
        return null;
    }

    public File getWorldContainer() {
        return this.getServer().getSessionBF().method_27424(class_1937.field_25179).getParent().toFile();
    }

    public String getWorldType() {
        return server instanceof class_3176 ? this.getServer().method_16705().field_16848.getProperty("level-type") : "NORMAL";
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public boolean hasWhitelist() {
        return this.getServer().method_3729();
    }

    public boolean isHardcore() {
        return this.getServer().method_3754();
    }

    public boolean isPrimaryThread() {
        boolean mainThread = server.method_18854();
        if (!mainThread) {
            return Thread.currentThread().getName().startsWith("dimthread");
        }
        return mainThread;
    }

    public List<Player> matchPlayer(String partialName) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player player : this.getOnlinePlayers()) {
            String iterPlayerName = player.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(player);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(player);
        }
        return matchedPlayers;
    }

    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    public void reload() {
        this.loadIcon();
        try {
            server.method_13949().method_14585().method_14630();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + ex.getMessage());
        }
        try {
            server.method_13949().method_14563().method_14630();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + ex.getMessage());
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.resetRecipes();
        this.reloadData();
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            String author = "<NoAuthorGiven>";
            if (plugin.getDescription().getAuthors().size() > 0) {
                author = (String)plugin.getDescription().getAuthors().get(0);
            }
            this.getLogger().log(Level.SEVERE, "Nag author: '" + author + "' of '" + plugin.getDescription().getName() + "' about the following: This plugin is not properly shutting down its async tasks when it is being reloaded. This may cause conflicts with the newly loaded version of the plugin");
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }

    public void reloadData() {
    }

    public void reloadWhitelist() {
        server.method_13949().method_14599();
    }

    public void resetRecipes() {
        this.reloadData();
    }

    public void savePlayers() {
        server.method_13949().method_14617();
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"Selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        class_2186 arg = class_2186.method_9306();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg.method_61178(reader).method_9816(MinecraftCommandWrapper.getCommandSource(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data in selector: " + selector));
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex);
        }
        return new ArrayList<Entity>(Lists.transform((List)nms, entity -> entity.getBukkitEntity()));
    }

    public void setDefaultGameMode(GameMode gm) {
        server.method_3838(class_1934.method_8384((int)gm.getValue()));
    }

    public void setIdleTimeout(int arg0) {
        server.method_3803(arg0);
    }

    public void setSpawnRadius(int arg0) {
    }

    public void setWhitelist(boolean arg0) {
        server.method_3731(arg0);
    }

    public void shutdown() {
        server.method_3747(false);
    }

    public void unbanIP(String arg0) {
        server.method_13949().method_14585().method_74000(arg0);
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        class_3218 handle = ((CraftWorld)world).getHandle();
        if (!((IMixinMinecraftServer)this.getServer()).getWorldMap().containsKey(handle.method_8410().method_27983())) {
            return false;
        }
        if (handle.method_8410().method_27983() == class_3218.field_25179 || handle.method_18456().size() > 0) {
            return false;
        }
        WorldUnloadEvent e = new WorldUnloadEvent(world);
        this.pluginManager.callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.method_14176(null, true, true);
            }
            handle.method_14178().close();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ENGLISH));
        ((IMixinMinecraftServer)this.getServer()).getWorldMap().remove(handle.method_8410().method_27983());
        return true;
    }

    public int getTicksPerAmbientSpawns() {
        return this.configuration.getInt("ticks-per.ambient-spawns");
    }

    public int getTicksPerWaterSpawns() {
        return this.configuration.getInt("ticks-per.water-spawns");
    }

    public boolean removeRecipe(NamespacedKey recipeKey) {
        return this.removeRecipe(recipeKey, false);
    }

    public boolean removeRecipe(NamespacedKey recipeKey, boolean resendRecipes) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        class_2960 mcKey = CraftNamespacedKey.toMinecraft(recipeKey);
        boolean removed = ((IMixinRecipeManager)this.getServer().method_3772()).removeRecipe(mcKey);
        if (removed && resendRecipes) {
            this.playerList_reloadRecipeData();
        }
        return removed;
    }

    public void playerList_reloadRecipeData() {
        class_1863 craftingmanager = server.method_3772();
        class_2788 packetplayoutrecipeupdate = new class_2788(craftingmanager.method_64692(), craftingmanager.method_64694());
        for (class_3222 entityplayer : CraftServer.server.method_13949().field_14351) {
            entityplayer.field_13987.method_14364((class_2596)packetplayoutrecipeupdate);
            entityplayer.method_14253().method_14904(entityplayer);
        }
    }

    public List<String> tabComplete(CommandSender sender, String message, class_3218 world, class_243 position, boolean forceCommand) {
        if (!(sender instanceof Player)) {
            return ImmutableList.of();
        }
        Player player = (Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, position) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)player, message, offers);
        this.getPluginManager().callEvent((Event)tabEvent);
        return tabEvent.isCancelled() ? Collections.emptyList() : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(Player player, String message, class_3218 world, class_243 pos) {
        List completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete((CommandSender)player, message) : this.getCommandMap().tabComplete((CommandSender)player, message, new Location((World)((IMixinWorld)world).getCraftWorld(), pos.field_1352, pos.field_1351, pos.field_1350));
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player player2 : this.getOnlinePlayers()) {
            if (!player.canSee(player2) || !StringUtil.startsWithIgnoreCase((String)player2.getName(), (String)token)) continue;
            completions.add(player2.getName());
        }
        this.pluginManager.callEvent((Event)event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object e = it.next();
            if (e instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    public MinecraftServer getHandle() {
        return this.getServer();
    }

    public CommandMapImpl getCommandMap() {
        return this.commandMap;
    }

    public List<String> getOperatorList() throws IOException {
        File f = new File("ops.json");
        ArrayList<String> toreturn = new ArrayList<String>();
        if (!f.exists()) {
            return toreturn;
        }
        List<String> content = null;
        content = Files.readAllLines(f.toPath());
        for (String s : content) {
            if (!(s = s.trim()).startsWith("\"uuid\":")) continue;
            s = s.substring(s.indexOf(":") + 1).replace('\"', ' ').trim();
            toreturn.add(s);
        }
        return toreturn;
    }

    public int getWaterAmbientSpawnLimit() {
        return 0;
    }

    public Server.Spigot spigot() {
        return this.spigot;
    }

    public int getTicksPerWaterAmbientSpawns() {
        return 0;
    }

    public Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        Optional opt = this.getServer().method_3772().method_8130(RecipeInterface.toMinecraft(recipeKey));
        return !opt.isPresent() ? null : ((IMixinRecipe)opt.get()).toBukkitRecipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, class_2976 serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)sender).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.field_13377);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.field_13377);
            return conversable2;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.field_13377 + "\"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    public MetadataStoreBase<Entity> getEntityMetadata() {
        return this.entityMetadata;
    }

    public MetadataStoreBase<OfflinePlayer> getPlayerMetadata() {
        return this.playerMetadata;
    }

    public MetadataStoreBase<World> getWorldMetadata() {
        return this.worldMetadata;
    }

    public long[] getTickTimes() {
        return new long[]{CraftServer.server.field_4572};
    }

    public double getAverageTickTime() {
        return CraftServer.server.field_4572;
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(UUID uuid) {
        return this.createProfile(uuid, null);
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(String name) {
        return this.createProfile(null, name);
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(UUID uuid, String name) {
        Player player = uuid != null ? Bukkit.getPlayer((UUID)uuid) : (name != null ? Bukkit.getPlayerExact((String)name) : null);
        return player != null ? new CraftPlayerProfile((CraftPlayer)player) : new CraftPlayerProfile(uuid, name);
    }

    @Deprecated(forRemoval=true)
    public ChunkGenerator.ChunkData createVanillaChunkData(World arg0, int arg1, int arg2) {
        return null;
    }

    public int getCurrentTick() {
        return server.method_3780();
    }

    public int getMaxWorldSize() {
        return 30000000;
    }

    public String getMinecraftVersion() {
        return server.method_3827();
    }

    public MobGoals getMobGoals() {
        return null;
    }

    public OfflinePlayer getOfflinePlayerIfCached(String arg0) {
        return null;
    }

    public String getPermissionMessage() {
        return "No Permission";
    }

    public UUID getPlayerUniqueId(String arg0) {
        return Bukkit.getPlayer((String)arg0).getUniqueId();
    }

    public double[] getTPS() {
        return new double[]{CraftServer.server.field_4572};
    }

    public boolean isStopping() {
        return !server.method_3806();
    }

    public boolean reloadCommandAliases() {
        return false;
    }

    public void reloadPermissions() {
    }

    public void setMaxPlayers(int arg0) {
    }

    public boolean suggestPlayerNamesWhenNullTabCompletions() {
        return false;
    }

    public @NonNull Iterable<? extends Audience> audiences() {
        return null;
    }

    public int broadcast(@NotNull Component arg0) {
        return 0;
    }

    public int broadcast(@NotNull Component arg0, @NotNull String arg1) {
        return 0;
    }

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder arg0, @NotNull InventoryType arg1, @NotNull Component arg2) {
        return null;
    }

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder arg0, int arg1, @NotNull Component arg2) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    public Merchant createMerchant(@Nullable Component arg0) {
        return null;
    }

    @NotNull
    public DatapackManager getDatapackManager() {
        return null;
    }

    @Nullable
    public World getWorld(@NotNull NamespacedKey key) {
        class_2960 id = CraftNamespacedKey.toMinecraft(key);
        for (class_3218 world : CraftServer.server.field_4589.values()) {
            class_2960 name = world.method_27983().method_29177();
            if (!name.equals((Object)id)) continue;
            return world.getCraftWorld();
        }
        return null;
    }

    @NotNull
    public Component motd() {
        return null;
    }

    @Nullable
    public Component shutdownMessage() {
        return null;
    }

    @NotNull
    public ItemStack craftItem(ItemStack[] craftingMatrix, World world, Player player) {
        return null;
    }

    @Nullable
    public Recipe getCraftingRecipe(ItemStack[] craftingMatrix, World world) {
        class_1703 container = new class_1703(this, null, -1){

            public CardboardInventoryView getBukkitView() {
                return null;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }

            public class_1799 transferSlot(class_1657 player, int index) {
                return null;
            }

            public class_1799 method_7601(class_1657 player, int slot) {
                return null;
            }
        };
        class_1715 inventoryCrafting = new class_1715(container, 3, 3);
        Optional<class_8786<class_3955>> opt = this.getNMSRecipe(craftingMatrix, inventoryCrafting, (CraftWorld)world);
        if (opt.isEmpty()) {
            return null;
        }
        return ((IMixinRecipe)opt.get()).toBukkitRecipe();
    }

    private Optional<class_8786<class_3955>> getNMSRecipe(ItemStack[] craftingMatrix, class_1715 inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i = 0; i < craftingMatrix.length; ++i) {
            inventoryCrafting.method_5447(i, CraftItemStack.asNMSCopy(craftingMatrix[i]));
        }
        return this.getServer().method_3772().method_8132(class_3956.field_17545, (class_9695)inventoryCrafting.method_59961(), (class_1937)world.getHandle());
    }

    @NotNull
    public File getPluginsFolder() {
        return new File("plugins");
    }

    public StructureManager getStructureManager() {
        return null;
    }

    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return 0;
    }

    public int getWaterUndergroundCreatureSpawnLimit() {
        return 0;
    }

    public boolean isWhitelistEnforced() {
        return server.method_3729();
    }

    public void setWhitelistEnforced(boolean bl) {
        server.method_3731(bl);
    }

    @NotNull
    public CommandSender createCommandSender(@NotNull Consumer<? super Component> arg0) {
        return null;
    }

    @NotNull
    public PlayerProfile createPlayerProfile(@NotNull UUID arg0) {
        return null;
    }

    @NotNull
    public PlayerProfile createPlayerProfile(@NotNull String arg0) {
        return null;
    }

    @NotNull
    public PlayerProfile createPlayerProfile(@Nullable UUID arg0, @Nullable String arg1) {
        return null;
    }

    public @NotNull com.destroystokyo.paper.profile.PlayerProfile createProfileExact(@Nullable UUID arg0, @Nullable String arg1) {
        return null;
    }

    @NotNull
    public WorldBorder createWorldBorder() {
        return null;
    }

    public boolean getHideOnlinePlayers() {
        return false;
    }

    @NotNull
    public PotionBrewer getPotionBrewer() {
        return null;
    }

    @NotNull
    public String getResourcePack() {
        return null;
    }

    @NotNull
    public String getResourcePackHash() {
        return null;
    }

    @NotNull
    public String getResourcePackPrompt() {
        return null;
    }

    public int getSimulationDistance() {
        return 8;
    }

    public int getSpawnLimit(@NotNull SpawnCategory arg0) {
        return 0;
    }

    public int getTicksPerSpawns(@NotNull SpawnCategory arg0) {
        return 0;
    }

    public boolean isResourcePackRequired() {
        return this.getServer().method_32303();
    }

    public int getMaxChainedNeighborUpdates() {
        return this.getServer().method_41239();
    }

    public <T extends Keyed> @Nullable Registry<T> getRegistry(@NotNull Class<T> aClass) {
        return RegistryAccess.registryAccess().getRegistry(aClass);
    }

    @NotNull
    public Criteria getScoreboardCriteria(@NotNull String arg0) {
        return CraftCriteria.getFromBukkit(arg0);
    }

    public boolean isEnforcingSecureProfiles() {
        return this.getServer().method_43500();
    }

    public boolean isTickingWorlds() {
        return true;
    }

    @NotNull
    public Component permissionMessage() {
        return Component.text((String)"todo: permissionMessage");
    }

    public boolean shouldSendChatPreviews() {
        return false;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public CraftDataPackManager getDataPackManager() {
        return this.dataPackManager;
    }

    @NotNull
    public List<String> getInitialDisabledPacks() {
        return null;
    }

    @NotNull
    public List<String> getInitialEnabledPacks() {
        return null;
    }

    public void setMotd(String motd) {
        console.method_3834(motd);
    }

    public void updateResources() {
        CraftServer.console.field_4550.method_14572();
    }

    public void updateRecipes() {
    }

    public final boolean isOwnedByCurrentRegion(World world, Position position) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(World world, Position position, int squareRadiusChunks) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(Location location) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(Location location, int squareRadiusChunks) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        return true;
    }

    public final boolean isOwnedByCurrentRegion(Entity entity) {
        return true;
    }

    public boolean addRecipe(Recipe recipe, boolean resendRecipes) {
        return this.addRecipe(recipe);
    }

    @Nullable
    public ItemStack createExplorerMap(@NotNull World world, @NotNull Location location, @NotNull org.bukkit.generator.structure.StructureType structureType, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull MapCursor.Type mapIcon, int radius, boolean findUnexplored) {
        return null;
    }

    public void banIP(@NotNull InetAddress address) {
        ((IpBanList)this.getBanList(BanList.Type.IP)).addBan((Object)address, null, (Date)null, null);
    }

    public void unbanIP(@NotNull InetAddress address) {
        ((IpBanList)this.getBanList(BanList.Type.IP)).pardon(address);
    }

    public void motd(@NotNull Component motd) {
    }

    @NotNull
    public RegionScheduler getRegionScheduler() {
        return null;
    }

    @NotNull
    public AsyncScheduler getAsyncScheduler() {
        return null;
    }

    @NotNull
    public GlobalRegionScheduler getGlobalRegionScheduler() {
        return null;
    }

    public ItemStack craftItem(ItemStack[] craftingMatrix, World world) {
        return this.craftItemResult(craftingMatrix, world).getResult();
    }

    public ItemCraftResult craftItemResult(ItemStack[] craftingMatrix, World world, Player player) {
        return null;
    }

    public ItemCraftResult craftItemResult(ItemStack[] craftingMatrix, World world) {
        return null;
    }

    public boolean isLoggingIPs() {
        return this.getServer().method_52344();
    }

    public ServerTickManager getServerTickManager() {
        return this.serverTickManager;
    }

    public ResourcePack getServerResourcePack() {
        return this.getServer().method_43659().map(CraftResourcePack::new).orElse(null);
    }

    @NotNull
    public <B extends BanList<E>, E> B getBanList(BanListType<B> type) {
        if (type == BanListType.IP) {
            return (B)new IpBanList(this.playerList.method_14585());
        }
        if (type == BanListType.PROFILE) {
            return (B)new CraftProfileBanList(this.playerList.method_14563());
        }
        throw new IllegalArgumentException("Unknown BanListType: " + String.valueOf(type));
    }

    public boolean isAcceptingTransfers() {
        return this.getServer().method_56040();
    }

    @NotNull
    public EntityFactory getEntityFactory() {
        return CraftEntityFactory.instance();
    }

    public World getWorld(Key worldKey) {
        class_3218 worldServer = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)CardboardAdventure.asVanilla(worldKey)));
        if (worldServer == null) {
            return null;
        }
        return worldServer.getWorld();
    }

    public boolean isPaused() {
        return console.method_54809();
    }

    public void allowPausing(Plugin plugin, boolean value) {
    }

    public int getPauseWhenEmptyTime() {
        return (Integer)this.getProperties().field_52352.get();
    }

    public void setPauseWhenEmptyTime(int seconds) {
    }

    public boolean isOwnedByCurrentRegion(@NotNull World world, int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ) {
        return true;
    }

    public boolean isGlobalTickThread() {
        return true;
    }

    @NotNull
    public Merchant createMerchant() {
        return null;
    }

    public void restart() {
    }

    @NotNull
    public ServerConfiguration getServerConfig() {
        return this.serverConfig;
    }

    public boolean forcesDefaultGameMode() {
        return (Boolean)CraftServer.console.method_16705().field_16827.get();
    }

    @NotNull
    public World getRespawnWorld() {
        return console.method_74944().getWorld();
    }

    public void setRespawnWorld(@NotNull World world) {
        console.method_74946();
    }
}

