/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import net.minecraft.class_1320;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftAttribute
implements Attribute,
Handleable<class_1320> {
    private static int count = 0;
    private final NamespacedKey key;
    private final class_1320 attributeBase;
    private final String name;
    private final int ordinal;

    public static Attribute minecraftToBukkit(class_1320 minecraft) {
        return (Attribute)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41251);
    }

    public static Attribute minecraftHolderToBukkit(class_6880<class_1320> minecraft) {
        return CraftAttribute.minecraftToBukkit((class_1320)minecraft.comp_349());
    }

    public static Attribute stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertAttributeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        if (key == null) {
            return null;
        }
        return (Attribute)CraftRegistry.get(RegistryKey.ATTRIBUTE, key, ApiVersion.CURRENT);
    }

    public static class_1320 bukkitToMinecraft(Attribute bukkit) {
        return (class_1320)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_1320> bukkitToMinecraftHolder(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41251);
        class_6880 class_68802 = registry.method_47983((Object)CraftAttribute.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public CraftAttribute(NamespacedKey key, class_1320 attributeBase) {
        this.key = key;
        this.attributeBase = attributeBase;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public class_1320 getHandle() {
        return this.attributeBase;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getTranslationKey() {
        return this.attributeBase.method_26830();
    }

    @NotNull
    public String translationKey() {
        return this.attributeBase.method_26830();
    }

    public int compareTo(@NotNull Attribute attribute) {
        return this.ordinal - attribute.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftAttribute)) {
            return false;
        }
        CraftAttribute otherAttribute = (CraftAttribute)other;
        return this.getKey().equals((Object)otherAttribute.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @NotNull
    public Attribute.Sentiment getSentiment() {
        return Attribute.Sentiment.valueOf((String)this.getHandle().field_51884.name());
    }
}

