/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.util.OldEnumHolderable;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jspecify.annotations.Nullable;

public class CraftBiome
extends OldEnumHolderable<Biome, class_1959>
implements Biome {
    private static int count = 0;

    public static Biome minecraftToBukkit(class_1959 minecraft) {
        return (Biome)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41236);
    }

    public static Biome minecraftHolderToBukkit(class_6880<class_1959> minecraft) {
        return (Biome)CraftRegistry.minecraftHolderToBukkit(minecraft, class_7924.field_41236);
    }

    public static @Nullable class_1959 bukkitToMinecraft(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return (class_1959)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static @Nullable class_6880<class_1959> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public CraftBiome(class_6880<class_1959> holder) {
        super(holder, count++);
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public static class LegacyCustomBiomeImpl
    implements Biome {
        private static final NamespacedKey LEGACY_CUSTOM_KEY = new NamespacedKey("minecraft", "custom");
        private final int ordinal = count++;

        public NamespacedKey getKey() {
            return LEGACY_CUSTOM_KEY;
        }

        public int compareTo(Biome other) {
            return this.ordinal - other.ordinal();
        }

        public String name() {
            return "CUSTOM";
        }

        public int ordinal() {
            return this.ordinal;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LegacyCustomBiomeImpl that = (LegacyCustomBiomeImpl)object;
            return this.ordinal == that.ordinal;
        }

        public int hashCode() {
            return Objects.hashCode(this.ordinal);
        }

        public String toString() {
            return "CUSTOM";
        }
    }
}

