/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_10914;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9329;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.util.CraftLegacy;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.cardboardpowered.impl.CardboardEnchantment;
import org.cardboardpowered.interfaces.IItemStack;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    private static final VarHandle API_ITEM_STACK_CRAFT_DELEGATE_FIELD;
    public class_1799 handle;

    private static CraftItemStack getCraftStack(ItemStack bukkit) {
        if (bukkit instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)bukkit;
            return craftItemStack;
        }
        return API_ITEM_STACK_CRAFT_DELEGATE_FIELD.get(bukkit);
    }

    public int hashCode() {
        if (this.handle == null || this.handle.method_7960()) {
            return class_1799.field_8037.hashCode();
        }
        int hash = class_1799.method_57355((class_1799)this.handle);
        hash = hash * 31 + this.handle.method_7947();
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        ItemStack bukkit = (ItemStack)obj;
        CraftItemStack craftStack = CraftItemStack.getCraftStack(bukkit);
        if (this.handle == craftStack.handle) {
            return true;
        }
        if (this.handle == null || craftStack.handle == null) {
            return false;
        }
        if (this.handle.method_7960() && craftStack.handle.method_7960()) {
            return true;
        }
        return class_1799.method_7973((class_1799)this.handle, (class_1799)craftStack.handle);
    }

    public static class_1799 getOrCloneOnMutation(ItemStack old, ItemStack newInstance) {
        return old == newInstance ? CraftItemStack.unwrap(old) : CraftItemStack.asNMSCopy(newInstance);
    }

    public boolean isEmpty() {
        return this.handle == null || this.handle.method_7960();
    }

    public static class_1799 asNMSCopy(ItemStack original) {
        if (original == null || original.isEmpty()) {
            return class_1799.field_8037;
        }
        CraftItemStack stack = CraftItemStack.getCraftStack(original);
        return stack.handle == null ? class_1799.field_8037 : stack.handle.method_7972();
    }

    public static List<class_1799> asNMSCopy(List<? extends ItemStack> originals) {
        ArrayList<class_1799> items = new ArrayList<class_1799>(originals.size());
        for (ItemStack itemStack : originals) {
            items.add(CraftItemStack.asNMSCopy(itemStack));
        }
        return items;
    }

    public static class_1799 copyNMSStack(class_1799 original, int amount) {
        class_1799 stack = original.method_7972();
        stack.method_7939(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(class_1799 original) {
        CraftItemStack stack = CraftItemStack.asCraftMirror(original.method_7972());
        return stack;
    }

    public static CraftItemStack asCraftMirror(class_1799 original) {
        return new CraftItemStack(original == null || original.method_7960() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.method_7972());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(class_1792 item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(class_1792 item, int amount) {
        return new CraftItemStack(CraftMagicNumbers.getMaterial(item), amount, 0, null);
    }

    private CraftItemStack(class_1799 item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.method_7909()) : super.getData();
    }

    public Material getType() {
        return this.handle != null ? CraftMagicNumbers.getMaterial(this.handle.method_7909()) : Material.AIR;
    }

    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftMagicNumbers.getItem(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new class_1799((class_1935)CraftMagicNumbers.getItem(type), 1);
        } else {
            this.handle.field_8038 = CraftMagicNumbers.getItem(type);
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.method_7947() : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.method_7939(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.method_7974((int)durability);
        }
    }

    public short getDurability() {
        return this.handle != null ? (short)this.handle.method_7919() : (short)-1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.method_7909().method_7882();
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Validate.notNull(ench, "Cannot add null enchantment");
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addEnchant(ench, level, true);
        this.setItemMeta(itemMeta);
    }

    static boolean makeTag(class_1799 item) {
        return item != null;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    public int getEnchantmentLevel(Enchantment ench) {
        return this.handle == null ? 0 : class_1890.method_8225(CardboardEnchantment.bukkitToMinecraftHolder(ench), (class_1799)this.handle);
    }

    public int removeEnchantment(Enchantment ench) {
        Validate.notNull(ench, "Cannot remove null enchantment");
        int level = this.getEnchantmentLevel(ench);
        if (level > 0) {
            ItemMeta itemMeta = this.getItemMeta();
            if (itemMeta == null) {
                return 0;
            }
            itemMeta.removeEnchant(ench);
            this.setItemMeta(itemMeta);
        }
        return level;
    }

    public int removeEnchantment_old(Enchantment ench) {
        return this.removeEnchantment(ench);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(class_1799 item) {
        class_9304 list = item != null && item.method_7942() ? (class_9304)item.method_58694(class_9334.field_49633) : null;
        class_9304 itemEnchantmentsComponent = list;
        if (list == null || list.method_57541() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        list.method_57539().forEach(entry -> {
            class_6880 id = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = Enchantment.getByKey((NamespacedKey)CraftNamespacedKey.fromStringOrNull(id.method_55840()));
            if (enchant != null) {
                result.put((Object)enchant, (Object)level);
            }
        });
        return result.build();
    }

    static class_9304 getEnchantmentList(class_1799 item) {
        return item != null && item.method_7942() ? (class_9304)item.method_58694(class_9334.field_49633) : null;
    }

    public CraftItemStack clone() {
        return new CraftItemStack(this.handle != null ? this.handle.method_7972() : null);
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(class_1799 item) {
        return CraftItemStack.getItemMeta(item, CraftItemStack.getType(item));
    }

    public static ItemMeta getItemMeta(class_1799 item, Material material) {
        return CraftItemStack.getItemMeta(item, material, null);
    }

    public static ItemMeta getItemMeta(class_1799 item, Material material, Set<class_9331<?>> extraHandledDcts) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(material);
        }
        switch (material) {
            case WRITTEN_BOOK: {
                return new CraftMetaBookSigned(item.method_57380(), extraHandledDcts);
            }
            case WRITABLE_BOOK: {
                return new CraftMetaBook(item.method_57380(), extraHandledDcts);
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: 
            case PIGLIN_HEAD: 
            case PIGLIN_WALL_HEAD: 
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return new CraftMetaSkull(item.method_57380(), extraHandledDcts);
            }
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: 
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_HELMET: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_BOOTS: 
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: 
            case NETHERITE_HELMET: 
            case NETHERITE_CHESTPLATE: 
            case NETHERITE_LEGGINGS: 
            case NETHERITE_BOOTS: 
            case TURTLE_HELMET: {
                return new CraftMetaItem(item.method_57380(), extraHandledDcts);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return new CraftMetaLeatherArmor(item.method_57380(), extraHandledDcts);
            }
            case LEATHER_HORSE_ARMOR: {
                return new CraftMetaLeatherArmor(item.method_57380(), extraHandledDcts);
            }
            case POTION: 
            case SPLASH_POTION: 
            case LINGERING_POTION: 
            case TIPPED_ARROW: {
                return new CraftMetaPotion(item.method_57380(), extraHandledDcts);
            }
            case FILLED_MAP: {
                return new CraftMetaMap(item.method_57380(), extraHandledDcts);
            }
            case FIREWORK_ROCKET: {
                return new CraftMetaFirework(item.method_57380(), extraHandledDcts);
            }
            case FIREWORK_STAR: {
                return new CraftMetaCharge(item.method_57380(), extraHandledDcts);
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.method_57380(), extraHandledDcts);
            }
            case BLACK_BANNER: 
            case BLACK_WALL_BANNER: 
            case BLUE_BANNER: 
            case BLUE_WALL_BANNER: 
            case BROWN_BANNER: 
            case BROWN_WALL_BANNER: 
            case CYAN_BANNER: 
            case CYAN_WALL_BANNER: 
            case GRAY_BANNER: 
            case GRAY_WALL_BANNER: 
            case GREEN_BANNER: 
            case GREEN_WALL_BANNER: 
            case LIGHT_BLUE_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: 
            case LIGHT_GRAY_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: 
            case LIME_BANNER: 
            case LIME_WALL_BANNER: 
            case MAGENTA_BANNER: 
            case MAGENTA_WALL_BANNER: 
            case ORANGE_BANNER: 
            case ORANGE_WALL_BANNER: 
            case PINK_BANNER: 
            case PINK_WALL_BANNER: 
            case PURPLE_BANNER: 
            case PURPLE_WALL_BANNER: 
            case RED_BANNER: 
            case RED_WALL_BANNER: 
            case WHITE_BANNER: 
            case WHITE_WALL_BANNER: 
            case YELLOW_BANNER: 
            case YELLOW_WALL_BANNER: {
                return new CraftMetaBanner(item.method_57380(), extraHandledDcts);
            }
            case ALLAY_SPAWN_EGG: 
            case AXOLOTL_SPAWN_EGG: 
            case BAT_SPAWN_EGG: 
            case BEE_SPAWN_EGG: 
            case BLAZE_SPAWN_EGG: 
            case CAT_SPAWN_EGG: 
            case CAMEL_SPAWN_EGG: 
            case CAVE_SPIDER_SPAWN_EGG: 
            case CHICKEN_SPAWN_EGG: 
            case COD_SPAWN_EGG: 
            case COW_SPAWN_EGG: 
            case CREEPER_SPAWN_EGG: 
            case DOLPHIN_SPAWN_EGG: 
            case DONKEY_SPAWN_EGG: 
            case DROWNED_SPAWN_EGG: 
            case ELDER_GUARDIAN_SPAWN_EGG: 
            case ENDER_DRAGON_SPAWN_EGG: 
            case ENDERMAN_SPAWN_EGG: 
            case ENDERMITE_SPAWN_EGG: 
            case EVOKER_SPAWN_EGG: 
            case FOX_SPAWN_EGG: 
            case FROG_SPAWN_EGG: 
            case GHAST_SPAWN_EGG: 
            case GLOW_SQUID_SPAWN_EGG: 
            case GOAT_SPAWN_EGG: 
            case GUARDIAN_SPAWN_EGG: 
            case HOGLIN_SPAWN_EGG: 
            case HORSE_SPAWN_EGG: 
            case HUSK_SPAWN_EGG: 
            case IRON_GOLEM_SPAWN_EGG: 
            case LLAMA_SPAWN_EGG: 
            case MAGMA_CUBE_SPAWN_EGG: 
            case MOOSHROOM_SPAWN_EGG: 
            case MULE_SPAWN_EGG: 
            case OCELOT_SPAWN_EGG: 
            case PANDA_SPAWN_EGG: 
            case PARROT_SPAWN_EGG: 
            case PHANTOM_SPAWN_EGG: 
            case PIGLIN_BRUTE_SPAWN_EGG: 
            case PIGLIN_SPAWN_EGG: 
            case PIG_SPAWN_EGG: 
            case PILLAGER_SPAWN_EGG: 
            case POLAR_BEAR_SPAWN_EGG: 
            case PUFFERFISH_SPAWN_EGG: 
            case RABBIT_SPAWN_EGG: 
            case RAVAGER_SPAWN_EGG: 
            case SALMON_SPAWN_EGG: 
            case SHEEP_SPAWN_EGG: 
            case SHULKER_SPAWN_EGG: 
            case SILVERFISH_SPAWN_EGG: 
            case SKELETON_HORSE_SPAWN_EGG: 
            case SKELETON_SPAWN_EGG: 
            case SLIME_SPAWN_EGG: 
            case SNIFFER_SPAWN_EGG: 
            case SNOW_GOLEM_SPAWN_EGG: 
            case SPIDER_SPAWN_EGG: 
            case SQUID_SPAWN_EGG: 
            case STRAY_SPAWN_EGG: 
            case STRIDER_SPAWN_EGG: 
            case TADPOLE_SPAWN_EGG: 
            case TRADER_LLAMA_SPAWN_EGG: 
            case TROPICAL_FISH_SPAWN_EGG: 
            case TURTLE_SPAWN_EGG: 
            case VEX_SPAWN_EGG: 
            case VILLAGER_SPAWN_EGG: 
            case VINDICATOR_SPAWN_EGG: 
            case WANDERING_TRADER_SPAWN_EGG: 
            case WARDEN_SPAWN_EGG: 
            case WITCH_SPAWN_EGG: 
            case WITHER_SKELETON_SPAWN_EGG: 
            case WITHER_SPAWN_EGG: 
            case WOLF_SPAWN_EGG: 
            case ZOGLIN_SPAWN_EGG: 
            case ZOMBIE_HORSE_SPAWN_EGG: 
            case ZOMBIE_SPAWN_EGG: 
            case ZOMBIE_VILLAGER_SPAWN_EGG: 
            case ZOMBIFIED_PIGLIN_SPAWN_EGG: {
                return new CraftMetaSpawnEgg(item.method_57380(), extraHandledDcts);
            }
            case ARMOR_STAND: {
                return new CraftMetaArmorStand(item.method_57380(), extraHandledDcts);
            }
            case KNOWLEDGE_BOOK: {
                return new CraftMetaKnowledgeBook(item.method_57380(), extraHandledDcts);
            }
            case FURNACE: 
            case CHEST: 
            case TRAPPED_CHEST: 
            case JUKEBOX: 
            case DISPENSER: 
            case DROPPER: 
            case ACACIA_HANGING_SIGN: 
            case ACACIA_SIGN: 
            case ACACIA_WALL_HANGING_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BAMBOO_HANGING_SIGN: 
            case BAMBOO_SIGN: 
            case BAMBOO_WALL_HANGING_SIGN: 
            case BAMBOO_WALL_SIGN: 
            case BIRCH_HANGING_SIGN: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_HANGING_SIGN: 
            case BIRCH_WALL_SIGN: 
            case CHERRY_HANGING_SIGN: 
            case CHERRY_SIGN: 
            case CHERRY_WALL_HANGING_SIGN: 
            case CHERRY_WALL_SIGN: 
            case CRIMSON_HANGING_SIGN: 
            case CRIMSON_SIGN: 
            case CRIMSON_WALL_HANGING_SIGN: 
            case CRIMSON_WALL_SIGN: 
            case DARK_OAK_HANGING_SIGN: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_HANGING_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case JUNGLE_HANGING_SIGN: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_HANGING_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case MANGROVE_HANGING_SIGN: 
            case MANGROVE_SIGN: 
            case MANGROVE_WALL_HANGING_SIGN: 
            case MANGROVE_WALL_SIGN: 
            case OAK_HANGING_SIGN: 
            case OAK_SIGN: 
            case OAK_WALL_HANGING_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_HANGING_SIGN: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_HANGING_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case WARPED_HANGING_SIGN: 
            case WARPED_SIGN: 
            case WARPED_WALL_HANGING_SIGN: 
            case WARPED_WALL_SIGN: 
            case SPAWNER: 
            case BREWING_STAND: 
            case ENCHANTING_TABLE: 
            case COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: 
            case BEACON: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case COMPARATOR: 
            case SHIELD: 
            case STRUCTURE_BLOCK: 
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case ENDER_CHEST: 
            case BARREL: 
            case BELL: 
            case BLAST_FURNACE: 
            case CAMPFIRE: 
            case SOUL_CAMPFIRE: 
            case JIGSAW: 
            case LECTERN: 
            case SMOKER: 
            case BEEHIVE: 
            case BEE_NEST: 
            case SCULK_CATALYST: 
            case SCULK_SHRIEKER: 
            case SCULK_SENSOR: 
            case CHISELED_BOOKSHELF: 
            case DECORATED_POT: 
            case SUSPICIOUS_SAND: {
                return new CraftMetaBlockState(item.method_57380(), CraftItemType.minecraftToBukkit(item.method_7909()), extraHandledDcts);
            }
            case TROPICAL_FISH_BUCKET: {
                return new CraftMetaItem(item.method_57380(), extraHandledDcts);
            }
            case AXOLOTL_BUCKET: {
                return new CraftMetaItem(item.method_57380(), extraHandledDcts);
            }
            case CROSSBOW: {
                return new CraftMetaCrossbow(item.method_57380(), extraHandledDcts);
            }
            case SUSPICIOUS_STEW: {
                return new CraftMetaSuspiciousStew(item.method_57380(), extraHandledDcts);
            }
            case COD_BUCKET: 
            case PUFFERFISH_BUCKET: 
            case SALMON_BUCKET: 
            case TADPOLE_BUCKET: 
            case ITEM_FRAME: 
            case GLOW_ITEM_FRAME: 
            case PAINTING: {
                return new CraftMetaEntityTag(item.method_57380(), extraHandledDcts);
            }
        }
        return new CraftMetaItem(item.method_57380(), extraHandledDcts);
    }

    static Material getType(class_1799 item) {
        if (null != item) {
            boolean isModded;
            boolean bl = isModded = null == CraftMagicNumbers.getMaterial(item.method_7909());
            if (isModded) {
                class_2960 id = class_7923.field_41178.method_10221((Object)item.field_8038);
                String name = CraftMagicNumbers.standardize(id);
                Material material = Material.getMaterial((String)name);
                return material;
            }
        }
        return item == null ? Material.AIR : CraftMagicNumbers.getMaterial(item.method_7909());
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(final class_1799 item, ItemMeta itemMeta) {
        class_1792 newItem;
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            ((IItemStack)item).cardboard$restore_patch(class_9326.field_49588);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        class_1792 oldItem = item.method_7909();
        if (oldItem != (newItem = CraftItemType.bukkitToMinecraft(CraftItemFactory.instance().updateMaterial(itemMeta, CraftItemType.minecraftToBukkit(oldItem))))) {
            ((IItemStack)item).cb$setItem(newItem);
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

                @Override
                void skullCallback(class_9296 gameProfile) {
                    item.method_57379(class_9334.field_49617, (Object)gameProfile);
                }
            };
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            ((IItemStack)item).cardboard$restore_patch(tag.build());
        }
        if (item.method_7909() != null && item.method_7936() > 0) {
            item.method_7974(item.method_7919());
        }
        return true;
    }

    public static void applyMetaToItem(final class_1799 itemStack, ItemMeta itemMeta) {
        CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

            @Override
            void skullCallback(class_9296 profile) {
                itemStack.method_57379(class_9334.field_49617, (Object)profile);
            }
        };
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        itemStack.method_57366(tag.build());
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar((ItemStack)this);
        }
        CraftItemStack that = CraftItemStack.getCraftStack(stack);
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.method_57353().equals((Object)that.handle.method_57353()) : !that.hasItemMeta();
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(class_1799 item) {
        return item != null && !item.method_57380().method_57848();
    }

    public static class_1799 unwrap(ItemStack bukkit) {
        CraftItemStack craftItemStack = CraftItemStack.getCraftStack(bukkit);
        return craftItemStack.handle == null ? class_1799.field_8037 : craftItemStack.handle;
    }

    public static class_2073 asCriterionConditionItem(ItemStack original) {
        class_1799 nms = CraftItemStack.asNMSCopy(original);
        class_9329 predicate = class_9329.method_57865((class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)nms.method_57380()));
        return new class_2073(Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{nms.method_41409()})), class_2096.class_2100.field_9708, new class_10914(predicate, Collections.emptyMap()));
    }

    public <T> T getData(DataComponentType.Valued<T> type) {
        if (this.isEmpty()) {
            return null;
        }
        return (T)PaperDataComponentType.convertDataComponentValue(this.handle.method_57353(), (PaperDataComponentType.ValuedImpl)type);
    }

    public boolean hasData(DataComponentType type) {
        if (this.isEmpty()) {
            return false;
        }
        return this.handle.method_57826(PaperDataComponentType.bukkitToMinecraft(type));
    }

    public Set<DataComponentType> getDataTypes() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return PaperDataComponentType.minecraftToBukkit(this.handle.method_57353().method_57831());
    }

    public <T> void setData(DataComponentType.Valued<T> type, T value) {
        if (this.isEmpty()) {
            return;
        }
        this.setDataInternal((PaperDataComponentType.ValuedImpl)type, value);
    }

    public void setData(DataComponentType.NonValued type) {
        if (this.isEmpty()) {
            return;
        }
        this.setDataInternal((PaperDataComponentType.NonValuedImpl)type, null);
    }

    private <A, V> void setDataInternal(PaperDataComponentType<A, V> type, A value) {
        this.handle.method_57379(type.getHandle(), type.getAdapter().toVanilla(value));
    }

    public void unsetData(DataComponentType type) {
        if (this.isEmpty()) {
            return;
        }
        this.handle.method_57381(PaperDataComponentType.bukkitToMinecraft(type));
    }

    public void resetData(DataComponentType type) {
        if (this.isEmpty()) {
            return;
        }
        this.resetData((PaperDataComponentType)type);
    }

    private <M> void resetData(PaperDataComponentType<?, M> type) {
        class_9331 nms = PaperDataComponentType.bukkitToMinecraft(type);
        Object nmsValue = this.handle.method_7909().method_57347().method_58694(nms);
        this.handle.method_57379(nms, nmsValue);
    }

    public boolean isDataOverridden(DataComponentType type) {
        if (this.isEmpty()) {
            return false;
        }
        class_9331 nms = PaperDataComponentType.bukkitToMinecraft(type);
        return !Objects.equals(this.handle.method_58694(nms), this.handle.method_58658().method_58694(nms));
    }

    public boolean matchesWithoutData(ItemStack item, Set<DataComponentType> exclude, boolean ignoreCount) {
        CraftItemStack craftStack = CraftItemStack.getCraftStack(item);
        if (this.handle == craftStack.handle) {
            return true;
        }
        if (this.handle == null || craftStack.handle == null) {
            return false;
        }
        if (this.handle.method_7960() && craftStack.handle.method_7960()) {
            return true;
        }
        class_1799 left = this.handle;
        class_1799 right = craftStack.handle;
        if (!ignoreCount && left.method_7947() != right.method_7947()) {
            return false;
        }
        if (!left.method_31574(right.method_7909())) {
            return false;
        }
        if (exclude.isEmpty()) {
            return left.method_57380().equals((Object)right.method_57380());
        }
        HashSet skippingTypes = new HashSet(exclude.size());
        for (DataComponentType api : exclude) {
            skippingTypes.add(PaperDataComponentType.bukkitToMinecraft(api));
        }
        return left.method_57380().method_58757(skippingTypes::contains).equals((Object)right.method_57380().method_58757(skippingTypes::contains));
    }

    static {
        try {
            API_ITEM_STACK_CRAFT_DELEGATE_FIELD = MethodHandles.privateLookupIn(ItemStack.class, MethodHandles.lookup()).findVarHandle(ItemStack.class, "craftDelegate", ItemStack.class);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
    }
}

