/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.command;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;

public class VersionCommand
extends Command {
    public static String BRANCH = "ver/1.21.4";
    private final ReentrantLock versionLock = new ReentrantLock();
    private boolean hasVersion = false;
    private String versionMessage = null;
    private final Set<CommandSender> versionWaiters = new HashSet<CommandSender>();
    private boolean versionTaskStarted = false;
    private long lastCheck = 0L;

    public VersionCommand(String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/version [plugin name]";
        this.setPermission("bukkit.command.version");
        this.setAliases(Arrays.asList("ver", "about", "version"));
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            String ver = ((ModContainer)FabricLoader.getInstance().getModContainer("cardboard").get()).getMetadata().getVersion().getFriendlyString();
            if (ver.contains("version")) {
                ver = CraftServer.INSTANCE.getShortVersion();
            }
            String message = "This server is running " + String.valueOf(ChatColor.GOLD) + Bukkit.getName() + String.valueOf(ChatColor.RESET) + " version " + ver + String.valueOf(ChatColor.ITALIC) + " (Implementing API version " + Bukkit.getBukkitVersion() + ")";
            sender.sendMessage(message);
            this.sendVersion(sender);
        } else {
            StringBuilder name = new StringBuilder();
            for (String arg : args) {
                if (name.length() > 0) {
                    name.append(' ');
                }
                name.append(arg);
            }
            String pluginName = name.toString();
            Plugin exactPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (exactPlugin != null) {
                this.describeToSender(exactPlugin, sender);
                return true;
            }
            boolean found = false;
            pluginName = pluginName.toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.getName().toLowerCase(Locale.ENGLISH).contains(pluginName)) continue;
                this.describeToSender(plugin, sender);
                found = true;
            }
            if (!found) {
                sender.sendMessage("This server is not running any plugin by that name.");
                sender.sendMessage("Use /plugins to get a list of plugins.");
            }
        }
        return true;
    }

    private void describeToSender(Plugin plugin, CommandSender sender) {
        PluginDescriptionFile desc = plugin.getDescription();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + desc.getName() + String.valueOf(ChatColor.WHITE) + " version " + String.valueOf(ChatColor.GREEN) + desc.getVersion());
        if (desc.getDescription() != null) {
            sender.sendMessage(desc.getDescription());
        }
        if (desc.getWebsite() != null) {
            sender.sendMessage("Website: " + String.valueOf(ChatColor.GREEN) + desc.getWebsite());
        }
        if (!desc.getAuthors().isEmpty()) {
            sender.sendMessage((desc.getAuthors().size() == 1 ? "Author: " : "Authors: ") + this.getAuthors(desc));
        }
    }

    private String getAuthors(PluginDescriptionFile desc) {
        StringBuilder result = new StringBuilder();
        List authors = desc.getAuthors();
        for (int i = 0; i < authors.size(); ++i) {
            if (result.length() > 0) {
                result.append(ChatColor.WHITE);
                result.append(i < authors.size() - 1 ? ", " : " and ");
            }
            result.append(ChatColor.GREEN);
            result.append((String)authors.get(i));
        }
        return result.toString();
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull(sender, "Sender cannot be null");
        Validate.notNull(args, "Arguments cannot be null");
        Validate.notNull(alias, "Alias cannot be null");
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String toComplete = args[0].toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!StringUtil.startsWithIgnoreCase((String)plugin.getName(), (String)toComplete)) continue;
                completions.add(plugin.getName());
            }
            return completions;
        }
        return ImmutableList.of();
    }

    private void sendVersion(CommandSender sender) {
        if (this.hasVersion) {
            if (System.currentTimeMillis() - this.lastCheck > 21600000L) {
                this.lastCheck = System.currentTimeMillis();
                this.hasVersion = false;
            } else {
                sender.sendMessage(this.versionMessage);
                return;
            }
        }
        this.versionLock.lock();
        try {
            if (this.hasVersion) {
                sender.sendMessage(this.versionMessage);
                return;
            }
            this.versionWaiters.add(sender);
            sender.sendMessage("Checking version, please wait...");
            if (!this.versionTaskStarted) {
                this.versionTaskStarted = true;
                new Thread(this::obtainVersion).start();
            }
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private void obtainVersion() {
        String version = Bukkit.getVersion();
        if (version == null) {
            version = "Custom";
        }
        if (version.startsWith("git-Cardboard-")) {
            int cbVersions = VersionCommand.check();
            this.setVersionMessage((String)(cbVersions == 0 ? "You are running the latest version" : "You are " + cbVersions + " version(s) behind"));
        } else {
            this.setVersionMessage("Unknown version, custom build?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVersionMessage(String msg) {
        this.lastCheck = System.currentTimeMillis();
        this.versionMessage = msg;
        this.versionLock.lock();
        try {
            this.hasVersion = true;
            this.versionTaskStarted = false;
            for (CommandSender sender : this.versionWaiters) {
                sender.sendMessage(this.versionMessage);
            }
            this.versionWaiters.clear();
        }
        finally {
            this.versionLock.unlock();
        }
    }

    public static String getGitHash() {
        try {
            Class<?> version = Class.forName("org.cardboardpowered.GitVersion");
            return (String)version.getField("GIT_SHA").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return "-unknown-";
        }
    }

    public static boolean isDirty() {
        try {
            Class<?> version = Class.forName("org.cardboardpowered.GitVersion");
            return (Integer)version.getField("DIRTY").get(null) == 1;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public static int check() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.github.com/repos/CardboardPowered/cardboard/compare/" + BRANCH + "..." + VersionCommand.getGitHash()).openConnection();
            connection.connect();
            if (connection.getResponseCode() == 404) {
                return -2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            String status = obj.get("status").getAsString();
            if (status.equalsIgnoreCase("identical")) {
                return 0;
            }
            if (status.equalsIgnoreCase("behind")) {
                return obj.get("behind_by").getAsInt();
            }
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -3;
        }
    }
}

