/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory.recipe;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7709;
import net.minecraft.class_7710;
import net.minecraft.class_7924;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.cardboardpowered.interfaces.IIngredient;

public interface RecipeInterface
extends Recipe {
    public void addToCraftingManager();

    default public Optional<class_1856> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null || bukkit == RecipeChoice.empty() ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public class_1856 toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        return RecipeInterface.toIngredient(bukkit, requireNotEmpty);
    }

    public static class_1856 toIngredient(RecipeChoice bukkit, boolean requireNotEmpty) {
        class_1856 stack;
        if (bukkit == null) {
            stack = class_1856.method_8091((class_1935[])new class_1935[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = class_1856.method_26964(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = IIngredient.cb$ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            if (bukkit == RecipeChoice.empty()) {
                throw new IllegalArgumentException("This ingredient cannot be empty");
            }
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.method_65799() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(Optional<class_1856> list) {
        return list.map(RecipeInterface::toBukkit).orElse(RecipeChoice.empty());
    }

    public static RecipeChoice toBukkit(class_1856 list) {
        if (list.method_65799()) {
            return RecipeChoice.empty();
        }
        IIngredient cblist = (IIngredient)list;
        if (cblist.cb$isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(cblist.cb$itemStacks().size());
            for (class_1799 i2 : cblist.cb$itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i2));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.method_8105().map(i -> CraftItemType.minecraftToBukkit((class_1792)i.comp_349())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static class_7710 getCategory(CraftingBookCategory bukkit) {
        return class_7710.valueOf((String)bukkit.name());
    }

    public static CraftingBookCategory getCategory(class_7710 nms) {
        return CraftingBookCategory.valueOf(nms.name());
    }

    public static class_7709 getCategory(CookingBookCategory bukkit) {
        return class_7709.valueOf((String)bukkit.name());
    }

    public static CookingBookCategory getCategory(class_7709 nms) {
        return CookingBookCategory.valueOf(nms.name());
    }

    public static class_5321<class_1860<?>> toMinecraft(NamespacedKey key) {
        return class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)CraftNamespacedKey.toMinecraft(key));
    }
}

