/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.util;

import net.minecraft.class_1311;
import org.bukkit.entity.SpawnCategory;

public class CardboardSpawnCategory {
    public static boolean isValidForLimits(SpawnCategory spawnCategory) {
        return spawnCategory != null && spawnCategory.ordinal() < SpawnCategory.MISC.ordinal();
    }

    public static String getConfigNameSpawnLimit(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "spawn-limits.monsters";
            case SpawnCategory.ANIMAL -> "spawn-limits.animals";
            case SpawnCategory.WATER_ANIMAL -> "spawn-limits.water-animals";
            case SpawnCategory.WATER_AMBIENT -> "spawn-limits.water-ambient";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "spawn-limits.water-underground-creature";
            case SpawnCategory.AMBIENT -> "spawn-limits.ambient";
            case SpawnCategory.AXOLOTL -> "spawn-limits.axolotls";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for spawn-limits");
        };
    }

    public static String getConfigNameTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "ticks-per.monster-spawns";
            case SpawnCategory.ANIMAL -> "ticks-per.animal-spawns";
            case SpawnCategory.WATER_ANIMAL -> "ticks-per.water-spawns";
            case SpawnCategory.WATER_AMBIENT -> "ticks-per.water-ambient-spawns";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "ticks-per.water-underground-creature-spawns";
            case SpawnCategory.AMBIENT -> "ticks-per.ambient-spawns";
            case SpawnCategory.AXOLOTL -> "ticks-per.axolotl-spawns";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static long getDefaultTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER, SpawnCategory.WATER_ANIMAL, SpawnCategory.WATER_AMBIENT, SpawnCategory.WATER_UNDERGROUND_CREATURE, SpawnCategory.AMBIENT, SpawnCategory.AXOLOTL -> 1L;
            case SpawnCategory.ANIMAL -> 400L;
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static SpawnCategory toBukkit(class_1311 enumCreatureType) {
        return switch (enumCreatureType) {
            case class_1311.field_6302 -> SpawnCategory.MONSTER;
            case class_1311.field_6294 -> SpawnCategory.ANIMAL;
            case class_1311.field_6303 -> SpawnCategory.AMBIENT;
            case class_1311.field_34447 -> SpawnCategory.AXOLOTL;
            case class_1311.field_6300 -> SpawnCategory.WATER_ANIMAL;
            case class_1311.field_24460 -> SpawnCategory.WATER_AMBIENT;
            case class_1311.field_30092 -> SpawnCategory.WATER_UNDERGROUND_CREATURE;
            case class_1311.field_17715 -> SpawnCategory.MISC;
            default -> SpawnCategory.valueOf((String)enumCreatureType.name());
        };
    }

    public static class_1311 toNMS(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> class_1311.field_6302;
            case SpawnCategory.ANIMAL -> class_1311.field_6294;
            case SpawnCategory.AMBIENT -> class_1311.field_6303;
            case SpawnCategory.AXOLOTL -> class_1311.field_34447;
            case SpawnCategory.WATER_ANIMAL -> class_1311.field_6300;
            case SpawnCategory.WATER_AMBIENT -> class_1311.field_24460;
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> class_1311.field_30092;
            case SpawnCategory.MISC -> class_1311.field_17715;
            default -> class_1311.valueOf((String)spawnCategory.name());
        };
    }
}

