/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.world;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.CoordinateUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import me.isaiah.common.cmixin.IMixinWorld;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.cardboardpowered.impl.world.CardboardChunkSnapshot;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinChunk;
import org.jetbrains.annotations.NotNull;

public class CardboardChunk
implements Chunk {
    private WeakReference<class_2818> weakChunk;
    private final class_3218 worldServer;
    private final int x;
    private final int z;
    private static class_2841<class_2680> emptyBlockIDs;
    private static final byte[] emptyLight;
    private static final byte[] FULL_LIGHT;
    private static final byte[] EMPTY_LIGHT;

    public static void setEmptyBlockIds(class_1937 world) {
        if (null == emptyBlockIDs) {
            IMixinWorld ic = (IMixinWorld)world;
            emptyBlockIDs = ic.I_emptyBlockIDs();
        }
    }

    public CardboardChunk(class_2818 chunk) {
        this.weakChunk = new WeakReference<class_2818>(chunk);
        this.worldServer = (class_3218)this.getHandle().method_12200();
        this.x = this.getHandle().method_12004().field_9181;
        this.z = this.getHandle().method_12004().field_9180;
    }

    public CardboardChunk(class_3218 worldServer, int x2, int z2) {
        this.worldServer = worldServer;
        this.x = x2;
        this.z = z2;
    }

    public CraftWorld getWorld() {
        return this.worldServer.method_8410().getCraftWorld();
    }

    public CraftWorld getCraftWorld() {
        return this.getWorld();
    }

    public class_2818 getHandle() {
        class_2818 c = (class_2818)this.weakChunk.get();
        if (c == null) {
            c = this.worldServer.method_8497(this.x, this.z);
            this.weakChunk = new WeakReference<class_2818>(c);
        }
        return c;
    }

    public class_2791 getHandle(class_2806 chunkStatus) {
        class_2791 chunkAccess = this.worldServer.method_22342(this.x, this.z, chunkStatus);
        if (chunkAccess instanceof class_2821) {
            class_2821 extension = (class_2821)chunkAccess;
            return extension.method_12240();
        }
        return chunkAccess;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    public int getX() {
        return this.getHandle().method_12004().field_9181;
    }

    public int getZ() {
        return this.getHandle().method_12004().field_9180;
    }

    public String toString() {
        return "BukkitChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    public Block getBlock(int x, int y, int z) {
        return new CraftBlock(this.worldServer, new class_2338(this.x << 4 | x, y, this.z << 4 | z));
    }

    public Entity[] getEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int count = 0;
        boolean index = false;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity e : this.getWorld().getEntities()) {
            if (e.getChunk() != this) continue;
            ++count;
            list.add(e);
        }
        return list.toArray(new Entity[list.size()]);
    }

    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        class_2818 chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.method_12214().size()];
        for (Object obj : chunk.method_12214().keySet().toArray()) {
            if (!(obj instanceof class_2338)) continue;
            class_2338 position = (class_2338)obj;
            entities[index++] = ((org.cardboardpowered.interfaces.IMixinWorld)this.worldServer).getCraftWorld().getBlockAt(position.method_10263(), position.method_10264(), position.method_10260()).getState();
        }
        return entities;
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean isSlimeChunk() {
        return false;
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return this.getHandle().method_12033();
    }

    public void setInhabitedTime(long ticks) {
        this.getHandle().method_12028(ticks);
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (class_2826 section : this.getHandle().method_12006()) {
            if (section == null || !section.method_12265().method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        class_2791 chunk = this.getHandle(class_2806.field_12803);
        class_2826[] cs = chunk.method_12006();
        class_2841[] sectionBlockIDs = new class_2841[cs.length];
        boolean includeLightData = true;
        byte[][] sectionSkyLights = includeLightData ? new byte[cs.length][] : null;
        byte[][] sectionEmitLights = includeLightData ? new byte[cs.length][] : null;
        boolean[] sectionEmpty = new boolean[cs.length];
        class_2841[] biome = !includeBiome && !includeBiomeTempRain ? null : new class_2841[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            sectionEmpty[i] = cs[i].method_38292();
            sectionBlockIDs[i] = !sectionEmpty[i] ? cs[i].method_12265().method_39957() : emptyBlockIDs;
            if (includeLightData) {
                class_3568 lightEngine = this.worldServer.method_22336();
                class_2804 skyLightArray = lightEngine.method_15562(class_1944.field_9284).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i), (int)this.z));
                if (skyLightArray == null) {
                    sectionSkyLights[i] = this.worldServer.method_8597().comp_642() ? FULL_LIGHT : EMPTY_LIGHT;
                } else {
                    sectionSkyLights[i] = new byte[2048];
                    System.arraycopy(skyLightArray.method_12137(), 0, sectionSkyLights[i], 0, 2048);
                }
                class_2804 emitLightArray = lightEngine.method_15562(class_1944.field_9282).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i), (int)this.z));
                if (emitLightArray == null) {
                    sectionEmitLights[i] = EMPTY_LIGHT;
                } else {
                    sectionEmitLights[i] = new byte[2048];
                    System.arraycopy(emitLightArray.method_12137(), 0, sectionEmitLights[i], 0, 2048);
                }
            }
            if (biome == null) continue;
            biome[i] = cs[i].method_38294().method_39957();
        }
        class_2902 heightmap = null;
        if (includeMaxBlockY) {
            heightmap = new class_2902(chunk, class_2902.class_2903.field_13197);
            heightmap.method_12600(chunk, class_2902.class_2903.field_13197, chunk.method_12032(class_2902.class_2903.field_13197).method_12598());
        }
        class_2378 iregistry = this.worldServer.method_30349().method_30530(class_7924.field_41236);
        CraftWorld world = this.getWorld();
        return new CardboardChunkSnapshot(this.getX(), this.getZ(), chunk.method_31607(), chunk.method_31600(), world.getSeaLevel(), world.getName(), world.getFullTime(), (class_2841<class_2680>[])sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, heightmap, (class_2378<class_1959>)iregistry, (class_7522<class_6880<class_1959>>[])biome);
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        class_2791 actual = world.getHandle().method_22342(x, z, includeBiome || includeBiomeTempRain ? class_2806.field_12794 : class_2806.field_12798);
        int hSection = actual.method_32890();
        class_2841[] blockIDs = new class_2841[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        class_2378 iregistry = world.getHandle().method_30349().method_30530(class_7924.field_41236);
        class_2841[] biome = includeBiome || includeBiomeTempRain ? new class_2841[hSection] : null;
        Codec biomeCodec = world.getHandle().method_74142().comp_4790();
        for (int i = 0; i < hSection; ++i) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = emptyLight;
            emitLight[i] = emptyLight;
            empty[i] = true;
            if (biome == null) continue;
            biome[i] = (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)biomeCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)actual.method_38259(i).method_38294()).getOrThrow())).getOrThrow(class_2852.class_9314::new);
        }
        return new CardboardChunkSnapshot(x, z, world.getMinHeight(), world.getMaxHeight(), world.getSeaLevel(), world.getName(), world.getFullTime(), (class_2841<class_2680>[])blockIDs, skyLight, emitLight, empty, new class_2902(actual, class_2902.class_2903.field_13197), (class_2378<class_1959>)iregistry, (class_7522<class_6880<class_1959>>[])biome);
    }

    static void validateChunkCoordinates(int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((0 <= y && y <= 255 ? 1 : 0) != 0, (String)"y out of range (expected 0-255, got %s)", (int)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((minY <= y && y <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return null;
    }

    public BlockState[] getTileEntities(boolean arg0) {
        Map map = this.getHandle().method_12214();
        BlockState[] bk = new BlockState[map.size()];
        int i = 0;
        for (class_2586 e : map.values()) {
            bk[i] = CraftBlockState.getBlockState((class_1936)this.worldServer, e.method_11016());
            ++i;
        }
        return bk;
    }

    public Collection<BlockState> getTileEntities(Predicate<? super Block> blockPredicate, boolean useSnapshot) {
        Preconditions.checkNotNull(blockPredicate, (Object)"blockPredicate");
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        class_2791 chunk = this.getHandle(class_2806.field_12803);
        ArrayList<BlockState> entities = new ArrayList<BlockState>();
        for (class_2338 position : ((IMixinChunk)chunk).cardboard_getBlockEntities().keySet()) {
            Block block = this.worldServer.getCraftWorld().getBlockAt(position.method_10263(), position.method_10264(), position.method_10260());
            if (!blockPredicate.test((Block)block)) continue;
            entities.add(block.getState(useSnapshot));
        }
        return entities;
    }

    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().method_37116(CoordinateUtils.getChunkKey(this.x, this.z));
    }

    public boolean contains(@NotNull Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        class_2791 chunk = this.getHandle(class_2806.field_12794);
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)CraftBlock.biomeToBiomeBase(((IMixinChunk)chunk).bridge$biomeRegistry(), biome));
        for (class_2826 section : chunk.method_12006()) {
            if (section == null || !section.method_38294().method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    public Chunk.LoadLevel getLoadLevel() {
        if (!this.worldServer.method_8393(this.getX(), this.getZ())) {
            return Chunk.LoadLevel.UNLOADED;
        }
        class_2818 chunk = this.worldServer.method_8497(this.getX(), this.getZ());
        if (chunk == null) {
            return Chunk.LoadLevel.UNLOADED;
        }
        return Chunk.LoadLevel.values()[chunk.method_12225().ordinal()];
    }

    public boolean isGenerated() {
        class_2791 chunk = this.getHandle(class_2806.field_12798);
        return chunk.method_12009().method_12165(class_2806.field_12803);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain, boolean includeLightData) {
        class_2791 chunk = this.getHandle(class_2806.field_12803);
        class_2826[] cs = chunk.method_12006();
        class_2841[] sectionBlockIDs = new class_2841[cs.length];
        byte[][] sectionSkyLights = includeLightData ? new byte[cs.length][] : null;
        byte[][] sectionEmitLights = includeLightData ? new byte[cs.length][] : null;
        boolean[] sectionEmpty = new boolean[cs.length];
        class_2841[] biome = includeBiome || includeBiomeTempRain ? new class_2841[cs.length] : null;
        class_2378 iregistry = this.worldServer.method_30349().method_30530(class_7924.field_41236);
        for (int i2 = 0; i2 < cs.length; ++i2) {
            sectionEmpty[i2] = cs[i2].method_38292();
            class_2841 class_28412 = sectionBlockIDs[i2] = !sectionEmpty[i2] ? cs[i2].method_12265().method_39957() : emptyBlockIDs;
            if (includeLightData) {
                class_3568 lightengine = this.worldServer.method_22336();
                class_2804 skyLightArray = lightengine.method_15562(class_1944.field_9284).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i2), (int)this.z));
                if (skyLightArray == null) {
                    sectionSkyLights[i2] = this.worldServer.method_8597().comp_642() ? FULL_LIGHT : EMPTY_LIGHT;
                } else {
                    sectionSkyLights[i2] = new byte[2048];
                    System.arraycopy(skyLightArray.method_12137(), 0, sectionSkyLights[i2], 0, 2048);
                }
                class_2804 emitLightArray = lightengine.method_15562(class_1944.field_9282).method_15544(class_4076.method_18676((int)this.x, (int)chunk.method_31604(i2), (int)this.z));
                if (emitLightArray == null) {
                    sectionEmitLights[i2] = EMPTY_LIGHT;
                } else {
                    sectionEmitLights[i2] = new byte[2048];
                    System.arraycopy(emitLightArray.method_12137(), 0, sectionEmitLights[i2], 0, 2048);
                }
            }
            if (biome == null) continue;
            biome[i2] = ((class_2841)cs[i2].method_38294()).method_39957();
        }
        class_2902 hmap = null;
        if (includeMaxBlockY) {
            hmap = new class_2902(chunk, class_2902.class_2903.field_13197);
            hmap.method_12600(chunk, class_2902.class_2903.field_13197, chunk.method_12032(class_2902.class_2903.field_13197).method_12598());
        }
        CraftWorld world = this.getWorld();
        return new CardboardChunkSnapshot(this.getX(), this.getZ(), chunk.method_31607(), chunk.method_31600(), world.getSeaLevel(), world.getName(), world.getFullTime(), (class_2841<class_2680>[])sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, (class_2378<class_1959>)iregistry, (class_7522<class_6880<class_1959>>[])biome);
    }

    public Collection<GeneratedStructure> getStructures() {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ());
    }

    public Collection<GeneratedStructure> getStructures(@NotNull Structure structure) {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ(), structure);
    }

    @NotNull
    public Collection<Player> getPlayersSeeingChunk() {
        return this.getWorld().getPlayersSeeingChunk(this);
    }

    static {
        emptyLight = new byte[2048];
        FULL_LIGHT = new byte[2048];
        EMPTY_LIGHT = new byte[2048];
        Arrays.fill(emptyLight, (byte)-1);
    }
}

