/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.world.PaperWorldLoader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_10592;
import net.minecraft.class_11542;
import net.minecraft.class_11545;
import net.minecraft.class_1267;
import net.minecraft.class_128;
import net.minecraft.class_1419;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2170;
import net.minecraft.class_26;
import net.minecraft.class_269;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_2910;
import net.minecraft.class_2960;
import net.minecraft.class_2994;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3769;
import net.minecraft.class_3990;
import net.minecraft.class_4093;
import net.minecraft.class_4208;
import net.minecraft.class_4274;
import net.minecraft.class_4543;
import net.minecraft.class_4565;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7237;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardManager;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.PluginLoadOrder;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.interfaces.IMixinMinecraftServer;
import org.cardboardpowered.interfaces.INetworkIo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
extends class_4093<class_3738>
implements IMixinMinecraftServer {
    public class_7237.class_7660 worldLoaderContext;
    @Shadow
    private long field_47139;
    @Shadow
    @Final
    @Mutable
    protected class_5219 field_24372;
    @Shadow
    @Final
    public class_29 field_24371;
    @Shadow
    public Map<class_5321<class_1937>, class_3218> field_4589;
    @Shadow
    public MinecraftServer.class_6897 field_25318;
    @Shadow
    public class_32.class_5143 field_23784;
    @Shadow
    public class_4565 field_20850;
    @Shadow
    private int field_4572;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    private boolean forceTicks;
    private boolean hasStopped = false;
    private final Object stopLock = new Object();

    @Override
    public class_7237.class_7660 cardboard$worldLoaderContext() {
        return this.worldLoaderContext;
    }

    @Shadow
    public abstract class_3218 method_30002();

    @Shadow
    public abstract boolean method_3723(boolean var1, boolean var2, boolean var3);

    public MixinMinecraftServer(String string) {
        super(string);
    }

    @Shadow
    public void method_17976(class_26 arg0) {
    }

    public void setDataCommandStorage(class_4565 data) {
        this.field_20850 = data;
    }

    @Override
    public class_32.class_5143 getSessionBF() {
        return this.field_23784;
    }

    @Override
    public class_29 getSaveHandler_BF() {
        return this.field_24371;
    }

    @Inject(at={@At(value="HEAD")}, method={"getServerModName"}, remap=false, cancellable=true)
    public void getServerModName_cardboard(CallbackInfoReturnable<String> ci) {
        if (null != Bukkit.getServer()) {
            ci.setReturnValue((Object)"Cardboard (Paper+Fabric)");
        }
    }

    @Override
    public Map<class_5321<class_1937>, class_3218> getWorldMap() {
        return this.field_4589;
    }

    @Override
    public void convertWorld(String name) {
    }

    @Override
    public Queue<Runnable> getProcessQueue() {
        return this.processQueue;
    }

    @Override
    public class_2170 setCommandManager(class_2170 commandManager) {
        this.field_25318.comp_353().field_25336 = commandManager;
        return this.field_25318.comp_353().field_25336;
    }

    @Override
    public MinecraftServer getServer() {
        return (MinecraftServer)this;
    }

    @Inject(at={@At(value="TAIL")}, method={"loadWorld"})
    public void afterWorldLoad(CallbackInfo ci) {
        for (class_3218 worldserver : ((MinecraftServer)this).method_3738()) {
            if (worldserver == this.method_30002()) continue;
            MixinMinecraftServer.method_27901(worldserver, worldserver.field_24456, false, false, worldserver.cardboard$levelLoadListener());
            CraftServer.INSTANCE.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getCraftWorld()));
        }
        CraftServer.INSTANCE.enablePlugins(PluginLoadOrder.POSTWORLD);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        ((INetworkIo)this.getServer().method_3787()).acceptConnections();
        CraftMagicNumbers.setupUnknownModdedMaterials();
        this.fixBukkitWorldEdit();
        CardboardMod.isAfterWorldLoad = true;
    }

    @Override
    public void addLevel(class_3218 level) {
        this.field_4589.put((class_5321<class_1937>)level.method_27983(), level);
    }

    @Override
    public void removeLevel(class_3218 level) {
        ((ServerWorldEvents.Unload)ServerWorldEvents.UNLOAD.invoker()).onWorldUnload((MinecraftServer)this, level);
        this.field_4589.remove(level.method_27983());
    }

    public void updateDifficulty() {
        ((MinecraftServer)this).method_3776((class_1267)((class_2994)this).method_16705().field_16840.get(), true);
    }

    private void fixBukkitWorldEdit() {
        try {
            HashMap<String, Material> moddedMaterials;
            if (!Bukkit.getPluginManager().isPluginEnabled("WorldEdit")) {
                return;
            }
            ClassLoader cl = Bukkit.getPluginManager().getPlugin("WorldEdit").getClass().getClassLoader();
            Class<?> ITEM_TYPE = Class.forName("com.sk89q.worldedit.world.item.ItemType", true, cl);
            Class<?> BLOCK_TYPE = Class.forName("com.sk89q.worldedit.world.block.BlockType", true, cl);
            Object REGISTRY_ITEM = ITEM_TYPE.getDeclaredField("REGISTRY").get(null);
            Method REGISTER_ITEM = null;
            for (Method m : REGISTRY_ITEM.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("register")) continue;
                REGISTER_ITEM = m;
                break;
            }
            Object REGISTRY_BLOCK = BLOCK_TYPE.getDeclaredField("REGISTRY").get(null);
            Method REGISTER_BLOCK = null;
            for (Method m : REGISTRY_BLOCK.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("register")) continue;
                REGISTER_BLOCK = m;
                break;
            }
            if ((moddedMaterials = CraftMagicNumbers.getModdedMaterials()).size() > 0) {
                CardboardMod.LOGGER.info("Adding Modded blocks/items to WorldEdit registry...");
            }
            for (String mid : moddedMaterials.keySet()) {
                try {
                    REGISTER_ITEM.invoke(REGISTRY_ITEM, "minecraft:" + mid.toLowerCase(), ITEM_TYPE.getConstructor(String.class).newInstance(mid));
                    REGISTER_BLOCK.invoke(REGISTRY_BLOCK, "minecraft:" + mid.toLowerCase(), BLOCK_TYPE.getConstructor(String.class).newInstance(mid));
                }
                catch (Exception exception) {}
            }
            if (moddedMaterials.size() > 0) {
                CardboardMod.LOGGER.info("Added " + moddedMaterials.size() + "Modded blocks/items to WorldEdit registry.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cardboard$prepareLevel(class_3218 serverLevel) {
        this.forceTicks = true;
        class_11542 chunkLoadCounter = new class_11542();
        chunkLoadCounter.method_72247(serverLevel, () -> {
            class_10592 ticketStorage = (class_10592)serverLevel.method_17983().method_20786(class_10592.field_56451);
            if (ticketStorage != null) {
                ticketStorage.method_66367();
            }
        });
        class_3218 world = serverLevel;
        world.cardboard$levelLoadListener().method_72281(class_11545.class_11546.field_61107, chunkLoadCounter.method_72251());
        do {
            world.cardboard$levelLoadListener().method_72282(class_11545.class_11546.field_61107, chunkLoadCounter.method_72245(), chunkLoadCounter.method_72251());
            this.executeModerately();
        } while (chunkLoadCounter.method_72249() > 0);
        world.cardboard$levelLoadListener().method_72280(class_11545.class_11546.field_61107);
        serverLevel.method_8424(serverLevel.field_24456.method_207() != class_1267.field_5801 && serverLevel.method_64395().method_8355(class_1928.field_62436));
        this.method_74946();
        this.forceTicks = false;
        new WorldLoadEvent((World)serverLevel.getWorld()).callEvent();
    }

    @Shadow
    public void method_74946() {
    }

    @Shadow
    private void method_27729() {
    }

    @Deprecated
    private void updateMobSpawnOptions_1_15_2() {
        this.method_27729();
    }

    private void executeModerately() {
        this.method_5383();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldKeepTicking"}, cancellable=true)
    public void shouldKeepTicking_BF(CallbackInfoReturnable<Boolean> ci) {
        boolean bl = this.forceTicks;
        if (bl) {
            ci.setReturnValue((Object)bl);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickWorlds"})
    public void doBukkitRunnables(BooleanSupplier b, CallbackInfo ci) {
        CraftServer.INSTANCE.getScheduler().mainThreadHeartbeat(this.field_4572);
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
    }

    @Override
    public void cardboard_runOnMainThread(Runnable r) {
        System.out.print("runOnMainThread");
        this.processQueue.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"shutdown"})
    public void doStop(CallbackInfo ci) {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (null != CraftServer.INSTANCE) {
            CraftServer.INSTANCE.getPluginManager().disablePlugins();
        }
    }

    public void initWorld(class_3218 serverLevel, class_31 serverLevelData, class_5285 worldOptions) {
        this.cardboard$initLevel(serverLevel);
        this.cardboard$initializedLevel(serverLevel, (class_5268)serverLevelData, worldOptions);
    }

    private void cardboard$initLevel(class_3218 serverWorld) {
        if (((CraftServer)Bukkit.getServer()).scoreboardManager == null) {
            ((CraftServer)Bukkit.getServer()).scoreboardManager = new CardboardScoreboardManager((MinecraftServer)this, (class_269)serverWorld.method_14170());
        }
    }

    private void cardboard$initializedLevel(class_3218 worldserver, class_5268 worldProperties, class_5285 generatorsettings) {
        boolean flag = false;
        class_2784 worldborder = worldserver.method_8621();
        worldborder.method_17905((class_2784.class_5200)worldProperties.method_27422().get());
        Bukkit.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getCraftWorld()));
        if (!worldProperties.method_222()) {
            try {
                MixinMinecraftServer.method_27901(worldserver, worldProperties, generatorsettings.method_28030(), flag, worldserver.cardboard$levelLoadListener());
                worldProperties.method_223(true);
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Exception initializing level");
                throw new class_148(crashreport);
            }
            worldProperties.method_223(true);
        }
        class_4208 globalPos = ((MinecraftServer)this).method_73041();
        worldserver.cardboard$levelLoadListener().method_72279(globalPos.comp_2207(), new class_1923(globalPos.comp_2208()));
    }

    @Override
    public void createLevel(class_5363 levelStem, PaperWorldLoader.WorldLoadingInfo loadingInfo, class_32.class_5143 levelStorageAccess, class_31 serverLevelData) {
        class_3218 serverLevel;
        MinecraftServer server = (MinecraftServer)this;
        class_5285 worldOptions = serverLevelData.method_28057();
        long seed = worldOptions.method_28028();
        long l = class_4543.method_27984((long)seed);
        ImmutableList list = ImmutableList.of((Object)new class_2910(), (Object)new class_3769(), (Object)new class_4274(), (Object)new class_1419(), (Object)new class_3990((class_5268)serverLevelData));
        CraftWorldInfo worldInfo = new CraftWorldInfo(serverLevelData, levelStorageAccess, World.Environment.getEnvironment((int)loadingInfo.dimension()), (class_2874)levelStem.comp_1012().comp_349(), levelStem.comp_1013(), server.method_30611());
        class_5321 dimensionKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loadingInfo.stemKey().method_29177());
        if (loadingInfo.stemKey() == class_5363.field_25412) {
            serverLevel = new class_3218(server, server.field_17200, levelStorageAccess, (class_5268)serverLevelData, dimensionKey, levelStem, serverLevelData.method_45556(), l, (List)list, true, null);
            this.field_24372 = serverLevelData;
            this.field_24372.method_193((class_1934)((class_3176)this).method_16705().field_16841.get());
            class_26 dataStorage = serverLevel.method_17983();
            this.method_17976(dataStorage);
            this.field_20850 = new class_4565(dataStorage);
            CraftServer.INSTANCE.scoreboardManager = new CardboardScoreboardManager(server, (class_269)serverLevel.method_14170());
        } else {
            List spawners = Collections.emptyList();
            serverLevel = new class_3218(server, server.field_17200, levelStorageAccess, (class_5268)serverLevelData, dimensionKey, levelStem, this.field_24372.method_45556(), l, spawners, true, server.method_30002().method_52168());
        }
        this.addLevel(serverLevel);
        this.initWorld(serverLevel, serverLevelData, worldOptions);
    }

    @Shadow
    private static void method_27901(class_3218 world, class_5268 worldProperties, boolean bonusChest, boolean debugWorld, class_11545 loadProgress) {
    }
}

