/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.profile.MutablePropertyMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_11560;
import net.minecraft.class_156;
import net.minecraft.class_3176;
import net.minecraft.class_4844;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.profile.CraftPlayerTextures;
import org.bukkit.profile.PlayerTextures;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class CraftPlayerProfile
implements PlayerProfile,
SharedPlayerProfile {
    private boolean emptyName;
    private boolean emptyUUID;
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();
    static final String PROPERTY_NAME = "textures";

    public CraftPlayerProfile(CraftPlayer player) {
        this.profile = player.getHandle().method_7334();
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = CraftPlayerProfile.createAuthLibProfile(id, name);
        this.emptyName = name == null;
        this.emptyUUID = id == null;
    }

    public CraftPlayerProfile(GameProfile profile) {
        Validate.notNull((Object)profile, (String)"GameProfile cannot be null!", (Object[])new Object[0]);
        this.profile = profile;
    }

    public CraftPlayerProfile(class_11560 nameAndId) {
        this(nameAndId.comp_4422(), nameAndId.comp_4423());
    }

    public CraftPlayerProfile(class_9296 resolvableProfile) {
        this((UUID)resolvableProfile.method_73305().map(GameProfile::id, p -> p.comp_4626().orElse(null)), (String)resolvableProfile.method_73305().map(GameProfile::name, p -> p.comp_4625().orElse(null)));
        CraftPlayerProfile.copyProfileProperties(resolvableProfile.method_73313(), this.profile);
    }

    private static GameProfile createAuthLibProfile(UUID uniqueId, String name) {
        return new GameProfile(uniqueId != null ? uniqueId : class_156.field_25140, name != null ? name : "", (PropertyMap)new MutablePropertyMap());
    }

    public boolean hasProperty(String property) {
        return this.profile.properties().containsKey((Object)property);
    }

    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.properties();
        properties.removeAll((Object)name);
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }

    public UUID getId() {
        return this.profile.id();
    }

    public UUID setId(UUID uuid) {
        GameProfile prev = this.profile;
        this.profile = CraftPlayerProfile.createAuthLibProfile(uuid, prev.name());
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.id();
    }

    @Override
    public String getName() {
        return this.profile.name();
    }

    public String setName(String name) {
        GameProfile prev = this.profile;
        this.profile = CraftPlayerProfile.createAuthLibProfile(prev.id(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.name();
    }

    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    public void clearProperties() {
        this.profile.properties().clear();
    }

    @Override
    public boolean removeProperty(String property) {
        return !this.profile.properties().removeAll((Object)property).isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return this.profile.toString();
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    public boolean isComplete() {
        return this.getUniqueId() != null && this.getName() != null && !this.getTextures().isEmpty();
    }

    public boolean completeFromCache() {
        class_3176 server = CraftServer.INSTANCE.getServer();
        return this.completeFromCache(false, server.method_3828() || SpigotConfig.bungee);
    }

    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    public GameProfile PlayerConfigEntry_toUncompletedGameProfile(class_11560 thiz) {
        return new GameProfile(thiz.comp_4422(), thiz.comp_4423());
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        GameProfile copy;
        Object nameAndId;
        class_3176 server = CraftServer.INSTANCE.getServer();
        String name = this.profile.name();
        if (this.getId() == null) {
            GameProfile profile;
            if (onlineMode) {
                profile = CraftServer.INSTANCE.getPaperFilledProfileCache().getIfCached(name);
                if (profile == null && lookupUUID && (nameAndId = (class_11560)server.method_73550().comp_4407().method_14515(name).orElse(null)) != null) {
                    profile = this.PlayerConfigEntry_toUncompletedGameProfile((class_11560)nameAndId);
                }
            } else {
                profile = class_4844.method_54140((String)name);
            }
            if (profile != null) {
                copy = new GameProfile(profile.id(), profile.name(), (PropertyMap)new MutablePropertyMap());
                copy.properties().putAll((Multimap)profile.properties());
                CraftPlayerProfile.copyProfileProperties(this.profile, copy);
                this.profile = copy;
                this.emptyUUID = false;
            }
        }
        if ((this.profile.name().isEmpty() || !this.hasTextures()) && this.getId() != null) {
            GameProfile profilex = CraftServer.INSTANCE.getPaperFilledProfileCache().getIfCached(this.profile.id());
            if (profilex == null && ((Optional)(nameAndId = server.method_73550().comp_4407().method_14512(this.profile.id()))).isPresent()) {
                profilex = this.PlayerConfigEntry_toUncompletedGameProfile((class_11560)((Optional)nameAndId).get());
            }
            if (profilex != null) {
                if (this.profile.name().isEmpty()) {
                    copy = new GameProfile(profilex.id(), profilex.name(), (PropertyMap)new MutablePropertyMap());
                    copy.properties().putAll((Multimap)profilex.properties());
                    CraftPlayerProfile.copyProfileProperties(this.profile, copy);
                    this.profile = copy;
                    this.emptyName = false;
                } else if (profilex != this.profile) {
                    CraftPlayerProfile.copyProfileProperties(profilex, this.profile);
                }
            }
        }
        return this.isComplete();
    }

    public boolean complete(boolean textures) {
        class_3176 server = CraftServer.INSTANCE.getServer();
        return this.complete(textures, server.method_3828() || SpigotConfig.bungee);
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        if (!this.isComplete() || textures && !this.hasTextures()) {
            class_3176 server = CraftServer.server;
            boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
            if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
                ProfileResult result = server.method_73550().comp_837().fetchProfile(this.profile.id(), true);
                if (result != null && result.profile() != null) {
                    CraftPlayerProfile.copyProfileProperties(result.profile(), this.profile, true);
                }
                if (this.isComplete()) {
                    GameProfile copy = new GameProfile(this.profile.id(), this.profile.name(), new PropertyMap((Multimap)this.profile.properties()));
                    CraftServer.INSTANCE.getPaperFilledProfileCache().add(copy);
                }
            }
            return this.isComplete() && (!onlineMode || !textures || this.hasTextures());
        }
        return true;
    }

    private boolean isProfileComplete() {
        return this.profile.id() != null && StringUtils.isNotBlank(this.profile.name());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        PropertyMap sourceProperties = source.properties();
        PropertyMap targetProperties = target.properties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.name());
            targetProperties.put((Object)property.name(), (Object)property);
        }
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.name(), property.value(), property.signature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        CraftPlayerProfile profile = new CraftPlayerProfile(gameProfile.id(), gameProfile.name());
        CraftPlayerProfile.copyProfileProperties(gameProfile, profile.profile);
        return profile;
    }

    public static PlayerProfile asBukkitMirror(GameProfile profile) {
        return new CraftPlayerProfile(profile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return CraftPlayerProfile.asAuthlib(craft.clone());
    }

    public static GameProfile asAuthlib(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    @Override
    @Nullable
    public UUID getUniqueId() {
        return this.getId();
    }

    @NotNull
    public CompletableFuture<PlayerProfile> update() {
        return CompletableFuture.supplyAsync(() -> {
            CraftPlayerProfile clone = this.clone();
            clone.complete(true);
            return clone;
        }, (Executor)class_156.method_18349());
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.getId() != null) {
            map.put("uniqueId", this.getId().toString());
        }
        if (this.getName() != null) {
            map.put("name", this.getName());
        }
        if (!this.properties.isEmpty()) {
            ArrayList propertiesData = new ArrayList();
            for (ProfileProperty profileProperty : this.properties) {
            }
            map.put("properties", propertiesData);
        }
        return map;
    }

    @NotNull
    public PlayerTextures getTextures() {
        return new CraftPlayerTextures(this);
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        if (textures == null) {
            this.removeProperty(PROPERTY_NAME);
        } else {
            CraftPlayerTextures craftPlayerTextures = new CraftPlayerTextures(this);
            craftPlayerTextures.copyFrom(textures);
            craftPlayerTextures.rebuildPropertyIfDirty();
        }
    }

    @Override
    public GameProfile buildGameProfile() {
        GameProfile profile = new GameProfile(this.profile.id(), this.profile.name());
        profile.properties().putAll((Multimap)this.profile.properties());
        return profile;
    }

    public static GameProfile validateSkullProfile(GameProfile gameProfile) {
        boolean isValidSkullProfile = gameProfile.name() != null || gameProfile.properties().containsKey((Object)PROPERTY_NAME);
        return gameProfile;
    }

    @Override
    @Nullable
    public Property getProperty(@NotNull String var1) {
        return (Property)Iterables.getFirst((Iterable)this.profile.properties().get((Object)var1), null);
    }

    @Override
    public void setProperty(@NotNull String propertyName, @Nullable Property property) {
        if (property != null) {
            this.setProperty(new ProfileProperty(propertyName, property.value(), property.signature()));
        } else {
            this.profile.properties().removeAll((Object)propertyName);
        }
    }

    @Override
    @NotNull
    public class_9296 buildResolvableProfile() {
        return this.emptyName != this.emptyUUID && this.properties.isEmpty() ? new class_9296.class_11756(this.emptyName ? Either.right((Object)this.profile.id()) : Either.left((Object)this.profile.name()), class_8685.class_11892.field_63029) : class_9296.method_73307((GameProfile)this.buildGameProfile());
    }

    public static class_9296 asResolvableProfileCopy(@Nullable PlayerProfile profile2) {
        return ((SharedPlayerProfile)profile2).buildResolvableProfile();
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(this, CraftPlayerProfile.this.profile.properties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.properties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c) {
            CraftPlayerProfile.this.setProperties(c);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof ProfileProperty && CraftPlayerProfile.this.profile.properties().containsKey((Object)((ProfileProperty)o).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(PropertySet propertySet, Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

