/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.proxy;

import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class DelegateURLClassLoder
extends URLClassLoader {
    public static final String desc = DelegateURLClassLoder.class.getName().replace('.', '/');
    private final Map<String, Class<?>> classeCache = new HashMap();
    private final Set<Package> packageCache = Collections.newSetFromMap(new ConcurrentHashMap());

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public DelegateURLClassLoder(URL[] urls) {
        super(urls);
    }

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (RemapUtils.isNMSClass(name)) {
            String mapName = RemapUtils.map(name.replace('.', '/')).replace('/', '.');
            return Class.forName(mapName);
        }
        Class<?> result = this.classeCache.get(name);
        if (result != null) {
            return result;
        }
        String string = name.intern();
        synchronized (string) {
            result = this.remappedFindClass(name);
            if (result != null) {
                return result;
            }
            result = this.remappedFindClass(name);
            if (result == null) {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    result = Class.forName(name);
                }
            }
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
            this.cacheClass(name, result);
        }
        return result;
    }

    protected Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            InputStream stream;
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url != null && (stream = url.openStream()) != null) {
                byte[] bytecode = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                bytecode = RemapUtils.remapFindClass(bytecode);
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarURL = jarURLConnection.getJarFileURL();
                Manifest manifest = jarURLConnection.getManifest();
                this.fixPackage(manifest, url, name);
                CodeSource codeSource = new CodeSource(jarURL, new CodeSigner[0]);
                result = this.defineClass(name, bytecode, 0, bytecode.length, codeSource);
                if (result != null) {
                    this.resolveClass(result);
                }
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to remap class " + name, t);
        }
        return result;
    }

    protected void cacheClass(String name, Class<?> clazz) {
        this.classeCache.put(name, clazz);
        if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            ConfigurationSerialization.registerClass(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixPackage(Manifest manifest, URL url, String name) {
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            Attributes attributes;
            String pkgName = name.substring(0, dot);
            Package pkg = this.getPackage(pkgName);
            if (pkg == null) {
                try {
                    pkg = manifest != null ? this.definePackage(pkgName, manifest, url) : this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (pkg != null && manifest != null && !this.packageCache.contains(pkg) && (attributes = manifest.getMainAttributes()) != null) {
                try {
                    try {
                        Object versionInfo = MohistDynamEnum.getField(pkg, Package.class.getDeclaredField("versionInfo"));
                        if (versionInfo != null) {
                            Class<?> Package$VersionInfo = Class.forName("java.lang.Package$VersionInfo");
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), Package$VersionInfo.getDeclaredField("implTitle"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), Package$VersionInfo.getDeclaredField("implVersion"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), Package$VersionInfo.getDeclaredField("implVendor"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), Package$VersionInfo.getDeclaredField("specTitle"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), Package$VersionInfo.getDeclaredField("specVersion"));
                            MohistDynamEnum.setField(versionInfo, attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), Package$VersionInfo.getDeclaredField("specVendor"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.packageCache.add(pkg);
                }
            }
        }
    }
}

