/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.utils;

import com.mohistmc.banner.bukkit.nms.model.ClassMapping;
import com.mohistmc.banner.bukkit.nms.remappers.BannerInheritanceMap;
import com.mohistmc.banner.bukkit.nms.remappers.BannerInheritanceProvider;
import com.mohistmc.banner.bukkit.nms.remappers.BannerJarMapping;
import com.mohistmc.banner.bukkit.nms.remappers.BannerJarRemapper;
import com.mohistmc.banner.bukkit.nms.remappers.BannerSuperClassRemapper;
import com.mohistmc.banner.bukkit.nms.remappers.ClassRemapperSupplier;
import com.mohistmc.banner.bukkit.nms.remappers.ReflectMethodRemapper;
import com.mohistmc.banner.bukkit.nms.remappers.ReflectRemapper;
import com.mohistmc.banner.bukkit.nms.utils.ASMUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.mappingio.format.MappingFormat;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.CardboardLogger;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.block.CardboardSign;
import org.cardboardpowered.util.mapping.MyMappingResolver;
import org.cardboardpowered.util.nms.MappingsReader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;

public class RemapUtils {
    private static CardboardLogger LOGGER = CardboardLogger.get("RemapUtils");
    public static BannerJarMapping jarMapping;
    public static BannerJarRemapper jarRemapper;
    private static final List<Remapper> remappers;
    public static boolean DEBUG_VERBOSE_CALLS;
    public static String NMS_VERSION;
    private static MyMappingResolver myMappingResolver;
    private static HashMap<String, String> cspigot2fabric;
    public static MappingResolver mr;
    private static HashMap<String, String> methodExtra;

    public static File exportResource(String res, File folder) {
        File file;
        block9: {
            InputStream stream = MappingsReader.class.getClassLoader().getResourceAsStream("mappings/" + res);
            try {
                if (stream == null) {
                    throw new IOException("Null " + res);
                }
                Path p = Paths.get(folder.getAbsolutePath() + File.separator + res, new String[0]);
                Files.copy(stream, p, StandardCopyOption.REPLACE_EXISTING);
                file = p.toFile();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return file;
    }

    public static File exportResourceMetaInf(String res, File folder) {
        File file;
        block9: {
            InputStream stream = RemapUtils.class.getClassLoader().getResourceAsStream("META-INF/mappings/" + res);
            try {
                if (stream == null) {
                    throw new IOException("Null " + res);
                }
                Path p = Paths.get(folder.getAbsolutePath() + File.separator + res, new String[0]);
                Files.copy(stream, p, StandardCopyOption.REPLACE_EXISTING);
                file = p.toFile();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return file;
    }

    public static void LOG1(String msg) {
        LOGGER.info(msg);
    }

    public static void debug(String msg) {
        LOGGER.debug(msg);
    }

    public static void init() {
        RemapUtils.debug("Remap Util init");
        jarMapping = new BannerJarMapping();
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/" + NMS_VERSION + "/", "org/bukkit/craftbukkit/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/" + NMS_VERSION, "org/bukkit/craftbukkit");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/it/unimi/dsi/fastutil/", "it/unimi/dsi/fastutil/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/jline/", "jline/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/org/apache/commons/", "org/apache/commons/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/org/objectweb/asm/", "org/objectweb/asm/");
        RemapUtils.jarMapping.classes.put("org/spigotmc/event/entity/EntityMountEvent", "org/bukkit/event/entity/EntityMountEvent");
        RemapUtils.jarMapping.classes.put("org/spigotmc/event/entity/EntityDismountEvent", "org/bukkit/event/entity/EntityDismountEvent");
        jarMapping.setInheritanceMap(new BannerInheritanceMap());
        jarMapping.setFallbackInheritanceProvider(new BannerInheritanceProvider());
        MappingResolver mr = FabricLoader.getInstance().getMappingResolver();
        try {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(RemapUtils.class.getClassLoader().getResourceAsStream("mappings/spigot2srg-1.20.srg"))), null, null, false);
        }
        catch (Exception e) {
            System.out.println("debug: error loading remaputils");
            e.printStackTrace();
        }
        File dir = new File("mappings");
        dir.mkdirs();
        try {
            LOGGER.info("Exporting Mojang Mappings...");
            Path path = RemapUtils.exportResourceMetaInf("reobf.tiny", dir).toPath();
            myMappingResolver = new MyMappingResolver(path, MappingFormat.TINY_2_FILE, "named", "intermediary");
            LOGGER.info("RemapUtils: MyMappingResolver Namespace: " + myMappingResolver.getCurrentRuntimeNamespace());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String bukkit_cl_srg = "bukkit-1.21.10-cl.csrg";
        File bukkit_class_mappings_file = RemapUtils.exportResource(bukkit_cl_srg, dir);
        RemapUtils.jarMapping.classes.put("org/bukkit/craftbukkit/" + NMS_VERSION + "/CraftWorld", "org/cardboardpowered/impl/world/CraftWorld");
        RemapUtils.jarMapping.classes.put("org/bukkit/craftbukkit/block/CraftBlockEntityState", CardboardBlockEntityState.class.getName().replace('.', '/'));
        RemapUtils.jarMapping.classes.put("org/bukkit/craftbukkit/block/CraftSign", CardboardSign.class.getName().replace('.', '/'));
        RemapUtils.jarMapping.classes.put("net/minecraft/nbt/ListTag", "net/minecraft/class_2499");
        RemapUtils.jarMapping.classes.put("net/minecraft/class_7225$a", "net/minecraft/class_7225$class_7874");
        String namespace = mr.getCurrentRuntimeNamespace();
        RemapUtils.addMethodOverrides();
        try {
            LOGGER.debug("Reading \"" + bukkit_cl_srg + "\".");
            List<String> lines = Files.readAllLines(bukkit_class_mappings_file.toPath());
            int count = 0;
            int total = 0;
            for (String line : lines) {
                if (line.startsWith("# ")) continue;
                String[] spl = line.split(" ");
                String obf_claz = spl[0];
                String spi_claz = spl[1];
                String fab_claz = mr.mapClassName("official", obf_claz.replace('/', '.')).replace('.', '/');
                if (!fab_claz.equals(obf_claz)) {
                    cspigot2fabric.put(spi_claz, fab_claz);
                    cspigot2fabric.put(spi_claz.replace('/', '.'), fab_claz.replace('/', '.'));
                }
                if (spl.length == 3) {
                    // empty if block
                }
                if (!RemapUtils.jarMapping.classes.containsKey(spi_claz)) {
                    jarMapping.registerClassMapping(spi_claz, fab_claz);
                    ++count;
                } else {
                    String key = RemapUtils.jarMapping.classes.get(spi_claz);
                    boolean replace = true;
                    if (namespace.equalsIgnoreCase("named") || replace) {
                        RemapUtils.jarMapping.byNMSSrcName.remove(spi_claz);
                        ClassMapping cam = jarMapping.registerClassMapping(spi_claz, fab_claz);
                        cam.setNmsSrcName(spi_claz);
                        cam.setMcpSrcName(fab_claz);
                        ++count;
                    }
                }
                ++total;
            }
            LOGGER.info("Read " + count + " classes from " + bukkit_cl_srg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new BannerInheritanceProvider());
        jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        jarRemapper = new BannerJarRemapper(jarMapping);
        remappers.add((Remapper)jarRemapper);
        remappers.add(new ReflectRemapper());
        jarMapping.initFastMethodMapping((Remapper)jarRemapper);
        ReflectMethodRemapper.init();
        try {
            Class.forName("com.mohistmc.banner.bukkit.nms.proxy.ProxyMethodHandlesLookup");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        DEBUG_VERBOSE_CALLS = CardboardConfig.DEBUG_VERBOSE_CALLS;
    }

    public static byte[] remapFindClass(byte[] bs) {
        ClassReader reader = new ClassReader(bs);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 8);
        for (Remapper remapper : remappers) {
            ClassNode container = new ClassNode();
            ClassRemapper classRemapper = remapper instanceof ClassRemapperSupplier ? ((ClassRemapperSupplier)remapper).getClassRemapper((ClassVisitor)container) : new ClassRemapper((ClassVisitor)container, remapper);
            classNode.accept((ClassVisitor)classRemapper);
            classNode = container;
        }
        BannerSuperClassRemapper.init(classNode);
        ClassWriter writer = new ClassWriter(0);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static String map(String typeName) {
        String res2;
        String csf;
        boolean isRequestNotInternalName = typeName.indexOf(46) != -1 && typeName.indexOf(47) == -1;
        typeName = RemapUtils.mapPackage(typeName);
        String res = RemapUtils.jarMapping.classes.getOrDefault(typeName, typeName);
        if (cspigot2fabric.containsKey(typeName) && (csf = cspigot2fabric.get(typeName)).contains("class_")) {
            typeName = csf;
        }
        if (res.equalsIgnoreCase(typeName) && (res2 = myMappingResolver.mapClassName("named", res.replace('/', '.')).replace('.', '/')).contains("class_")) {
            res = res2;
        }
        if (typeName.contains("$") && typeName.contains("net") && typeName.contains("minecraft")) {
            String res22;
            if (!typeName.equalsIgnoreCase(res)) {
                return res;
            }
            String[] spl = typeName.split(Pattern.quote("$"));
            String nam1 = spl[0];
            String res1 = RemapUtils.jarMapping.classes.getOrDefault(nam1, nam1);
            if (res1.equalsIgnoreCase(nam1) && (res22 = myMappingResolver.mapClassName("named", res1.replace('/', '.')).replace('.', '/')).contains("class_")) {
                res1 = res22;
            }
            if (spl[1].contains("class_")) {
                return res;
            }
            String unnam = mr.unmapClassName("official", res1.replace('/', '.'));
            String namm = mr.mapClassName("official", (unnam + "$" + spl[1]).replace('/', '.'));
            if (res.indexOf(47) != -1) {
                namm = namm.replace('.', '/');
            }
            if (isRequestNotInternalName) {
                namm = namm.replace('/', '.');
            }
            return namm;
        }
        if (isRequestNotInternalName) {
            res = res.replace('/', '.');
        }
        return res;
    }

    public static String reverseMap(String typeName) {
        ClassMapping mapping = RemapUtils.jarMapping.byNMSInternalName.get(typeName);
        return mapping == null ? typeName : mapping.getNmsSrcName();
    }

    public static String reverseMap(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? ASMUtils.toInternalName(clazz) : mapping.getNmsSrcName();
    }

    public static String reverseMap_name(String class_name) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(class_name);
        return mapping == null ? ASMUtils.toInternalName(class_name) : mapping.getNmsSrcName();
    }

    public static String mapPackage(String typeName) {
        for (Map.Entry<String, String> entry : RemapUtils.jarMapping.packages.entrySet()) {
            String prefix = entry.getKey();
            if (!typeName.startsWith(prefix)) continue;
            return entry.getValue() + typeName.substring(prefix.length());
        }
        return typeName;
    }

    public static String remapMethodDesc(String methodDescriptor) {
        org.objectweb.asm.Type rt = org.objectweb.asm.Type.getReturnType((String)methodDescriptor);
        org.objectweb.asm.Type[] ts = org.objectweb.asm.Type.getArgumentTypes((String)methodDescriptor);
        rt = org.objectweb.asm.Type.getType((String)ASMUtils.toDescriptorV2(RemapUtils.map(ASMUtils.getInternalName(rt))));
        for (int i = 0; i < ts.length; ++i) {
            ts[i] = org.objectweb.asm.Type.getType((String)ASMUtils.toDescriptorV2(RemapUtils.map(ASMUtils.getInternalName(ts[i]))));
        }
        return org.objectweb.asm.Type.getMethodType((org.objectweb.asm.Type)rt, (org.objectweb.asm.Type[])ts).getDescriptor();
    }

    public static String mapMethodName(Class<?> clazz, String name, MethodType methodType) {
        return RemapUtils.mapMethodName(clazz, name, methodType.parameterArray());
    }

    private static void addMethodOverrides() {
        methodExtra.put("class_2960.fromNamespaceAndPath(java.lang.String, java.lang.String)", "method_60655");
        methodExtra.put("class_2378.wrapAsHolder(java.lang.Object)", "method_47983");
        methodExtra.put("class_2629.c(net.minecraft.class_1259)", "method_34096");
    }

    private static String parameterTypes(Class<?> ... parameterTypes) {
        Object mm = "";
        for (Class<?> pt : parameterTypes) {
            mm = (String)mm + ", " + pt.getName();
        }
        if (((String)(mm = (String)mm + ")")).length() > 2) {
            mm = ((String)mm).substring(2);
        }
        mm = "(" + (String)mm;
        return mm;
    }

    public static String getMethodDescriptor(Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> param : parameterTypes) {
            sb.append(RemapUtils.getDescriptor(param));
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getDescriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        } else {
            if (clazz.isArray()) {
                return clazz.getName().replace('.', '/');
            }
            return "L" + clazz.getName().replace('.', '/') + ";";
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(clazz));
    }

    public static String mapMethodName(Class<?> type, String name, Class<?> ... parameterTypes) {
        String cl;
        String cll;
        String match;
        Object mm = "";
        for (Class<?> pt : parameterTypes) {
            mm = (String)mm + ", " + pt.getName();
        }
        if (((String)(mm = (String)mm + ")")).length() > 2) {
            mm = ((String)mm).substring(2);
        }
        mm = "(" + (String)mm;
        String res = jarMapping.fastMapMethodName(type, name, parameterTypes);
        if (res.length() <= 2 && (match = RemapUtils.find_meth(cll = mr.unmapClassName("official", cl = type.getName()), type, name, parameterTypes)).contains("method_")) {
            if (CardboardConfig.DEBUG_LOG_REMAP) {
                LOGGER.info("mapMethodNameA: " + type.getName() + "." + name + " -> " + match + " " + (String)mm);
            }
            return match;
        }
        if (DEBUG_VERBOSE_CALLS) {
            System.out.println("Reflection: " + type.getName() + " / " + res);
        }
        if (!res.contains("method_")) {
            String key = type.getSimpleName() + "." + res + (String)mm;
            if (methodExtra.containsKey(key)) {
                res = methodExtra.get(key);
            }
            if (name.equalsIgnoreCase(res) && type.getName().contains("class_")) {
                String nam2;
                String desc = RemapUtils.getMethodDescriptor(parameterTypes);
                String clazz = myMappingResolver.unmapClassName("named", type.getName());
                String mapp = myMappingResolver.mapMethodNameSafe("named", clazz, res, desc, "intermediary");
                if (mapp.equalsIgnoreCase(res)) {
                    mapp = myMappingResolver.mapMethodName("named", clazz, res, desc);
                }
                if (mapp.contains("method_") || mapp.contains("comp_")) {
                    return mapp;
                }
                Class<?> superCl = type.getSuperclass();
                if (null != superCl && ((nam2 = RemapUtils.mapMethodName_2(superCl, res, mapp, desc)).contains("method_") || nam2.contains("comp_"))) {
                    return nam2;
                }
            }
        }
        if (CardboardConfig.DEBUG_LOG_REMAP) {
            LOGGER.info("mapMethodNameB: " + type.getName() + "." + name + " -> " + res + " " + (String)mm);
        }
        return res;
    }

    public static String mapMethodName_2(Class<?> type, String name, String res, String desc) {
        String clazz = myMappingResolver.unmapClassName("named", type.getName());
        String mapp = myMappingResolver.mapMethodNameSafe("named", clazz, res, desc, "intermediary");
        if (mapp.equalsIgnoreCase(res)) {
            mapp = myMappingResolver.mapMethodName("named", clazz, res, desc);
        }
        if (mapp.contains("method_") || mapp.contains("comp_")) {
            return mapp;
        }
        return res;
    }

    public static String find_meth(String obfClaz, Class<?> type, String name, Class<?> ... parameterTypes) {
        System.out.println("FINDING MATCH FOR: " + obfClaz + "." + name);
        for (Method m : type.getDeclaredMethods()) {
            int pc = m.getParameterCount();
            if (parameterTypes.length != pc) continue;
            try {
                String desc = RemapUtils.getMethodDescriptor(m, "official");
                String mmm = mr.mapMethodName("official", obfClaz, name, desc);
                if (!mmm.contains("method_")) continue;
                return mmm;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return name;
    }

    public static String inverseMapMethodName(Class<?> type, String name, Class<?> ... parameterTypes) {
        return jarMapping.fastReverseMapMethodName(type, name, parameterTypes);
    }

    public static String mapFieldName(Class<?> type, String fieldName) {
        String clazz;
        String mapp;
        String res;
        Class<?> superClass;
        String key;
        String mapped;
        if (DEBUG_VERBOSE_CALLS) {
            System.out.println("Reflection: " + type.getName() + " / " + fieldName);
        }
        if ((mapped = RemapUtils.jarMapping.fields.get(key = RemapUtils.reverseMap(type) + "/" + fieldName)) == null && (superClass = type.getSuperclass()) != null) {
            mapped = RemapUtils.mapFieldName(superClass, fieldName);
        }
        String string = res = mapped != null ? mapped : fieldName;
        if (DEBUG_VERBOSE_CALLS) {
            System.out.println("DEBUG: FIELD: " + type.getName() + " / " + fieldName + " = " + (mapped != null ? mapped : fieldName));
        }
        if (fieldName.equalsIgnoreCase(res) && type.getName().contains("class_") && ((mapp = myMappingResolver.mapFieldName("named", clazz = myMappingResolver.unmapClassName("named", type.getName()), fieldName, null)).contains("field_") || mapp.contains("comp_"))) {
            return mapp;
        }
        return mapped != null ? mapped : fieldName;
    }

    public static String inverseMapFieldName(Class<?> type, String fieldName) {
        return jarMapping.fastReverseMapFieldName(type, fieldName);
    }

    public static String inverseMapName(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getName() : mapping.getNmsName();
    }

    public static String inverseMapSimpleName(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getSimpleName() : mapping.getNmsSimpleName();
    }

    public static boolean isNMSClass(String className) {
        return className.startsWith("net.minecraft.");
    }

    public static boolean needRemap(String className) {
        return className.startsWith("net.minecraft.");
    }

    public static String getMethodDescriptor(Method method, String name) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append("(");
        for (Type parameterType : method.getGenericParameterTypes()) {
            descriptor.append(RemapUtils.getTypeDescriptor(parameterType, name));
        }
        descriptor.append(")");
        descriptor.append(RemapUtils.getTypeDescriptor(method.getGenericReturnType(), name));
        return descriptor.toString();
    }

    private static String getTypeDescriptor(Type parameterType, String name) {
        if (parameterType instanceof Class) {
            return RemapUtils.getClassDescriptor((Class)parameterType, name);
        }
        if (parameterType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameterType;
            StringBuilder descriptor = new StringBuilder();
            descriptor.append(RemapUtils.getClassDescriptor((Class)parameterizedType.getRawType(), name));
            for (Type arg : parameterizedType.getActualTypeArguments()) {
                descriptor.append(RemapUtils.getTypeDescriptor(arg, name));
            }
            return descriptor.toString();
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(parameterType));
    }

    private static String getClassDescriptor(Class<?> clazz, String name) {
        if (clazz.isArray()) {
            return "[" + RemapUtils.getClassDescriptor(clazz.getComponentType(), name);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        } else {
            if (!name.isEmpty()) {
                String ll = mr.unmapClassName(name, clazz.getName().replace('/', '.'));
                return "L" + ll.replace('.', '/') + ";";
            }
            return "L" + clazz.getName().replace('.', '/') + ";";
        }
        throw new IllegalArgumentException("Unsupported class: " + String.valueOf(clazz));
    }

    static {
        remappers = new ArrayList<Remapper>();
        DEBUG_VERBOSE_CALLS = true;
        NMS_VERSION = "v1_21_R6";
        cspigot2fabric = new HashMap();
        mr = FabricLoader.getInstance().getMappingResolver();
        methodExtra = new HashMap();
    }
}

