/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.pluginremap;

import io.papermc.paper.pluginremap.PluginRemapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
final class DebugLogger
implements Consumer<String>,
AutoCloseable {
    private final @Nullable PrintWriter writer;

    DebugLogger(Path logFile) {
        try {
            this.writer = DebugLogger.createWriter(logFile);
        }
        catch (IOException var3) {
            throw new RuntimeException("Failed to initialize DebugLogger for file '" + String.valueOf(logFile) + "'", var3);
        }
    }

    @Override
    public void accept(String line) {
        this.useWriter(writer -> writer.println(line));
    }

    @Override
    public void close() {
        this.useWriter(PrintWriter::close);
    }

    private void useWriter(Consumer<PrintWriter> op) {
        PrintWriter writer = this.writer;
        if (writer != null) {
            op.accept(writer);
        }
    }

    Consumer<String> debug() {
        return line -> this.accept("[debug]: " + line);
    }

    static DebugLogger forOutputFile(Path outputFile) {
        return new DebugLogger(outputFile.resolveSibling(String.valueOf(outputFile.getFileName()) + ".log"));
    }

    private static @Nullable PrintWriter createWriter(Path logFile) throws IOException {
        if (!PluginRemapper.DEBUG_LOGGING) {
            return null;
        }
        if (!Files.exists(logFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        }
        return new PrintWriter(logFile.toFile());
    }
}

