/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.pluginremap;

import io.papermc.paper.pluginremap.DebugLogger;
import io.papermc.paper.pluginremap.InsertManifestAttribute;
import io.papermc.paper.pluginremap.PluginRemapper;
import io.papermc.paper.util.AtomicFiles;
import io.papermc.paper.util.MappingEnvironment;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_3222;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.Transformer;
import net.neoforged.art.internal.RenamerImpl;
import net.neoforged.srgutils.IMappingFile;
import org.cardboardpowered.CardboardLogger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;
import org.spongepowered.configurate.util.CheckedConsumer;

@DefaultQualifier(value=NonNull.class)
final class ReobfServer {
    private static final Logger LOGGER = CardboardLogger.getSLF4J();
    private final Path remapClasspathDir;
    private final CompletableFuture<Void> load;

    ReobfServer(Path remapClasspathDir, CompletableFuture<IMappingFile> mappings, Executor executor) {
        this.remapClasspathDir = remapClasspathDir;
        if (this.mappingsChanged()) {
            this.load = mappings.thenAcceptAsync(this::remap, executor);
        } else {
            if (PluginRemapper.DEBUG_LOGGING) {
                LOGGER.info("Have cached reobf server for current mappings.");
            }
            this.load = CompletableFuture.completedFuture(null);
        }
    }

    CompletableFuture<Path> remapped() {
        return this.load.thenApply($ -> this.remappedPath());
    }

    private Path remappedPath() {
        return this.remapClasspathDir.resolve(MappingEnvironment.mappingsHash() + ".jar");
    }

    private boolean mappingsChanged() {
        return !Files.exists(this.remappedPath(), new LinkOption[0]);
    }

    private void remap(IMappingFile mappings) {
        try {
            if (!Files.exists(this.remapClasspathDir, new LinkOption[0])) {
                Files.createDirectories(this.remapClasspathDir, new FileAttribute[0]);
            }
            for (Path file : PluginRemapper.list(this.remapClasspathDir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
                Files.delete(file);
            }
        }
        catch (IOException var10) {
            throw new RuntimeException(var10);
        }
        LOGGER.info("Remapping server...");
        long startRemap = System.currentTimeMillis();
        try (DebugLogger log = DebugLogger.forOutputFile(this.remappedPath());){
            AtomicFiles.atomicWrite(this.remappedPath(), (CheckedConsumer<Path, IOException>)((CheckedConsumer)writeTo -> {
                try (RenamerImpl renamer = (RenamerImpl)Renamer.builder().logger((Consumer)log).debug(log.debug()).threads(1).add(Transformer.renamerFactory((IMappingFile)mappings, (boolean)false)).add(InsertManifestAttribute.addNamespaceManifestAttribute("spigot")).build();){
                    renamer.run(ReobfServer.serverJar().toFile(), writeTo.toFile(), true);
                }
            }));
        }
        catch (Exception var9) {
            throw new RuntimeException("Failed to remap server jar", var9);
        }
        LOGGER.info("Done remapping server in {}ms.", (Object)(System.currentTimeMillis() - startRemap));
    }

    private static Path serverJar() {
        try {
            Class<class_3222> cl = class_3222.class;
            Path path = Path.of(cl.getProtectionDomain().getCodeSource().getLocation().toURI());
            return path;
        }
        catch (URISyntaxException var1) {
            throw new RuntimeException(var1);
        }
    }
}

