/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9323;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public class PaperEnchantmentRegistryEntry
implements EnchantmentRegistryEntry {
    protected @Nullable class_2561 description;
    protected @Nullable class_6885<class_1792> supportedItems;
    protected @Nullable class_6885<class_1792> primaryItems;
    protected OptionalInt weight = OptionalInt.empty();
    protected OptionalInt maxLevel = OptionalInt.empty();
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_1887.class_9426 minimumCost;
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_1887.class_9426 maximumCost;
    protected OptionalInt anvilCost = OptionalInt.empty();
    protected @Nullable List<class_9274> activeSlots;
    protected class_6885<class_1887> exclusiveWith = class_6885.method_58563();
    protected class_9323 effects;
    protected final Conversions conversions;

    public PaperEnchantmentRegistryEntry(Conversions conversions, @Nullable class_1887 internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.effects = class_9323.field_49584;
            return;
        }
        this.description = internal.comp_2686();
        class_1887.class_9427 definition = internal.comp_2687();
        this.supportedItems = definition.comp_2506();
        this.primaryItems = definition.comp_2507().orElse(null);
        this.weight = OptionalInt.of(definition.comp_2508());
        this.maxLevel = OptionalInt.of(definition.comp_2509());
        this.minimumCost = definition.comp_2510();
        this.maximumCost = definition.comp_2511();
        this.anvilCost = OptionalInt.of(definition.comp_2512());
        this.activeSlots = definition.comp_2513();
        this.exclusiveWith = internal.comp_2688();
        this.effects = internal.comp_2689();
    }

    public Component description() {
        return this.conversions.asAdventure(Checks.asConfigured(this.description, "description"));
    }

    public RegistryKeySet<ItemType> supportedItems() {
        return PaperRegistrySets.convertToApi(RegistryKey.ITEM, Checks.asConfigured(this.supportedItems, "supportedItems"));
    }

    public @Nullable RegistryKeySet<ItemType> primaryItems() {
        return this.primaryItems == null ? null : PaperRegistrySets.convertToApi(RegistryKey.ITEM, this.primaryItems);
    }

    public @Range(from=1L, to=1024L) int weight() {
        return Checks.asConfigured(this.weight, "weight");
    }

    public @Range(from=1L, to=255L) int maxLevel() {
        return Checks.asConfigured(this.maxLevel, "maxLevel");
    }

    public EnchantmentRegistryEntry.EnchantmentCost minimumCost() {
        class_1887.class_9426 cost = Checks.asConfigured(this.minimumCost, "minimumCost");
        return EnchantmentRegistryEntry.EnchantmentCost.of((int)cost.comp_2504(), (int)cost.comp_2690());
    }

    public EnchantmentRegistryEntry.EnchantmentCost maximumCost() {
        class_1887.class_9426 cost = Checks.asConfigured(this.maximumCost, "maximumCost");
        return EnchantmentRegistryEntry.EnchantmentCost.of((int)cost.comp_2504(), (int)cost.comp_2690());
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int anvilCost() {
        return Checks.asConfigured(this.anvilCost, "anvilCost");
    }

    public List<EquipmentSlotGroup> activeSlots() {
        return Collections.unmodifiableList(Lists.transform(Checks.asConfigured(this.activeSlots, "activeSlots"), CraftEquipmentSlot::getSlot));
    }

    public RegistryKeySet<Enchantment> exclusiveWith() {
        return PaperRegistrySets.convertToApi(RegistryKey.ENCHANTMENT, this.exclusiveWith);
    }

    public static final class PaperBuilder
    extends PaperEnchantmentRegistryEntry
    implements EnchantmentRegistryEntry.Builder,
    PaperRegistryBuilder<class_1887, Enchantment> {
        public PaperBuilder(Conversions conversions, @Nullable class_1887 internal) {
            super(conversions, internal);
        }

        public EnchantmentRegistryEntry.Builder description(Component description) {
            this.description = this.conversions.asVanilla(Checks.asArgument(description, "description"));
            return this;
        }

        public EnchantmentRegistryEntry.Builder supportedItems(RegistryKeySet<ItemType> supportedItems) {
            this.supportedItems = PaperRegistrySets.convertToNms(class_7924.field_41197, this.conversions.lookup(), Checks.asArgument(supportedItems, "supportedItems"));
            return this;
        }

        public EnchantmentRegistryEntry.Builder primaryItems(@Nullable RegistryKeySet<ItemType> primaryItems) {
            this.primaryItems = primaryItems == null ? null : PaperRegistrySets.convertToNms(class_7924.field_41197, this.conversions.lookup(), primaryItems);
            return this;
        }

        public EnchantmentRegistryEntry.Builder weight(@Range(from=1L, to=1024L) int weight) {
            this.weight = OptionalInt.of(Checks.asArgumentRange(weight, "weight", 1, 1024));
            return this;
        }

        public EnchantmentRegistryEntry.Builder maxLevel(@Range(from=1L, to=255L) int maxLevel) {
            this.maxLevel = OptionalInt.of(Checks.asArgumentRange(maxLevel, "maxLevel", 1, 255));
            return this;
        }

        public EnchantmentRegistryEntry.Builder minimumCost(EnchantmentRegistryEntry.EnchantmentCost minimumCost) {
            EnchantmentRegistryEntry.EnchantmentCost validCost = Checks.asArgument(minimumCost, "minimumCost");
            this.minimumCost = class_1887.method_58441((int)validCost.baseCost(), (int)validCost.additionalPerLevelCost());
            return this;
        }

        public EnchantmentRegistryEntry.Builder maximumCost(EnchantmentRegistryEntry.EnchantmentCost maximumCost) {
            EnchantmentRegistryEntry.EnchantmentCost validCost = Checks.asArgument(maximumCost, "maximumCost");
            this.maximumCost = class_1887.method_58441((int)validCost.baseCost(), (int)validCost.additionalPerLevelCost());
            return this;
        }

        public EnchantmentRegistryEntry.Builder anvilCost(@Range(from=0L, to=0x7FFFFFFFL) int anvilCost) {
            Preconditions.checkArgument((anvilCost >= 0 ? 1 : 0) != 0, (Object)"anvilCost must be non-negative");
            this.anvilCost = OptionalInt.of(Checks.asArgumentMin(anvilCost, "anvilCost", 0));
            return this;
        }

        public EnchantmentRegistryEntry.Builder activeSlots(Iterable<EquipmentSlotGroup> activeSlots) {
            this.activeSlots = Lists.newArrayList((Iterable)Iterables.transform(Checks.asArgument(activeSlots, "activeSlots"), CraftEquipmentSlot::getNMSGroup));
            return this;
        }

        public EnchantmentRegistryEntry.Builder exclusiveWith(RegistryKeySet<Enchantment> exclusiveWith) {
            this.exclusiveWith = PaperRegistrySets.convertToNms(class_7924.field_41265, this.conversions.lookup(), Checks.asArgument(exclusiveWith, "exclusiveWith"));
            return this;
        }

        @Override
        public class_1887 build() {
            class_1887.class_9427 def = new class_1887.class_9427(Checks.asConfigured(this.supportedItems, "supportedItems"), Optional.ofNullable(this.primaryItems), this.weight(), this.maxLevel(), Checks.asConfigured(this.minimumCost, "minimumCost"), Checks.asConfigured(this.maximumCost, "maximumCost"), this.anvilCost(), Collections.unmodifiableList(Checks.asConfigured(this.activeSlots, "activeSlots")));
            return new class_1887(Checks.asConfigured(this.description, "description"), def, this.exclusiveWith, this.effects);
        }
    }
}

