/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import com.mojang.datafixers.util.Either;
import io.papermc.paper.util.MCUtil;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_6880;
import org.bukkit.NamespacedKey;

public final class RegistryTypeMapper<M, A> {
    final Either<Function<class_6880<M>, ? extends A>, BiFunction<? super NamespacedKey, M, ? extends A>> minecraftToBukkit;
    private final boolean supportsDirectHolders;

    private static <M, A> Function<class_6880<M>, ? extends A> wrap(BiFunction<? super NamespacedKey, M, ? extends A> byValueCreator) {
        return holder -> {
            if (!(holder instanceof class_6880.class_6883)) {
                throw new IllegalArgumentException("This type does not support direct holders: " + String.valueOf(holder));
            }
            class_6880.class_6883 reference = (class_6880.class_6883)holder;
            return byValueCreator.apply(MCUtil.fromResourceKey(reference.method_40237()), reference.comp_349());
        };
    }

    public RegistryTypeMapper(BiFunction<? super NamespacedKey, M, ? extends A> byValueCreator) {
        this.minecraftToBukkit = Either.right(byValueCreator);
        this.supportsDirectHolders = false;
    }

    public RegistryTypeMapper(Function<class_6880<M>, ? extends A> byHolderCreator, boolean supportsDirectHolders) {
        this.minecraftToBukkit = Either.left(byHolderCreator);
        this.supportsDirectHolders = supportsDirectHolders;
    }

    public A createBukkit(class_6880<M> minecraft) {
        return (A)((Function)this.minecraftToBukkit.map(Function.identity(), RegistryTypeMapper::wrap)).apply(minecraft);
    }

    public boolean supportsDirectHolders() {
        return this.supportsDirectHolders;
    }

    public boolean constructorUsesHolder() {
        return this.minecraftToBukkit.left().isPresent();
    }
}

