/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScalingThreadPool {
    private ScalingThreadPool() {
    }

    public static RejectedExecutionHandler defaultReEnqueuePolicy() {
        return ScalingThreadPool.reEnqueuePolicy(new ThreadPoolExecutor.AbortPolicy());
    }

    public static RejectedExecutionHandler reEnqueuePolicy(RejectedExecutionHandler original) {
        return new ReEnqueuePolicy(original);
    }

    public static <E> BlockingQueue<E> createUnboundedQueue() {
        return new Queue();
    }

    public static <E> BlockingQueue<E> createQueue(int capacity) {
        return new Queue(capacity);
    }

    private record ReEnqueuePolicy(RejectedExecutionHandler originalHandler) implements RejectedExecutionHandler
    {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.getQueue().add(r)) {
                this.originalHandler.rejectedExecution(r, executor);
            }
        }
    }

    private static final class Queue<E>
    extends LinkedBlockingQueue<E> {
        private final AtomicInteger idleThreads = new AtomicInteger(0);

        private Queue() {
        }

        private Queue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(E e) {
            return this.idleThreads.get() > 0 && super.offer(e);
        }

        @Override
        public E take() throws InterruptedException {
            Object var1;
            this.idleThreads.incrementAndGet();
            try {
                var1 = super.take();
            }
            finally {
                this.idleThreads.decrementAndGet();
            }
            return var1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E poll(long timeout, TimeUnit unit) throws InterruptedException {
            Object var4;
            this.idleThreads.incrementAndGet();
            try {
                var4 = super.poll(timeout, unit);
            }
            finally {
                this.idleThreads.decrementAndGet();
            }
            return var4;
        }

        @Override
        public boolean add(E e) {
            return super.offer(e);
        }
    }
}

