/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import com.google.common.io.Files;
import com.mojang.serialization.Dynamic;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.class_2378;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_34;
import net.minecraft.class_3807;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7225;
import net.minecraft.class_7237;
import net.minecraft.class_7712;
import net.minecraft.class_7924;
import net.minecraft.class_8579;
import net.minecraft.class_8909;
import net.minecraft.class_8911;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.cardboardpowered.interfaces.ILevelProperties;
import org.cardboardpowered.interfaces.ILevelStorage;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PaperWorldLoader(MinecraftServer server, String levelId) {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Cardboard|PaperWorldLoader");

    public static PaperWorldLoader create(MinecraftServer server, String levelId) {
        return new PaperWorldLoader(server, levelId);
    }

    private WorldLoadingInfo getWorldInfo(String levelId, class_5363 stem) {
        class_5321 stemKey = (class_5321)this.server.method_30611().method_30530(class_7924.field_41224).method_29113((Object)stem).orElseThrow();
        int dimension = 0;
        boolean enabled = true;
        if (stemKey == class_5363.field_25413) {
            dimension = -1;
            enabled = CraftServer.INSTANCE.getAllowNether();
        } else if (stemKey == class_5363.field_25414) {
            dimension = 1;
            enabled = CraftServer.INSTANCE.getAllowEnd();
        } else if (stemKey != class_5363.field_25412) {
            dimension = -999;
        }
        String worldType = dimension == -999 ? stemKey.method_29177().method_12836() + "_" + stemKey.method_29177().method_12832() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
        String name = stemKey == class_5363.field_25412 ? levelId : levelId + "_" + worldType;
        return new WorldLoadingInfo(dimension, name, worldType, (class_5321<class_5363>)stemKey, enabled);
    }

    public static Path LevelStorage_getStorageFolder(Path path, class_5321<class_5363> dimensionType) {
        if (dimensionType == class_5363.field_25412) {
            return path;
        }
        if (dimensionType == class_5363.field_25413) {
            return path.resolve("DIM-1");
        }
        return dimensionType == class_5363.field_25414 ? path.resolve("DIM1") : path.resolve("dimensions").resolve(dimensionType.method_29177().method_12836()).resolve(dimensionType.method_29177().method_12832());
    }

    private void migrateWorldFolder(WorldLoadingInfo info) {
        if (info.dimension() != 0) {
            File newWorld = PaperWorldLoader.LevelStorage_getStorageFolder(new File(info.name()).toPath(), info.stemKey()).toFile();
            File oldWorld = PaperWorldLoader.LevelStorage_getStorageFolder(new File(this.levelId).toPath(), info.stemKey()).toFile();
            File oldLevelDat = new File(new File(this.levelId), "level.dat");
            if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                LOGGER.info("---- Migration of old " + info.worldType() + " folder required ----");
                LOGGER.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + info.worldType() + " folder to a new location in order to operate correctly.");
                LOGGER.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                LOGGER.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                if (newWorld.exists()) {
                    LOGGER.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                    LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
                } else if (newWorld.getParentFile().mkdirs()) {
                    if (oldWorld.renameTo(newWorld)) {
                        LOGGER.info("Success! To restore " + info.worldType() + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                        try {
                            Files.copy((File)oldLevelDat, (File)new File(new File(info.name()), "level.dat"));
                            FileUtils.copyDirectory((File)new File(new File(this.levelId), "data"), (File)new File(new File(info.name()), "data"));
                        }
                        catch (IOException var6) {
                            LOGGER.warn("Unable to migrate world data.");
                        }
                        LOGGER.info("---- Migration of old " + info.worldType() + " folder complete ----");
                    } else {
                        LOGGER.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                        LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
                    }
                } else {
                    LOGGER.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                    LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
                }
            }
        }
    }

    public void loadInitialWorlds() {
        MinecraftServer mc = this.server;
        for (class_5363 stem : this.server.method_30611().method_30530(class_7924.field_41224)) {
            WorldLoadingInfo info = this.getWorldInfo(this.levelId, stem);
            this.migrateWorldFolder(info);
            if (!info.enabled()) continue;
            class_32.class_5143 levelStorageAccess = this.server.getSessionBF();
            if (info.dimension() != 0) {
                try {
                    levelStorageAccess = ((ILevelStorage)class_32.method_26999((Path)CraftServer.INSTANCE.getWorldContainer().toPath())).validateAndCreateAccess(info.name(), info.stemKey());
                }
                catch (IOException | class_8579 var7) {
                    throw new RuntimeException(var7);
                }
            }
            LevelDataResult levelData = PaperWorldLoader.getLevelData(levelStorageAccess);
            if (levelData.fatalError) {
                return;
            }
            class_31 primaryLevelData = levelData.dataTag == null ? (class_31)Main.method_74054((class_3807)((class_3176)this.server).field_16799, (class_7237.class_7660)mc.cardboard$worldLoaderContext(), (class_2378)mc.cardboard$worldLoaderContext().comp_990().method_30530(class_7924.field_41224), (boolean)this.server.method_3799(), (boolean)true).comp_991() : (class_31)class_32.method_54523(levelData.dataTag, (class_7712)mc.cardboard$worldLoaderContext().comp_988(), (class_2378)mc.cardboard$worldLoaderContext().comp_990().method_30530(class_7924.field_41224), (class_7225.class_7874)mc.cardboard$worldLoaderContext().comp_989()).comp_2008();
            ((ILevelProperties)primaryLevelData).checkName(info.name());
            primaryLevelData.method_24285(this.server.getServerModName(), this.server.method_24307().method_39029());
            this.server.createLevel(stem, info, levelStorageAccess, primaryLevelData);
        }
        ((class_3176)this.server).method_27731();
        for (class_3218 serverLevel : this.server.method_3738()) {
            mc.cardboard$prepareLevel(serverLevel);
        }
    }

    public static LevelDataResult getLevelData(class_32.class_5143 levelStorageAccess) {
        if (levelStorageAccess.method_54547()) {
            class_34 summary;
            Dynamic dataTag;
            try {
                dataTag = levelStorageAccess.method_54545();
                summary = levelStorageAccess.method_29584(dataTag);
            }
            catch (IOException | class_8909 | class_8911 var7) {
                class_32.class_7411 levelDirectory = levelStorageAccess.method_54543();
                LOGGER.warn("Failed to load world data from {}", (Object)levelDirectory.method_43425(), (Object)var7);
                LOGGER.info("Attempting to use fallback");
                try {
                    dataTag = levelStorageAccess.method_54546();
                    summary = levelStorageAccess.method_29584(dataTag);
                }
                catch (IOException | class_8909 | class_8911 var6) {
                    LOGGER.error("Failed to load world data from {}", (Object)levelDirectory.method_43426(), (Object)var6);
                    LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.method_43425(), (Object)levelDirectory.method_43426());
                    return new LevelDataResult(null, true);
                }
                levelStorageAccess.method_54548();
            }
            if (summary.method_255()) {
                LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return new LevelDataResult(null, true);
            }
            if (!summary.method_38496()) {
                LOGGER.info("This world was created by an incompatible version.");
                return new LevelDataResult(null, true);
            }
            return new LevelDataResult(dataTag, false);
        }
        return new LevelDataResult(null, false);
    }

    public record WorldLoadingInfo(int dimension, String name, String worldType, class_5321<class_5363> stemKey, boolean enabled) {
    }

    public record LevelDataResult(@Nullable Dynamic<?> dataTag, boolean fatalError) {
    }
}

