/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.damagesource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.world.damagesource.CombatEntry;
import io.papermc.paper.world.damagesource.CombatTracker;
import io.papermc.paper.world.damagesource.FallLocationType;
import io.papermc.paper.world.damagesource.PaperCombatEntryWrapper;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1281;
import net.minecraft.class_1283;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_8144;
import net.minecraft.class_8572;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record PaperCombatTrackerWrapper(class_1283 handle) implements CombatTracker
{
    private static final BiMap<class_8572, FallLocationType> FALL_LOCATION_MAPPING = (BiMap)class_156.method_656(() -> {
        HashBiMap map = HashBiMap.create((int)8);
        map.put((Object)class_8572.field_44923, (Object)FallLocationType.GENERIC);
        map.put((Object)class_8572.field_44924, (Object)FallLocationType.LADDER);
        map.put((Object)class_8572.field_44925, (Object)FallLocationType.VINES);
        map.put((Object)class_8572.field_44926, (Object)FallLocationType.WEEPING_VINES);
        map.put((Object)class_8572.field_44927, (Object)FallLocationType.TWISTING_VINES);
        map.put((Object)class_8572.field_44928, (Object)FallLocationType.SCAFFOLDING);
        map.put((Object)class_8572.field_44929, (Object)FallLocationType.OTHER_CLIMBABLE);
        map.put((Object)class_8572.field_44930, (Object)FallLocationType.WATER);
        return map;
    });

    public LivingEntity getEntity() {
        return (LivingEntity)this.handle.field_5877.getBukkitEntity();
    }

    public List<CombatEntry> getCombatEntries() {
        ArrayList<CombatEntry> combatEntries = new ArrayList<CombatEntry>(this.handle.field_5870.size());
        this.handle.field_5870.forEach(combatEntry -> combatEntries.add(new PaperCombatEntryWrapper((class_1281)combatEntry)));
        return combatEntries;
    }

    public void setCombatEntries(List<CombatEntry> combatEntries) {
        this.handle.field_5870.clear();
        combatEntries.forEach(combatEntry -> this.handle.field_5870.add(((PaperCombatEntryWrapper)combatEntry).handle()));
    }

    public @Nullable CombatEntry computeMostSignificantFall() {
        class_1281 combatEntry = this.handle.method_5544();
        return combatEntry == null ? null : new PaperCombatEntryWrapper(combatEntry);
    }

    public boolean isInCombat() {
        return this.handle.field_5874;
    }

    public boolean isTakingDamage() {
        return this.handle.field_5872;
    }

    public int getCombatDuration() {
        return this.handle.method_5546();
    }

    public void addCombatEntry(CombatEntry combatEntry) {
        class_1281 entry = ((PaperCombatEntryWrapper)combatEntry).handle();
    }

    public Component getDeathMessage() {
        return PaperAdventure.asAdventure(this.handle.method_5548());
    }

    public void resetCombatState() {
    }

    public FallLocationType calculateFallLocationType() {
        class_8572 fallLocation = class_8572.method_52195((class_1309)this.handle().field_5877);
        return (FallLocationType)class_8144.method_49077((Object)fallLocation, PaperCombatTrackerWrapper::minecraftToPaper);
    }

    public static class_8572 paperToMinecraft(FallLocationType fallLocationType) {
        class_8572 fallLocation = (class_8572)FALL_LOCATION_MAPPING.inverse().get((Object)fallLocationType);
        if (fallLocation == null) {
            throw new IllegalArgumentException("Unknown fall location type: " + fallLocationType.id());
        }
        return fallLocation;
    }

    public static FallLocationType minecraftToPaper(class_8572 fallLocation) {
        FallLocationType fallLocationType = (FallLocationType)FALL_LOCATION_MAPPING.get((Object)fallLocation);
        if (fallLocationType == null) {
            throw new IllegalArgumentException("Unknown fall location: " + fallLocation.comp_1539());
        }
        return fallLocationType;
    }
}

