/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.flag;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.papermc.paper.world.flag.FeatureDependant;
import io.papermc.paper.world.flag.FeatureFlagProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1928;
import net.minecraft.class_7695;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import org.bukkit.FeatureFlag;
import org.bukkit.GameRule;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;

public class PaperFeatureFlagProviderImpl
implements FeatureFlagProvider {
    public static final BiMap<FeatureFlag, class_7696> FLAGS = ImmutableBiMap.of((Object)FeatureFlag.MINECART_IMPROVEMENTS, (Object)class_7701.field_52556, (Object)FeatureFlag.REDSTONE_EXPERIMENTS, (Object)class_7701.field_52555, (Object)FeatureFlag.TRADE_REBALANCE, (Object)class_7701.field_45142, (Object)FeatureFlag.VANILLA, (Object)class_7701.field_40177);

    public Set<FeatureFlag> requiredFeatures(FeatureDependant dependant) {
        class_7699 requiredFeatures = PaperFeatureFlagProviderImpl.getFeatureElement(dependant).method_45322();
        return PaperFeatureFlagProviderImpl.fromNms(requiredFeatures);
    }

    public static Set<FeatureFlag> fromNms(class_7699 flagSet) {
        HashSet<FeatureFlag> flags = new HashSet<FeatureFlag>();
        for (class_7696 nmsFlag : class_7701.field_40180.field_40167.values()) {
            if (!flagSet.method_45403(nmsFlag)) continue;
            flags.add((FeatureFlag)FLAGS.inverse().get((Object)nmsFlag));
        }
        return Collections.unmodifiableSet(flags);
    }

    static class_7695 getFeatureElement(FeatureDependant dependant) {
        if (dependant instanceof EntityType) {
            EntityType entityType = (EntityType)dependant;
            return CraftEntityType.bukkitToMinecraft(entityType);
        }
        if (dependant instanceof PotionType) {
            PotionType potionType = (PotionType)dependant;
            return CraftPotionType.bukkitToMinecraft(potionType);
        }
        if (dependant instanceof GameRule) {
            GameRule gameRule = (GameRule)dependant;
            return PaperFeatureFlagProviderImpl.asFeatureElement(PaperFeatureFlagProviderImpl.getGameRuleType(gameRule.getName()));
        }
        throw new IllegalArgumentException(String.valueOf(dependant) + " is not a valid feature dependant");
    }

    public static class_7695 asFeatureElement(class_1928.class_4314<?> type) {
        return () -> type.method_61728();
    }

    private static class_1928.class_4314<?> getGameRuleType(String name) {
        for (Map.Entry gameRules : class_1928.field_9197.entrySet()) {
            if (!((class_1928.class_4313)gameRules.getKey()).method_20771().equals(name)) continue;
            return (class_1928.class_4314)gameRules.getValue();
        }
        return null;
    }
}

