/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.format;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.techcable.srglib.format.CompactSrgMappingsFormat;
import net.techcable.srglib.format.SrgMappingsFormat;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.utils.Exceptions;
import net.techcable.srglib.utils.LineProcessor;

public interface MappingsFormat {
    public static final MappingsFormat SEARGE_FORMAT = SrgMappingsFormat.INSTANCE;
    public static final MappingsFormat COMPACT_SEARGE_FORMAT = CompactSrgMappingsFormat.INSTANCE;

    default public Mappings parse(BufferedReader readable) throws IOException {
        String line;
        LineProcessor<Mappings> lineProcessor = this.createLineProcessor();
        while ((line = readable.readLine()) != null && lineProcessor.processLine(line)) {
        }
        return lineProcessor.getResult();
    }

    default public Mappings parseFile(File file) throws IOException {
        return this.parseFile(file.toPath());
    }

    default public Mappings parseFile(Path path) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Mappings mappings = this.parse(in);
            return mappings;
        }
    }

    default public Mappings parseLines(String ... lines) {
        return this.parseLines(Arrays.asList(lines));
    }

    default public Mappings parseLines(Iterable<String> lines) {
        return this.parseLines(lines.iterator());
    }

    default public Mappings parseLines(Iterator<String> lines) {
        LineProcessor<Mappings> lineProcessor = this.createLineProcessor();
        lines.forEachRemaining(Exceptions.sneakyThrowing(lineProcessor::processLine));
        return lineProcessor.getResult();
    }

    public LineProcessor<Mappings> createLineProcessor();

    public void write(Mappings var1, Appendable var2) throws IOException;

    default public void writeToFile(Mappings mappings, File file) throws IOException {
        this.writeToFile(mappings, file.toPath());
    }

    default public void writeToFile(Mappings mappings, Path path) throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(path, StandardOpenOption.WRITE);){
            this.write(mappings, out);
        }
    }

    default public List<String> toLines(Mappings mappings) {
        StringWriter result = new StringWriter();
        return Exceptions.sneakyThrowing(() -> {
            this.write(mappings, result);
            return Stream.of(result.toString().split("\n")).collect(Collectors.toList());
        }).get();
    }
}

