/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.mappings.ImmutableMappings;
import net.techcable.srglib.mappings.RenamingMappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Mappings {
    default public JavaType getNewClass(String original) {
        return this.getNewClass(JavaType.fromName(original));
    }

    public JavaType getNewClass(JavaType var1);

    default public JavaType getNewType(JavaType original) {
        return Objects.requireNonNull(original, "Null type").mapClass(this::getNewClass);
    }

    public MethodData getNewMethod(MethodData var1);

    public FieldData getNewField(FieldData var1);

    default public ImmutableMappings snapshot() {
        return ImmutableMappings.copyOf(this);
    }

    default public Mappings inverted() {
        return this.snapshot().inverted();
    }

    public Set<JavaType> classes();

    public Set<MethodData> methods();

    public Set<FieldData> fields();

    default public boolean contains(JavaType type) {
        return this.classes().contains(type);
    }

    default public boolean contains(MethodData methodData) {
        return this.methods().contains(methodData);
    }

    default public boolean contains(FieldData fieldData) {
        return this.fields().contains(fieldData);
    }

    default public void forEachClass(BiConsumer<JavaType, JavaType> action) {
        this.classes().forEach(original -> action.accept((JavaType)original, this.getNewType((JavaType)original)));
    }

    default public void forEachMethod(BiConsumer<MethodData, MethodData> action) {
        this.methods().forEach(original -> action.accept((MethodData)original, this.getNewMethod((MethodData)original)));
    }

    default public void forEachField(BiConsumer<FieldData, FieldData> action) {
        this.fields().forEach(original -> action.accept((FieldData)original, this.getNewField((FieldData)original)));
    }

    default public Mappings transform(Mappings original) {
        HashMap<JavaType, JavaType> types = new HashMap<JavaType, JavaType>();
        HashMap<MethodData, MethodData> methods = new HashMap<MethodData, MethodData>();
        HashMap<FieldData, FieldData> fields = new HashMap<FieldData, FieldData>();
        original.classes().forEach(originalType -> {
            JavaType newType = this.getNewType((JavaType)originalType);
            types.put((JavaType)originalType, newType);
        });
        original.methods().forEach(originalMethodData -> {
            MethodData newMethodData = this.getNewMethod((MethodData)originalMethodData);
            methods.put((MethodData)originalMethodData, newMethodData);
        });
        original.fields().forEach(originalFieldData -> {
            FieldData newFieldData = this.getNewField((FieldData)originalFieldData);
            fields.put((FieldData)originalFieldData, newFieldData);
        });
        return ImmutableMappings.create(types, methods, fields);
    }

    public static ImmutableMappings empty() {
        return ImmutableMappings.EMPTY;
    }

    public static Mappings chain(Mappings ... mappings) {
        return Mappings.chain(Collections.unmodifiableList(Arrays.asList(mappings)));
    }

    public static Mappings chain(List<? extends Mappings> mappings) {
        ImmutableMappings chained = Mappings.empty();
        for (int i = 0; i < mappings.size(); ++i) {
            Mappings mapping = mappings.get(i);
            HashMap classes = new HashMap();
            HashMap methods = new HashMap();
            HashMap fields = new HashMap();
            ImmutableMappings inverted = chained.inverted();
            mapping.forEachClass((original, renamed) -> {
                if (!inverted.contains((JavaType)original)) {
                    classes.put(original, renamed);
                }
            });
            mapping.forEachField((original, renamed) -> {
                if (!inverted.contains((FieldData)original)) {
                    fields.put(original.mapTypes(inverted::getNewType), renamed);
                }
            });
            mapping.forEachMethod((original, renamed) -> {
                if (!inverted.contains((MethodData)original)) {
                    methods.put(original.mapTypes(inverted::getNewType), renamed);
                }
            });
            chained.forEachClass((original, renamed) -> {
                renamed = mapping.getNewType((JavaType)renamed);
                classes.put(original, renamed);
            });
            chained.forEachField((original, renamed) -> {
                renamed = mapping.getNewField((FieldData)renamed);
                fields.put(original, renamed);
            });
            chained.forEachMethod((original, renamed) -> {
                renamed = mapping.getNewMethod((MethodData)renamed);
                methods.put(original, renamed);
            });
            chained = ImmutableMappings.create(Collections.unmodifiableMap(classes), Collections.unmodifiableMap(methods), Collections.unmodifiableMap(fields));
        }
        return chained;
    }

    public static Mappings createRenamingMappings(@Nullable UnaryOperator<JavaType> typeTransformer, @Nullable Function<MethodData, String> methodRenamer, @Nullable Function<FieldData, String> fieldRenamer) {
        return new RenamingMappings(typeTransformer, methodRenamer, fieldRenamer);
    }

    public static Mappings createPackageMappings(Map<String, String> packages) {
        return Mappings.createRenamingMappings(original -> {
            String originalPackage = original.getPackageName();
            String newPackage = (String)packages.get(originalPackage);
            if (newPackage != null) {
                return JavaType.fromName(newPackage + "." + original.getSimpleName());
            }
            return original;
        }, null, null);
    }
}

